local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local blingeffect  = require "blingeffect"

local glare = {}
glare.Queue = 500;

glare.RT_downsample1    = 0;
glare.RT_downsample2    = 0;

glare.downsample       = 0;
glare.bling_RO         = 0;

-- local downsample_time = 0;
-- local median_time = 0;
-- local tempral_time = 0;
-- local compute_threshold_time = 0;
-- local compute_bling_time = 0;
-- local render_bling_time = 0;
-- local all_time = 0;


local TargetArea_reflector = {
  uiType = "Combo",
  value = {
    ["Default"] = 0,
    ["MaskTex"] = 1,
  }
};

local ColorMode_reflector = {
  uiType = "Combo",
  value = {
    ["OriColor"] = 0,
    ["MixColor"] = 1,
    ["Rang"] = 2,
  }
};

local ColorA_reflector = {
  uiType = "ColorSelector",
  value = mathfunction.Color(1.0, 1.0, 1.0, 1.0);
};

local ColorB_reflector = {
  uiType = "ColorSelector",
  value = mathfunction.Color(1.0, 1.0, 1.0, 1.0);
};

local Shape_reflector = {
  uiType = "Combo",
  value = {
    ["Straight Star"] = 1,
    ["Three-Pointed Star"] = 2,
    ["Cross"] = 3,
    ["Pentagram"] = 4,
    ["Hexagram"] = 5,
    ["Texture"] = 6,
  }
};

local ShapePath = {
  "eddc:internal_fodder/glare/Bling1.png",
  "eddc:internal_fodder/glare/Bling2.png",
  "eddc:internal_fodder/glare/Bling3.png",
  "eddc:internal_fodder/glare/Bling4.png",
  "eddc:internal_fodder/glare/Bling5.png",
};

local Size_reflector = {
  uiType = "DragFloatMinMax",
  min = 0,
  max = 500,
};


local GlareNum_reflector = {
  uiType = "DragFloatMinMax",
  min = 0,
  max = 200,
};

local Threshold_reflector = {
  uiType = "DragFloatMinMax",
  min = 0,
  max = 255,
};

local Detection_Area_reflector = {
  uiType = "DragFloatMinMax",
  min = 0,
  max = 100000,
};




local BLEND_NORMAL = 0
local BLEND_MULTIPLY = 1
local BLEND_SCREEN = 2
local BLEND_HUE = 3
local BLEND_SATURATION = 4
local BLEND_LUMINOSITY = 5
local BLEND_COLOR = 6
local BLEND_BLEND = 7

local BLEND_EXCLUSION = 8
local BLEND_HARDLIGHT = 9
local BLEND_VIVIDLIGHT = 10
local BLEND_OVERLAY = 11
local BLEND_COLORBURN = 12
local BLEND_COLORDODGE = 13
local BLEND_SOFTLIGHT = 14
local BLEND_HARDMIX = 15
local BLEND_PINLIGHT = 16
local BLEND_LINEARLIGHT = 17
local BLEND_DIFF = 18
local BLEND_LINEARBURN = 19
local BLEND_SUB = 20
local BLEND_LUT = 21

local BLEND_ADD = 22

local BlendMode_reflector = {
  uiType = "Combo",
  value = {
    ["Normal"] = 1,       -- 正常
    --["Darken[heavy]"] = 2,       -- 变暗
    --["Multiply"] = 3,     -- 正片叠加
    --["Color_burn[heavy]"] = 4,   -- 颜色加深

    --["Linear_burn[heavy]"] = 5,  -- 线性加深
    --["Dark[heavy]"] = 6,         -- 深色
    --["Lighten[heavy]"] = 7,      -- 变亮
    ["Screen"] = 8,       -- 滤色

    -- ["Color_dodge[heavy]"] = 9,  -- 颜色减淡
    -- ["Linear_dodge[heavy]"] = 10, -- 线性减淡(添加)
    -- ["Light[heavy]"] = 11,        -- 线色
    -- ["Overlay[heavy]"] = 12,      -- 叠加

    -- ["Soft_light[heavy]"] = 13,   -- 柔光
    -- ["Hard_light[heavy]"] = 14,   -- 强光
    -- ["Vivid_light[heavy]"] = 15,  -- 亮光
    -- ["Linear_light[heavy]"] = 16, -- 线性光

    -- ["Pin_light[heavy]"] = 17,    -- 点光
    -- ["Hard_mix[heavy]"] = 18,     -- 实色混合
    -- ["Difference[heavy]"] = 19,   -- 差值
    -- ["Exclusion[heavy]"] = 20,    -- 排除

    -- ["Subtract[heavy]"] = 21,     -- 减去
    -- ["Divide[heavy]"] = 22,       -- 划分

    -- ["Hue[heavy]"] = 23,          -- 色相
    -- ["Saturation[heavy]"] = 24,   -- 饱和度
    -- ["Color[heavy]"] = 25,        -- 颜色
    -- ["Luminosity[heavy]"] = 26,   -- 透明度
    -- ["Blend[heavy]"] = 27,        -- 融合

    ["Add"] = 28,
  }
};

local CombineValues = 
{ -- {src, dst, shader里的blendmode, lut路径}
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_NORMAL, "comm:documents/make_up/lut/white.png"},   --Normal
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_LUT, "comm:documents/make_up/lut/darken.png"},           --Dark
{apolloengine.MaterialEntity.BL_DST_COLOR, apolloengine.MaterialEntity.BL_ZERO, BLEND_MULTIPLY, "comm:documents/make_up/lut/white.png"},  --Multiply            
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_COLORBURN, "comm:documents/make_up/lut/white.png"},    --Color_burn      

{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_LINEARBURN, "comm:documents/make_up/lut/white.png"},  --linear burn                    
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_LUT, "comm:documents/make_up/lut/dark.png"}, --dark                          
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_LUT, "comm:documents/make_up/lut/lighten.png"},     --Lighten                        
{apolloengine.MaterialEntity.BL_ONE, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_COLOR, BLEND_SCREEN, "comm:documents/make_up/lut/white.png"},             --Screen

{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_COLORDODGE, "comm:documents/make_up/lut/white.png"},  --Color_dodge                      
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_LUT, "comm:documents/make_up/lut/lineardodge.png"},  --Linear_dodge               
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_LUT, "comm:documents/make_up/lut/light.png"},  --Light                
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_OVERLAY, "comm:documents/make_up/lut/white.png"},  --Overlay

{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_SOFTLIGHT, "comm:documents/make_up/lut/white.png"}, --Soft_light                                                        
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_HARDLIGHT, "comm:documents/make_up/lut/white.png"}, --Hard_light                        
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_VIVIDLIGHT, "comm:documents/make_up/lut/white.png"},  --Vivid_light                               
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_LINEARLIGHT, "comm:documents/make_up/lut/white.png"},  --Linear_light 

{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_PINLIGHT, "comm:documents/make_up/lut/white.png"},  --Pin_light                            
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_HARDMIX, "comm:documents/make_up/lut/white.png"},  --Hard_mix                               
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_DIFF, "comm:documents/make_up/lut/white.png"},  --Difference                              
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_EXCLUSION, "comm:documents/make_up/lut/white.png"},  --Exclusion 

{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_SUB, "comm:documents/make_up/lut/white.png"},  --Subtract                            
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_LUT, "comm:documents/make_up/lut/div.png"},  --Divide 

{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_HUE, "comm:documents/make_up/lut/white.png"},  --Hue                               
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_SATURATION, "comm:documents/make_up/lut/white.png"},  --Saturation
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_COLOR, "comm:documents/make_up/lut/white.png"},  --Color                             
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_LUMINOSITY, "comm:documents/make_up/lut/white.png"},  --Luminosity
{apolloengine.MaterialEntity.BL_SRC_ALPHA, apolloengine.MaterialEntity.BL_ONE_MINUS_SRC_ALPHA, BLEND_BLEND, "comm:documents/make_up/lut/white.png"},  --Blend
{apolloengine.MaterialEntity.BL_ONE, apolloengine.MaterialEntity.BL_ONE, BLEND_ADD, "comm:documents/make_up/lut/white.png"},    --Add                        
};


function glare:Initialize(host, size)

  self.downsample_factor1   = mathfunction.vector2(0.25, 0.25);
  self.downsample_size1     = size * self.downsample_factor1;

  self.RT_TextureStream1     = apolloengine.TextureStream();
  self.RT_TextureStream2     = apolloengine.TextureStream();

  
  self.TargetArea           = mathfunction.vector1(0.0);
  self.MaskTex              = apolloengine.TextureEntity();
  self.ColorMode            = mathfunction.vector1(0.0);
  self.MaxSize              = mathfunction.vector1(200);
  self.MinSize              = mathfunction.vector1(100);
  self.GlareNum             = mathfunction.vector1(80);
  self.ColorRangA           = mathfunction.vector4(1.0, 1.0, 1.0, 1.0);
  self.ColorRangB           = mathfunction.vector4(1.0, 1.0, 1.0, 1.0);
  self.BlingShape           = mathfunction.vector1(3.0);
  self.BlendMode            = mathfunction.vector1(1.0);
  self.OldBlendMode         = self.BlendMode;
  self.lutTex               = self:_LoadTexture("comm:documents/make_up/lut/white.png");
  self.PreDefinedTex        = self:_LoadTexture(ShapePath[self.BlingShape:x()]);
  self.BlingTexture         = self:_LoadTexture(ShapePath[self.BlingShape:x()]);
  self.BackGround           = true;
  self.AdvancedSettings     = true;
  self.Min_detection_area   = mathfunction.vector1(3.0);
  self.AutoThreshold        = false;
  self.Threshold            = mathfunction.vector1(130);
  self.BinaryOutput         = false;

  
  self.OstuThreshold        = nil;

  -- self.counter              = 0;
  self.last_frame_valid     = false;


  self:_BackUpState();
 
  self.MAINTEX              = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_MainTex");
  self.MAINSIZE             = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_MainSize");
  self.STEP                 = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_Step");

  self.FRAME_I              = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"FRAME_I");
  self.FRAME_II             = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"FRAME_II");
  self.FRAME_III            = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"FRAME_III");
  self.WEIGHTS              = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"WEIGHTS");


  self.PIXEL_SIZE           = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"PIXEL_SIZE");
  self.DOWNSAMPLE_FACTOR    = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"DOWNSAMPLE_FACTOR");
  self.OUT_TYPE             = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "OUT_TYPE");

  self.THRESHOLD            = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "THRESHOLD");
  self.COLORMODE            = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "_ColorMode");
  self.COLOR_RANGEA         = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "COLOR_RANGEA");
  self.COLOR_RANGEB         = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "COLOR_RANGEB");

  self.OPACITY              = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "OPACITY");
  self.LUTMAP               = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "_LutMap");
  self.BLENDSRC             = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "_BlendSrc");
  self.BLENDDST             = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "_BlendDst");
  self.BLENDMODE            = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "_BlendMode");
  self.MASK_VALID           = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "MASK_VALID");
  self.MASKTEX              = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM, "MaskTex");

  self:_InitializeBling();

  self.medianXObj = host:CreateRenderObject();
  self.medianXMatrial = host:CreateMaterial("comm:documents/material/median.material");
  self.medianXMatrial:SetParameter(self.MAINSIZE, size);
  self.medianXMatrial:SetParameter(self.STEP, mathfunction.vector2(1.0, 0.0));

  self.medianYObj = host:CreateRenderObject();
  self.medianYMatrial = host:CreateMaterial("comm:documents/material/median.material");
  self.medianYMatrial:SetParameter(self.MAINSIZE, size);
  self.medianYMatrial:SetParameter(self.STEP, mathfunction.vector2(0.0, 1.0));

  self.temporal_filterObj = host:CreateRenderObject();
  self.temporal_filterMaterial = host:CreateMaterial("comm:documents/material/glare/temporal_filter.material");
  self.temporal_filterMaterial:SetParameter(self.WEIGHTS, mathfunction.vector3(0.0, 0.5, 0.5));

  self.downsampleObj = host:CreateRenderObject();
  self.downsampleMaterial = host:CreateMaterial("comm:documents/material/glare/downsample.material");
  self.downsampleMaterial:SetParameter(self.PIXEL_SIZE, mathfunction.vector2(1.0/size:x(), 1.0/size:y()));
  self.downsampleMaterial:SetParameter(self.DOWNSAMPLE_FACTOR, self.downsample_factor1);
  self.downsampleMaterial:SetParameter(self.OUT_TYPE, mathfunction.vector1(1.0));
  
  
  self.gray2binaryObj = host:CreateRenderObject();
  self.gray2binaryMaterial = host:CreateMaterial("comm:documents/material/glare/gray2binary.material");

  self.blitObj = host:CreateRenderObject();
  self.blitMaterial = host:CreateMaterial("comm:documents/material/imageblit.material");

  self.bling_RO = self:_CreateBlingRenderObj(host);
  self.bling_Material:SetParameter(self.PIXEL_SIZE, mathfunction.vector2(1.0/size:x(), 1.0/size:y()));
  self.bling_Material:SetParameter(self.OPACITY, mathfunction.vector1(1.0));
  self.bling_Material:SetParameter(self.COLORMODE, self.ColorMode);
  self.bling_Material:SetParameter(self.COLOR_RANGEA, mathfunction.vector3(self.ColorRangA:x(), self.ColorRangA:y(), self.ColorRangA:z()));
  self.bling_Material:SetParameter(self.COLOR_RANGEB, mathfunction.vector3(self.ColorRangB:x(), self.ColorRangB:y(), self.ColorRangB:z()));
  -- initialize to Normal Blend Mode
  self.bling_Material:SetParameter(self.BLENDSRC, mathfunction.vector1(4.0));
  self.bling_Material:SetParameter(self.BLENDDST, mathfunction.vector1(5.0));
  self.bling_Material:SetParameter(self.BLENDMODE, mathfunction.vector1(0.0));
  self.bling_Material:SetParameter(self.LUTMAP, self.lutTex);

  self.bling_Material:SetParameter(self.MASK_VALID, self.TargetArea);
  self.bling_Material:SetParameter(self.MASKTEX, self.MaskTex);


  self.RT_write_downsample = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
    apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
    apolloengine.RenderTargetEntity.ST_SWAP_A,
    mathfunction.vector4(0, 0, self.downsample_size1:x(), self.downsample_size1:y()),
    self.downsample_size1,
    self.downsample_factor1), 
    apolloengine.TextureBufferMetadata(self.downsample_size1,
    apolloengine.TextureEntity.TT_TEXTURE2D,
    apolloengine.TextureEntity.TU_READ,
    apolloengine.TextureEntity.PF_R8G8B8A8,
    1, false,
    apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
    apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
    apolloengine.TextureEntity.TF_NEAREST,
    apolloengine.TextureEntity.TF_NEAREST));
  
  self.RT_read_downsample = host:CreateRenderTarget(
    apolloengine.RenderTargetMetadata(
    apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
    apolloengine.RenderTargetEntity.ST_SWAP_B,
    mathfunction.vector4(0, 0, self.downsample_size1:x(), self.downsample_size1:y()),
    self.downsample_size1,
    self.downsample_factor1), 
    apolloengine.TextureBufferMetadata(self.downsample_size1,
    apolloengine.TextureEntity.TT_TEXTURE2D,
    apolloengine.TextureEntity.TU_READ,
    apolloengine.TextureEntity.PF_R8G8B8A8,
    1, false,
    apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
    apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
    apolloengine.TextureEntity.TF_NEAREST,
    apolloengine.TextureEntity.TF_NEAREST));

  self.last_frame = host:CreateRenderTarget( 
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
      mathfunction.vector4(0, 0, self.downsample_size1:x(),self. downsample_size1:y()),
      self.downsample_size1,
      self.downsample_factor1), 
      apolloengine.TextureBufferMetadata(self.downsample_size1,
      apolloengine.TextureEntity.TT_TEXTURE2D,
      apolloengine.TextureEntity.TU_READ,
      apolloengine.TextureEntity.PF_R8G8B8A8,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_NEAREST,
      apolloengine.TextureEntity.TF_NEAREST));

  self.RT_write = host:CreateRenderTarget( 
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_C,
      mathfunction.vector4(0, 0, size:x(), size:y()),
      size,
      mathfunction.vector2(1.0, 1.0)), 
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_C,
      size));
  
  self.RT_read = host:CreateRenderTarget( 
    apolloengine.RenderTargetMetadata(
      apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
      apolloengine.RenderTargetEntity.ST_SWAP_D,
      mathfunction.vector4(0, 0, size:x(), size:y()),
      size,
      mathfunction.vector2(1.0, 1.0)), 
    apolloengine.TextureRenderMetadata(
      apolloengine.RenderTargetEntity.ST_SWAP_D,
      size));

 
    host:RegisterScriptParameter(self,"TargetArea", TargetArea_reflector);
    host:RegisterScriptParameter(self,"MaskTex");
    host:RegisterScriptParameter(self,"ColorMode", ColorMode_reflector);
    host:RegisterScriptParameter(self,"BlingTexture");
    host:RegisterScriptParameter(self,"MaxSize", Size_reflector);
    host:RegisterScriptParameter(self,"MinSize", Size_reflector);
    host:RegisterScriptParameter(self,"GlareNum", GlareNum_reflector);
    host:RegisterScriptParameter(self,"ColorRangA", ColorA_reflector);
    host:RegisterScriptParameter(self,"ColorRangB", ColorB_reflector);
    host:RegisterScriptParameter(self,"BlingShape", Shape_reflector);
    host:RegisterScriptParameter(self,"BlendMode", BlendMode_reflector);
    host:RegisterScriptParameter(self,"BackGround");
    host:RegisterScriptParameter(self,"AdvancedSettings");
    host:RegisterScriptParameter(self,"AutoThreshold");
    host:RegisterScriptParameter(self,"Threshold", Threshold_reflector);
    host:RegisterScriptParameter(self,"Min_detection_area", Detection_Area_reflector);
    host:RegisterScriptParameter(self,"BinaryOutput");
    host:RegisterScriptParameter(self,"PreDefinedTex");

    return self.Queue;
end

function glare:Resizeview(size)
  self.downsample_size1     = size * self.downsample_factor1;

  self:_UpdateConfig();
  self.medianXMatrial:SetParameter(self.MAINSIZE, size);
  self.medianYMatrial:SetParameter(self.MAINSIZE, size);
  self.downsampleMaterial:SetParameter(self.PIXEL_SIZE, mathfunction.vector2(1.0/size:x(), 1.0/size:y()));
  self.bling_Material:SetParameter(self.PIXEL_SIZE, mathfunction.vector2(1.0/size:x(), 1.0/size:y()));
end

function glare:Process(context, Original, Scene, Output)
  
  -- local start = self:_GetTimeValue();
  self:_Updateparameters();
  
  -- local begintime = self:_GetTimeValue();
  ------------------------------------------------------------------------------------------------------------- 
  context:BeginRenderPass(self.RT_write_downsample,apolloengine.RenderTargetEntity.CF_COLOR);
  self.downsampleMaterial:SetParameter(self.OUT_TYPE, mathfunction.vector1(1.0));
  self.downsampleMaterial:SetParameter(self.DOWNSAMPLE_FACTOR, self.downsample_factor1);
  self.downsampleMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  context:Draw(self.downsampleObj, self.downsampleMaterial);
  context:EndRenderPass();

  self.RT_read_downsample, self.RT_write_downsample = self:_Swap(self.RT_read_downsample, self.RT_write_downsample);
  
  -- downsample_time  = downsample_time + self:_GetTimeValue() - begintime;
  -------------------------------------------------------------------------------------------------------------
  -- begintime = self:_GetTimeValue();
  context:BeginRenderPass(self.RT_write_downsample,apolloengine.RenderTargetEntity.CF_COLOR);
  self.medianXMatrial:SetParameter(
		self.MAINTEX,
		self.RT_read_downsample:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  context:Draw(self.medianXObj, self.medianXMatrial);
  context:EndRenderPass();
  
  self.RT_read_downsample, self.RT_write_downsample = self:_Swap(self.RT_read_downsample, self.RT_write_downsample);
  -------------------------------------------------------------------------------------------------------------
  context:BeginRenderPass(self.RT_write_downsample,apolloengine.RenderTargetEntity.CF_COLOR);
  self.medianYMatrial:SetParameter(
		self.MAINTEX,
		self.RT_read_downsample:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
    context:Draw(self.medianYObj, self.medianYMatrial);
    context:EndRenderPass();
  
  self.RT_read_downsample, self.RT_write_downsample = self:_Swap(self.RT_read_downsample, self.RT_write_downsample);

  -- median_time  = median_time + self:_GetTimeValue() - begintime;
  -------------------------------------------------------------------------------------------------------------
  -- begintime = self:_GetTimeValue();
  context:BeginRenderPass(self.RT_write_downsample,apolloengine.RenderTargetEntity.CF_COLOR);
  if self.last_frame_valid then
    self.temporal_filterMaterial:SetParameter(self.FRAME_II,  self.last_frame:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  else
    self.temporal_filterMaterial:SetParameter(self.FRAME_II,  self.RT_read_downsample:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
    self.last_frame_valid = true;
  end
  self.temporal_filterMaterial:SetParameter(self.FRAME_III,  self.RT_read_downsample:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  context:Draw(self.temporal_filterObj, self.temporal_filterMaterial);
  context:EndRenderPass();

  self.RT_read_downsample, self.RT_write_downsample = self:_Swap(self.RT_read_downsample, self.RT_write_downsample);
  -- tempral_time  = tempral_time + self:_GetTimeValue() - begintime;
  ------------------------------------------------------------------------------------------------------------ 
  context:BeginRenderPass(self.last_frame,apolloengine.RenderTargetEntity.CF_COLOR);
  self.blitMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		self.RT_read_downsample:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  context:Draw(self.blitObj, self.blitMaterial);
  context:EndRenderPass();
  -------------------------------------------------------------------------------------------------------------
  -- begintime = self:_GetTimeValue();
  if self.AutoThreshold then
    self.OstuThreshold = self:_ComputeThreshold(self.bling_creator1, self.RT_read_downsample);

    -- ERROR(string.format("Threshold: % d", self.OstuThreshold));
  end
  -- compute_threshold_time  = compute_threshold_time + self:_GetTimeValue() - begintime;

  context:BeginRenderPass(self.RT_write_downsample,apolloengine.RenderTargetEntity.CF_COLOR);
  if self.AutoThreshold then
    self.gray2binaryMaterial:SetParameter(self.THRESHOLD, mathfunction.vector1(self.OstuThreshold/255));
  else
    self.gray2binaryMaterial:SetParameter(self.THRESHOLD, mathfunction.vector1(self.Threshold:x()/255));
  end
  self.gray2binaryMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    self.RT_read_downsample:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  context:Draw(self.gray2binaryObj, self.gray2binaryMaterial);
  context:EndRenderPass();

  self.RT_read_downsample, self.RT_write_downsample = self:_Swap(self.RT_read_downsample, self.RT_write_downsample);
  -------------------------------------------------------------------------------------------------------------
  -- begintime = self:_GetTimeValue();
  self:_SetupRenderer(self.bling_creator1, self.RT_read_downsample);
  -- compute_bling_time  = compute_bling_time + self:_GetTimeValue() - begintime;
  -------------------------------------------------------------------------------------------------------------
  -- begintime = self:_GetTimeValue();
  context:BeginRenderPass(Output,apolloengine.RenderTargetEntity.CF_COLOR, mathfunction.Color(0.0,0.0,0.0,0.0));
  local BackGroundOut = self.BinaryOutput and self.RT_read_downsample or Scene;
  if self.BackGround then
    self.blitMaterial:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      BackGroundOut:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
    context:Draw(self.blitObj, self.blitMaterial);
    context:EndRenderPass();
  end

  self.RT_read_downsample, self.RT_write_downsample = self:_Swap(self.RT_read_downsample, self.RT_write_downsample);
  
  context:BeginRenderPass(Output);
  local galreTex = (self.BlingShape:x() ~= 6) and self.PreDefinedTex or self.BlingTexture;
  self.bling_Material:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    galreTex);
  self.bling_Material:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_GLOSSINESS,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ));
  context:Draw(self.bling_RO, self.bling_Material);
  context:EndRenderPass();
  
  -- render_bling_time  = render_bling_time + self:_GetTimeValue() - begintime;
  -- all_time  = all_time + self:_GetTimeValue() - start;



  -- self.counter  = self.counter + 1;

  -- if self.counter == 1 then
  
  --   downsample_time  = downsample_time / self.counter;
  --   median_time  = median_time / self.counter;
  --   tempral_time  = tempral_time / self.counter;
  --   compute_threshold_time  = compute_threshold_time / self.counter;
  --   compute_bling_time  = compute_bling_time / self.counter;
  --   render_bling_time  = render_bling_time / self.counter;
  --   all_time  = all_time / self.counter;

  --   self.counter = 0;

  --   ERROR(string.format("LUA downsample time: %f", downsample_time));
  --   ERROR(string.format("LUA median time: %f", median_time));
  --   ERROR(string.format("LUA temporal time: %f", tempral_time));
  --   ERROR(string.format("LUA compute threshold time: %f", compute_threshold_time));
  --   ERROR(string.format("LUA compute bling time: %f", compute_bling_time));
  --   ERROR(string.format("LUA render bling time: %f", render_bling_time));
  --   ERROR(string.format("LUA all time: %f", all_time));
    
  --   downsample_time = 0;
  --   median_time = 0;
  --   tempral_time = 0;
  --   compute_threshold_time = 0;
  --   compute_bling_time = 0;
  --   render_bling_time = 0;
  --   all_time = 0;

  -- end

end

function glare:_Swap(a,b)
  return b, a;
end

function glare:_SetupRenderer(bling_creator, RT)
    local tex_downsample = RT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 );
    tex_downsample:ReadTexture(self.RT_TextureStream1);
    local bling_stream  = bling_creator:GetSmoothBlingBillboard(self.RT_TextureStream1);
    if bling_stream then
      self.bling_RO:ChangeVertices(bling_stream);
      local vert_num = bling_creator:GetBlingNum() * 6;
      self.bling_RO:SetDrawCount(vert_num);
    else
      self.bling_RO:SetDrawCount(0);
    end
end

function glare:_ComputeThreshold(bling_creator, RT)
  local tex_downsample = RT:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 );
    tex_downsample:ReadTexture(self.RT_TextureStream2);
    local T = bling_creator:GetThreshold(self.RT_TextureStream2);
    return T;
end

function glare:_ComputeSize()
  local BlingSizemax = self.MaxSize:x() * self.downsample_factor1:x();
  local BlingSizemin = self.MinSize:x() * self.downsample_factor1:x();

  if BlingSizemin > BlingSizemax then
    BlingSizemin = BlingSizemax;
  end

  return BlingSizemin, BlingSizemax;
end

function glare:_InitializeBling() 

  local bling_size_min, bling_size_max = self:_ComputeSize();
  local Max_Detection_Area =  self.downsample_size1:x() * self.downsample_size1:y() / 64;

  self.blingconfig1  = blingeffect.GlareEffectConfig();
  self.blingconfig1:SetFrameWidth(self.downsample_size1:x());
  self.blingconfig1:SetFrameHeight(self.downsample_size1:y());
  self.blingconfig1:SetMaxBlingSize(bling_size_max);                          -- maximum size (in pixel) of the bling
  self.blingconfig1:SetMinBlingSize(bling_size_min);                          -- maximum size (in pixel) of the bling
  self.blingconfig1:SetMaxBlingNum(self.GlareNum:x());                       -- maximum number of blings that can be generated on one frame
  self.blingconfig1:SetMinDetectionArea(self.Min_detection_area:x());
  self.blingconfig1:SetMaxDetectionArea(Max_Detection_Area);

  self.bling_creator1   = blingeffect.GlareEffect(self.blingconfig1);
end

function glare:_CreateBlingRenderObj(host)
  local dummy_stream = apolloengine.VertexStream();
  dummy_stream:ReserveBuffer(self.blingconfig1:GetMaxBlingNum() * 6);
  dummy_stream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
                                    apolloengine.VertexBufferEntity.DT_FLOAT,
                                    apolloengine.VertexBufferEntity.DT_FLOAT,
                                    4);
  dummy_stream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
                                    apolloengine.VertexBufferEntity.DT_FLOAT,
                                    apolloengine.VertexBufferEntity.DT_FLOAT,
                                    2);
  dummy_stream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE1,
                                    apolloengine.VertexBufferEntity.DT_FLOAT,
                                    apolloengine.VertexBufferEntity.DT_FLOAT,
                                    2);
  dummy_stream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE2,
                                    apolloengine.VertexBufferEntity.DT_FLOAT,
                                    apolloengine.VertexBufferEntity.DT_FLOAT,
                                    2);
  local bling_RO = host:CreateRenderObject(
    apolloengine.RenderObjectMeshMetadate( 
			   apolloengine.RenderComponent.RM_TRIANGLES,
         apolloengine.ReferenceVertexMetadata(        
             apolloengine.VertexBufferEntity.MU_DYNAMIC,
             dummy_stream)));
  self.bling_Material = host:CreateMaterial("comm:documents/material/glare/glare_blend.material");

  return bling_RO;
end

function glare:_LoadTexture(texturePath)
  --local texturePathAbs = venuscore.IFileSystem:PathAssembly(texturePath);
  local texturePathRelative = texturePath;
  local tex = apolloengine.TextureEntity();
  tex:PushMetadata(
    apolloengine.TextureFileMetadata(
                  apolloengine.TextureEntity.TU_WRITE,
                  apolloengine.TextureEntity.PF_R8G8B8A8,
                  1, true,
                  apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
                  apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
                  apolloengine.TextureEntity.TF_LINEAR,
                  apolloengine.TextureEntity.TF_LINEAR,
                  texturePathRelative));
  tex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  tex:CreateResource();

  return tex;
end

function glare:_BackUpState()
  self.OldMaxSize             = self.MaxSize;
  self.OldMinSize             = self.MinSize;
  self.OldMin_detection_area  = self.Min_detection_area;
  self.OldGlareNum            = self.GlareNum;
end

function glare:_UpdateConfig()

  local bling_size_min, bling_size_max = self:_ComputeSize();
  local Max_Detection_Area =  self.downsample_size1:x() * self.downsample_size1:y() / 64;

  self.blingconfig1:SetFrameWidth(self.downsample_size1:x());
  self.blingconfig1:SetFrameHeight(self.downsample_size1:y());
  self.blingconfig1:SetMaxBlingSize(bling_size_max);
  self.blingconfig1:SetMinBlingSize(bling_size_min);
  self.blingconfig1:SetMaxBlingNum(self.GlareNum:x());
  self.blingconfig1:SetMinDetectionArea(self.Min_detection_area:x());
  self.blingconfig1:SetMaxDetectionArea(Max_Detection_Area);

  --self.bling_creator1:UpdateConfig(self.blingconfig1);
  self.bling_creator1   = nil; 
  self.bling_creator1   = blingeffect.GlareEffect(self.blingconfig1);


  self:_BackUpState();
end

function glare: _Updateparameters()

  local needupdate = (self.MaxSize ~= self.OldMaxSize) 
                  or (self.MinSize ~= self.OldMinSize)
                  or (self.OldMin_detection_area ~= self.Min_detection_area)
                  or (self.OldGlareNum ~= self.GlareNum);

  if needupdate == true then
    self:_UpdateConfig();
  end

  
  self.bling_Material:SetParameter(self.COLORMODE, self.ColorMode);
  self.bling_Material:SetParameter(self.COLOR_RANGEA, mathfunction.vector3(self.ColorRangA:x(), self.ColorRangA:y(), self.ColorRangA:z()));
  self.bling_Material:SetParameter(self.COLOR_RANGEB, mathfunction.vector3(self.ColorRangB:x(), self.ColorRangB:y(), self.ColorRangB:z()));
  self.bling_Material:SetParameter(self.MASK_VALID, self.TargetArea);
  self.bling_Material:SetParameter(self.MASKTEX, self.MaskTex);

  if self.BlendMode ~= self.OldBlendMode then
    local combinevalues = CombineValues[self.BlendMode:x()];
    local blendvalues = 
    self.bling_Material:SetParameter(self.BLENDSRC, mathfunction.vector1(combinevalues[1]));
    self.bling_Material:SetParameter(self.BLENDDST, mathfunction.vector1(combinevalues[2]));
    self.bling_Material:SetParameter(self.BLENDMODE, mathfunction.vector1(combinevalues[3]));

    --self.lutTex = self:_LoadTexture(combinevalues[4]);
    --self.bling_RO:SetParameter(self.LUTMAP, self.lutTex);


    self.OldBlendMode = self.BlendMode;
  end
end

function glare:_GetTimeValue()
  return venuscore.ITimerSystem:GetTimevalue();
end
return glare;