require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local fxaa = {}
fxaa.renderObject = nil;
fxaa.queue = 311;

fxaa.material = 0;
fxaa.renderObj = 0;
function fxaa:Initialize(host, size)
  
  self.PIXEL_OFFSETS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"PIXEL_OFFSETS");
  self.FXAA_REDUCE_MIN = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"FXAA_REDUCE_MIN");
  self.FXAA_REDUCE_MUL = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"FXAA_REDUCE_MUL");
  self.FXAA_SPAN_MAX = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"FXAA_SPAN_MAX");
  --self.renderObject = host:CreateRenderObject("comm:documents/material/fxaa.material" );
  self.material = host:CreateMaterial("comm:documents/material/fxaa.material");
  self.renderObj = host:CreateRenderObject();
--   self.renderObject:SetParameter(self.PIXEL_OFFSETS, mathfunction.vector2( 1.0/size:x(), 1.0/size:y() ) );
--   self.renderObject:SetParameter(self.FXAA_REDUCE_MIN, mathfunction.vector1(1.0/64.0) );
--   self.renderObject:SetParameter(self.FXAA_REDUCE_MUL, mathfunction.vector1(1.0/4.0) );
--   self.renderObject:SetParameter(self.FXAA_SPAN_MAX, mathfunction.vector1(16.0) );

  self.material:SetParameter(self.PIXEL_OFFSETS, mathfunction.vector2( 1.0/size:x(), 1.0/size:y() ) );
  self.material:SetParameter(self.FXAA_REDUCE_MIN, mathfunction.vector1(1.0/64.0) );
  self.material:SetParameter(self.FXAA_REDUCE_MUL, mathfunction.vector1(1.0/4.0) );
  self.material:SetParameter(self.FXAA_SPAN_MAX, mathfunction.vector1(16.0) );
  
  return self.queue;

end



function fxaa:Resizeview(size)
  --self.renderObject:SetParameter(self.PIXEL_OFFSETS, mathfunction.vector2( 1.0/size:x(), 1.0/size:y() ) );
  self.material:SetParameter(self.PIXEL_OFFSETS, mathfunction.vector2( 1.0/size:x(), 1.0/size:y() ) );
end



--function fxaa:Process(pipeline, Original, Scene, Output)
function fxaa:Process(context, Original, Scene, Output)
  
    -- Output:PushRenderTarget();
    -- Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR);
    context:BeginRenderPass(Output,apolloengine.RenderTargetEntity.CF_COLOR);
    self.material:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
    --self.renderObject:Draw(pipeline);
    context:Draw(self.renderObj,self.material);
    context:EndRenderPass();
end

return fxaa;
