
#SHADER_DEFINE BrightenCurveVertex

    FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 		  HIGH,	  VEC4,	       "in_Position" },
		{ ATTRIBUTE_COORDNATE0,     HIGH,   VEC2,    "in_TexCooridate" },
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,     HIGH,    VEC2,       "out_TexCooridate" },
	}

#SHADER_CODE
 
    gl_Position = in_Position;
    vec2 out_TexCooridate =  in_TexCooridate;

#END_CODE
#END_DEFINE


#SHADER_DEFINE  BrightenCurveFragment

    FUNCTION_INPUT = 
    {
      	{ TEXTURE_DIFFUSE,           NONE,      TEXTURE2D,  	"inputImageTexture" },
     	{ ATTRIBUTE_COORDNATE0,      HIGH,      VEC2,          "in_TexCoordinate" },
      	{ BRIGHTEN_SCALE,           MEDIU,      FLOAT,                 "in_scale" },
    }

#SHADER_CODE
    vec3 oricolor = texture2D(inputImageTexture, in_TexCoordinate).rgb;
    float r = -oricolor.r * oricolor.r * oricolor.r * oricolor.r * in_scale + oricolor.r * oricolor.r * oricolor.r * in_scale + oricolor.r;
    float g = -oricolor.g * oricolor.g * oricolor.g * oricolor.g * in_scale + oricolor.g * oricolor.g * oricolor.g * in_scale + oricolor.g;
    float b = -oricolor.b * oricolor.b * oricolor.b * oricolor.b * in_scale + oricolor.b * oricolor.b * oricolor.b * in_scale + oricolor.b;
    gl_FragColor = vec4(vec3(r,g,b),1.0);
#END_CODE
#END_DEFINE





#SHADER_DEFINE BrightenScaleVertex

    FUNCTION_INPUT = 
	{
    	{ ATTRIBUTE_POSITION, 		  HIGH,	  VEC4,       "in_Position" },
    	{ ATTRIBUTE_COORDNATE0,     HIGH,   VEC2,   "in_TexCooridate" },
	}
	FUNCTION_OUTPUT =
	{
   		{ ATTRIBUTE_COORDNATE0,     HIGH,    VEC2,       "out_TexCooridate" },
	}

#SHADER_CODE
 
    gl_Position = in_Position;
    vec2 out_TexCooridate =  in_TexCooridate ;

#END_CODE
#END_DEFINE


#SHADER_DEFINE  BrightenScaleFragment

    FUNCTION_INPUT = 
    {
      	{ TEXTURE_DIFFUSE,            NONE,     TEXTURE2D,  	"inputImageTexture" },
      	{ ATTRIBUTE_COORDNATE0,       HIGH,     VEC2,          "in_TexCoordinate" },
      	{ BRIGHTEN_SCALE,             MEDIUM,   FLOAT,                 "in_scale" },
    }

#SHADER_CODE
    vec3 oricolor = texture2D(inputImageTexture, in_TexCoordinate).rgb;
    vec3 newcolor = clamp(oricolor * (1.0 + in_scale),0.0,1.0);
    gl_FragColor = vec4(newcolor,1.0);
#END_CODE
#END_DEFINE
