

#DEFPARAMS

#END

#DEFTAG
ShaderName = "Comic_Combine"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_DIFFUSE2;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_DIFFUSE2_Sampler;
float2 TARGETSIZE;
float SIGMA_R;

v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;

    return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float2 size = TARGETSIZE;
    float2 uv = i.uv;
    float twoSigma2 = 3.0*SIGMA_R*SIGMA_R;
    float2 t = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, uv ).yz;
    float2 vdire = float2( t.x*2.0-1.0 , t.y*2.0-1.0 ) ;
    float2 pointer = float2( vdire.x , vdire.y ) ;
    float acumulo = TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, uv ).x;
    float norma = 1.0 ;
    float avance = 1.0;
    float limit = 2.0 * SIGMA_R ;
    float4 color;
    while ( avance < limit)
{
    color = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, uv + pointer/size);
    float ker = exp( ( -( (avance))) / twoSigma2) ;
    acumulo += ker * color.x;
    norma += ker ;
    float2 tt = color.yz;
    vdire = float2(tt.x*2.0-1.0 , tt.y*2.0-1.0 ) ;
    pointer += vdire ;
    avance ++;
}
// 一正一负
vdire = float2( -(t.x*2.0-1.0) , -(t.y*2.0-1.0) ) ;
pointer = float2( vdire.x , vdire.y ) ;
avance = 1.0;
while ( avance < limit )
{
    color = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, uv + pointer/size);
    float ker = exp( ( -( (avance))) / twoSigma2) ;
    acumulo +=ker * color.x;
    norma +=ker;
    float2 tt = color.yz;
    vdire = float2( -(tt.x*2.0-1.0) , -(tt.y*2.0-1.0 )) ;
    pointer += vdire ;
    avance ++;
}
float finale=smoothstep(0.0, 0.8, acumulo/norma);
float3 original = TEXTURE_DIFFUSE2.Sample(TEXTURE_DIFFUSE2_Sampler, uv).xyz;
// float3 original = float3(1.0,1.0,1.0);

float overlayeralfa =1.0- finale ;
original=float3(original.x* (1.0-overlayeralfa*overlayeralfa*overlayeralfa),original.y* (1.0-overlayeralfa*overlayeralfa),original.z* (1.0-overlayeralfa*overlayeralfa));
mainColor = float4(original , 1.0);
}

ENDCG
#END
