#SHADER_DEFINE ContrastFilterVertex

	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
#END_CODE
#END_DEFINE


#SHADER_DEFINE ContrastFilterFragment  

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
    { ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
    { CONTRAST, 		HIGH,	FLOAT,		"contrast"},
	}

#SHADER_CODE

     vec4 textureColor = texture2D(uniCurrentTexture, in_TexCooridate);          
     gl_FragColor = vec4(((textureColor.rgb - vec3(0.5)) * contrast + vec3(0.5)), textureColor.w);


#END_CODE
#END_DEFINE