#DEFPARAMS
fiberRadius          = { "Fiber radius", FLOAT, "0.002" },
fiberRatio           = { "fiber radio", FLOAT, "0.06" },
NumVerticesPerStrand = { "NumVerticesPerStrand(set by model)", FLOAT, "32"},
baseColor            = { "Base Color", VEC4, "1.0, 1.0, 1.0, 0.63" },
tipColor             = { "Tip Color", VEC4, "1.0, 1.0, 1.0, 0.63" },
tipPercentage        = { "Tip Percentage", FLOAT, "0." },
BaseAlbedoTexture    = {"Base Albedo Texture", TEXTURE2D, "white" },
StrandAlbedoTexture  = {"Strand Albedo Texture", TEXTURE2D, "white" },
TipAlbedoTexture     = {"Tip Albedo Texture", TEXTURE2D, "white" },
StrandUVTilingFactor = { "StrandUV Tiling Factor", FLOAT, "1.0" },
LerpIndex            = { "Lerp Index", FLOAT, "1.0" },

Ka                   = { "KAmbient", FLOAT, "0.0" },
Kd                   = { "KDiffuse", FLOAT, "0.22" },
Ks1                  = { "KSpec1", FLOAT, "0.012" },
Ex1                  = { "Exp1", FLOAT, "14.40" },
Ks2                  = { "KSpec2", FLOAT, "0.136" },
Ex2                  = { "Exp2", FLOAT, "11.80" },

hairshaowAlpha       = { "hair shaow Alpha", FLOAT, "0.35" },
fiberSpacing         = { "fiber Spacing", FLOAT, "0.4" },

[Keywords(THIN_TIP_OFF, THIN_TIP_ON)]
THIN_TIP             = {"Enable Thin Tipn", FLOAT, "1.0"},

[Keywords(STRAND_ALBEDOTEXTURE_OFF, STRAND_ALBEDOTEXTURE_ON)]
STRAND_ALBEDOTEXTURE = {"Enable Strand AlbedoTexture", FLOAT, "0.0"},

#END

#DEFTAG
ShaderName = "Photorealistic_hair_shortcut"
RenderQueue = "Transparent"
#END

#DEFPASS Hair_DepthAlpha
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_BLEND, ZERO, SRC_COLOR, ONE, ONE}
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { DEPTHALPHA }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#pragma multi_compile THIN_TIP_OFF THIN_TIP_ON
#include "hairStrands.inc"
#include "hairLighting.inc"

struct appdata
{
	uint vertexId : SV_VertexID;
	ANI_ATTRIBUTE
};

struct v2f
{
	float4 vertex      : SV_POSITION;
	float4 tangent     : TANGENT;
	float4 p0          : TEXCOORD0;
	float4 p1          : TEXCOORD1;
	float4 StrandColor : TEXCOORD2;
};


float  fiberRadius;
float  fiberRatio;
float  NumVerticesPerStrand;
float4 baseColor;
float4 tipColor;
float  tipPercentage;

float StrandUVTilingFactor;


Texture2D BaseAlbedoTexture;
Texture2D StrandAlbedoTexture;
SamplerState BaseAlbedoTexture_sampler;
SamplerState StrandAlbedoTexture_sampler;


RWTexture2D<uint> HAIR_FIRSTLAYER_DEPTH;
RWTexture2D<uint> HAIR_SECONDLAYER_DEPTH;
RWTexture2D<uint> HAIR_THIRDLAYER_DEPTH;


v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);
	HairStrandParams input;

	input.MatBaseColor              = baseColor;
	input.MatTipColor               = tipColor;
	input.TipPercentage             = tipPercentage;
	input.FiberRatio                = fiberRatio;
	input.FiberRadius               = fiberRadius;
	input.NumVerticesPerStrand      = NumVerticesPerStrand;

#if THIN_TIP_ON
    input.EnableThinTip         = int(1);
#elif THIN_TIP_OFF
    input.EnableThinTip         = int(0);
#endif
    

	HairVertex VertexData       = ExpendHairVertex(v.vertexId, input, BaseAlbedoTexture, BaseAlbedoTexture_sampler);

    v2f o;
	o.vertex      = UniformNDC(VertexData.Position);
    o.tangent     = float4(1, 1, 1, VertexData.Tangent.w); // Only need to preserve the Strand U coordinate as the tangent is not used in this pass.
	//o.p0p1        = VertexData.p0p1;
	o.p0          = VertexData.p0;
	o.p1          = VertexData.p1;
	o.StrandColor = float4(1, 1, 1, VertexData.StrandColor.a); // Don't use the color as it's not needed.
	return o;
}


void frag(in v2f v, out float4 mainColor : SV_Target0)
{
   
	float3 vNDC = ScreenPosToNDC(v.vertex.xyz);
    
	float4 p0p1[2];
	p0p1[0] = mul(v.p0, CAMERA_VIEWPROJ);
	p0p1[1] = mul(v.p1, CAMERA_VIEWPROJ);

	float coverage = ComputeCoverage(p0p1[0].xy/p0p1[0].w, p0p1[1].xy/p0p1[1].w, vNDC.xy);
	float3 vPositionWS = NDCToWorld(vNDC);
	float alpha = coverage * baseColor.a; 
	
    float2 uv = float2(v.tangent.w, v.StrandColor.w);
    float2 strandUV = float2(uv.x, (uv.y * StrandUVTilingFactor) - floor(uv.y * StrandUVTilingFactor));

#if STRAND_ALBEDOTEXTURE_ON
     alpha *= StrandAlbedoTexture.Sample(StrandAlbedoTexture_sampler, strandUV).a;
#endif

    if(alpha < SHORTCUT_MIN_ALPHA)
       discard;


    int2 vScreenAddress = int2(v.vertex.xy);
    uint uDepth = asuint(v.vertex.z);
    uint uDepth0Prev, uDepth1Prev;

     // Min of depth 0 and input depth
    // Original value is uDepth0Prev
    InterlockedMin(HAIR_FIRSTLAYER_DEPTH[uint2(vScreenAddress)], uDepth, uDepth0Prev);

    // Min of depth 1 and greater of the last compare
    // If fragment opaque, always use input depth (don't need greater depths)
    uDepth = (alpha > 0.98) ? uDepth : max(uDepth, uDepth0Prev);

    InterlockedMin(HAIR_SECONDLAYER_DEPTH[uint2(vScreenAddress)], uDepth, uDepth1Prev);

    // Min of depth 2 and greater of the last compare
    // If fragment opaque, always use input depth (don't need greater depths)
    uDepth = (alpha > 0.98) ? uDepth : max(uDepth, uDepth1Prev);

    uint uDepth2Prev;
    InterlockedMin(HAIR_THIRDLAYER_DEPTH[uint2(vScreenAddress)], uDepth, uDepth2Prev);

    mainColor = float4(1.0- alpha, 0, 0, 0);
}
ENDCG
#END



#DEFPASS Hair_ForwardBase
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_BLEND, ONE, ONE, ONE, ONE}
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LEQUAL }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { FORWARDBASE }


CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#pragma multi_compile THIN_TIP_OFF THIN_TIP_ON
#pragma multi_compile STRAND_ALBEDOTEXTURE_OFF STRAND_ALBEDOTEXTURE_ON 
#include "hairStrands.inc"
#include "hairLighting.inc"


struct appdata
{
	uint vertexId : SV_VertexID;
	ANI_ATTRIBUTE
};

struct v2f
{
	float4 vertex      : SV_POSITION;
	float4 tangent     : TANGENT;
	float4 p0          : TEXCOORD0;
	float4 p1          : TEXCOORD1;
	float4 StrandColor : TEXCOORD2;
	float4 TexCoord_Fraction : TEXCOORD4;
	SHADOW_COORDS(3)
};


float  fiberRadius;
float  fiberRatio;
float  NumVerticesPerStrand;
float4 baseColor;
float4 tipColor;
float  tipPercentage;

float fiberSpacing;
float hairshaowAlpha; 
float StrandUVTilingFactor;
float LerpIndex;

float Ka;
float Kd;
float Ks1;
float Ex1;
float Ks2;
float Ex2;

Texture2D BaseAlbedoTexture;
Texture2D StrandAlbedoTexture;
Texture2D TipAlbedoTexture;
SamplerState BaseAlbedoTexture_sampler;
SamplerState StrandAlbedoTexture_sampler;
SamplerState TipAlbedoTexture_sampler;


v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);
	HairStrandParams input;

	input.MatBaseColor              = baseColor;
	input.MatTipColor               = tipColor;
	input.TipPercentage             = tipPercentage;
	input.FiberRatio                = fiberRatio;
	input.FiberRadius               = fiberRadius;
	input.NumVerticesPerStrand      = NumVerticesPerStrand;

#if THIN_TIP_ON
    input.EnableThinTip         = int(1);
#elif THIN_TIP_OFF
    input.EnableThinTip         = int(0);
#endif
    

	HairVertex VertexData       = ExpendHairVertex(v.vertexId, input, BaseAlbedoTexture, BaseAlbedoTexture_sampler);

    v2f o;
	o.vertex      = UniformNDC(VertexData.Position);
    o.tangent     = VertexData.Tangent;
	//o.p0p1        = VertexData.p0p1;
	o.p0          = VertexData.p0;
	o.p1          = VertexData.p1;
	o.StrandColor = VertexData.StrandColor;
	o.TexCoord_Fraction = VertexData.TexCoord_Fraction;
	TRANSFER_HAIRSHADOW(o, VertexData.ShadowCoord);

	return o;
}


void frag(in v2f v, out float4 mainColor : SV_Target0)
{
  float3 vNDC = ScreenPosToNDC(v.vertex.xyz);
  float3 vPositionWS = NDCToWorld(vNDC);
  // get all the attibutes needed for hair shading with this function
	NvHair_ShaderAttributes attr;
  attr.P = vPositionWS;
  attr.T = v.tangent.xyz;
  attr.N = 0;
  float3 vViewDirWS = normalize(CAMERA_WORLDPOSITION - vPositionWS);
  attr.V = vViewDirWS;
  attr.texcoords = float4(0.5f, 0.5f, tipPercentage, 1.0f);
  attr.TexCoord_Fraction = v.TexCoord_Fraction;
  attr.TexCoord_Fraction.w = tipPercentage;

  // set up hair material.
  NvHair_Material mat = NvHair_SetMaterial(baseColor, tipColor, Ks1, Ex1, Ks2, Ex2);

  float3 color = float3(0.0f, 0.0f, 0.0f);

  // sample hair color from textures
	float3 hairColor = NvHair_SampleHairColorTex(mat, BaseAlbedoTexture_sampler, TipAlbedoTexture_sampler, BaseAlbedoTexture, TipAlbedoTexture, attr.TexCoord_Fraction, LerpIndex);

#if STRAND_ALBEDOTEXTURE_ON
  hairColor *= StrandAlbedoTexture.Sample(StrandAlbedoTexture_sampler, attr.TexCoord_Fraction.xy).xyz;
#endif

	float4 p0p1[2];
	p0p1[0] = mul(v.p0, CAMERA_VIEWPROJ);
	p0p1[1] = mul(v.p1, CAMERA_VIEWPROJ);
	float coverage = ComputeCoverage(p0p1[0].xy/p0p1[0].w, p0p1[1].xy/p0p1[1].w, vNDC.xy);
	float alpha = coverage;
	// Update the alpha to have proper value (accounting for coverage, base alpha, and strand alpha)
	alpha *= baseColor.a;

	 if (alpha < SHORTCUT_MIN_ALPHA)
        discard;

  color.rgb = NvHair_ComputeHairShading(vPositionWS, attr, mat, hairColor.rgb);

	float selfshadowTerm  = SHADOW_ATTEN_HAIR(v, fiberSpacing, fiberRadius, hairshaowAlpha);
	float shadowTerm      = SHADOW_ATTEN(v);

	mainColor = float4(color * selfshadowTerm * shadowTerm * alpha, alpha);
}
ENDCG
#END


#DEFPASS Depth
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { DEPTHPASS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_skin
#pragma multi_compile THIN_TIP_OFF THIN_TIP_ON
#include "hairStrands.inc"
#include "shadow.inc"


struct appdata
{
    uint vertexId : SV_VertexID;
	ANI_ATTRIBUTE
};

struct v2f
{
    float4 vertex : SV_POSITION;
};

float  fiberRadius;
float  fiberRatio;
float  NumVerticesPerStrand;
float  tipPercentage;

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);

    HairStrandParams input = (HairStrandParams)0;

	input.TipPercentage             = tipPercentage;
	input.FiberRatio                = fiberRatio;
	input.FiberRadius               = fiberRadius;
	input.NumVerticesPerStrand      = NumVerticesPerStrand;


#if THIN_TIP_ON
    input.EnableThinTip         = int(1);
#elif THIN_TIP_OFF
    input.EnableThinTip         = int(0);
#endif

    

	HairVertex VertexData       = ExpendHairShadowVertex(v.vertexId, input);

    //float4 clipPos              = ApplyShadowBias(VertexData.Position);
   
    v2f o;
	o.vertex                    = UniformNDC(VertexData.Position);

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    mainColor = float4(0.0, 0.0, 0.0, 1.0);
}
ENDCG
#END



