CGPROGRAM
#pragma compute CSMain
#define NUM_THREADS 8

float4 _Size;
float3 _UpVel;
float _AmbientT, _DeltaTime, _Sigma, _Kappa;

RWStructuredBuffer<float4> _Velocity;
// RWStructuredBuffer<float> _Temperature;
RWStructuredBuffer<float2> _Density;

[numthreads(NUM_THREADS,NUM_THREADS,NUM_THREADS)]
void CSMain (int3 id : SV_DispatchThreadID)
{
	int idx = dot(id, float3(1, _Size.xw));
    
  float T = _Density[idx].x;
  float D = _Density[idx].y;
  float3 V = _Velocity[idx].xyz;
    
  if (T > _AmbientT)
    V += (_DeltaTime * (T - _AmbientT) * _Sigma - D * _Kappa) * _UpVel;
    
	_Velocity[idx] = float4(V, 0.0);
  
}

ENDCG

