#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "white" },
_MaskTex = { "mask Color", TEXTURE2D, "white" },
#END

#DEFTAG
ShaderName = "Unlight_Transparent"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma multi_compile_skin
#pragma vertex vert
#pragma fragment frag
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D _MainTex;
Texture2D _MaskTex;

SamplerState _MainTexSampler;
SamplerState _MaskTexSampler;

v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	// sample the texture
	outColor= _MainTex.Sample(_MainTexSampler, i.uv);
	float4 maskColor = _MaskTex.Sample(_MaskTexSampler, i.uv);
	outColor.w = outColor.a * maskColor.a;
}
ENDCG
#END
