#ifndef OUTLINE_INC
#define OUTLINE_INC

#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	float3 normal : NORMAL;
	ANI_ATTRIBUTE
};

struct v2f
{
	float4 vertex : SV_POSITION;
};

float  _OutlineWidth;
float4 _OutlineColor;

v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);

	v2f o;
	float4 clippos = ObjectToClipPos(v.vertex);
	float3 normal = ObjectToViewPos(float4(v.normal, 0.0)).xyz;
	float2 offset = mul(CAMERA_PROJECTION, float4(normal.xy, 0, 1)).xy;
	float3 normoffset = float3(offset, 0.01);
	normoffset = normalize(normoffset);
	clippos.xy += normoffset.xy*_OutlineWidth*clippos.w*0.01;
	o.vertex = UniformNDC(clippos);
	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	// sample the texture
	outColor = _OutlineColor;
}

#endif