#DEFPARAMS
UNIFORM_ASPECTRATIO = {"UNIFORM_ASPECTRATIO", FLOAT, "1.0"},
IMAGE_REMAP_PARAMS = {"IMAGE_REMAP_PARAMS", VEC4, "1.0,1.0,0.0,0.0"},
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white"},
UNIFORM_POINT0 = {"UNIFORM_POINT0", VEC2, "2.0,2.0"},
UNIFORM_POINT1 = {"UNIFORM_POINT1", VEC2, "2.0,2.0"},
UNIFORM_POINT2 = {"UNIFORM_POINT2", VEC2, "2.0,2.0"},
UNIFORM_POINT3 = {"UNIFORM_POINT3", VEC2, "2.0,2.0"},
UNIFORM_POINT4 = {"UNIFORM_POINT4", VEC2, "2.0,2.0"},
UNIFORM_POINT5 = {"UNIFORM_POINT5", VEC2, "2.0,2.0"},
UNIFORM_POINT6 = {"UNIFORM_POINT6", VEC2, "2.0,2.0"},
UNIFORM_POINT7 = {"UNIFORM_POINT7", VEC2, "2.0,2.0"},
UNIFORM_POINT8 = {"UNIFORM_POINT8", VEC2, "2.0,2.0"},
UNIFORM_POINT9 = {"UNIFORM_POINT9", VEC2, "2.0,2.0"},
UNIFORM_POINT10 = {"UNIFORM_POINT10", VEC2, "2.0,2.0"},
UNIFORM_POINT11 = {"UNIFORM_POINT11", VEC2, "2.0,2.0"},
UNIFORM_RADIUS0 = {"UNIFORM_RADIUS0", VEC2, "0.0,0.0"},
UNIFORM_RADIUS1 = {"UNIFORM_RADIUS1", VEC2, "0.0,0.0"},
UNIFORM_RADIUS2 = {"UNIFORM_RADIUS2", VEC2, "0.0,0.0"},
UNIFORM_RADIUS3 = {"UNIFORM_RADIUS3", VEC2, "0.0,0.0"},
UNIFORM_RADIUS4 = {"UNIFORM_RADIUS4", VEC2, "0.0,0.0"},
UNIFORM_RADIUS5 = {"UNIFORM_RADIUS5", VEC2, "0.0,0.0"},
UNIFORM_RADIUS6 = {"UNIFORM_RADIUS6", VEC2, "0.0,0.0"},
UNIFORM_RADIUS7 = {"UNIFORM_RADIUS7", VEC2, "0.0,0.0"},
UNIFORM_RADIUS8 = {"UNIFORM_RADIUS8", VEC2, "0.0,0.0"},
UNIFORM_RADIUS9 = {"UNIFORM_RADIUS9", VEC2, "0.0,0.0"},
UNIFORM_RADIUS10 = {"UNIFORM_RADIUS10", VEC2, "0.0,0.0"},
UNIFORM_RADIUS11 = {"UNIFORM_RADIUS11", VEC2, "0.0,0.0"},
UNIFORM_SCALERATIOX0 = {"UNIFORM_SCALERATIOX0", FLOAT, "1.0"},
UNIFORM_SCALERATIOX1 = {"UNIFORM_SCALERATIOX1", FLOAT, "1.0"},
UNIFORM_SCALERATIOX2 = {"UNIFORM_SCALERATIOX2", FLOAT, "1.0"},
UNIFORM_SCALERATIOX3 = {"UNIFORM_SCALERATIOX3", FLOAT, "1.0"},
UNIFORM_SCALERATIOX4 = {"UNIFORM_SCALERATIOX4", FLOAT, "1.0"},
UNIFORM_SCALERATIOX5 = {"UNIFORM_SCALERATIOX5", FLOAT, "1.0"},
UNIFORM_SCALERATIOX6 = {"UNIFORM_SCALERATIOX6", FLOAT, "1.0"},
UNIFORM_SCALERATIOX7 = {"UNIFORM_SCALERATIOX7", FLOAT, "1.0"},
UNIFORM_SCALERATIOX8 = {"UNIFORM_SCALERATIOX8", FLOAT, "1.0"},
UNIFORM_SCALERATIOX9 = {"UNIFORM_SCALERATIOX9", FLOAT, "1.0"},
UNIFORM_SCALERATIOX10 = {"UNIFORM_SCALERATIOX10", FLOAT, "1.0"},
UNIFORM_SCALERATIOX11 = {"UNIFORM_SCALERATIOX11", FLOAT, "1.0"},
UNIFORM_SCALERATIOY0 = {"UNIFORM_SCALERATIOY0", FLOAT, "1.0"},
UNIFORM_SCALERATIOY1 = {"UNIFORM_SCALERATIOY1", FLOAT, "1.0"},
UNIFORM_SCALERATIOY2 = {"UNIFORM_SCALERATIOY2", FLOAT, "1.0"},
UNIFORM_SCALERATIOY3 = {"UNIFORM_SCALERATIOY3", FLOAT, "1.0"},
UNIFORM_SCALERATIOY4 = {"UNIFORM_SCALERATIOY4", FLOAT, "1.0"},
UNIFORM_SCALERATIOY5 = {"UNIFORM_SCALERATIOY5", FLOAT, "1.0"},
UNIFORM_SCALERATIOY6 = {"UNIFORM_SCALERATIOY6", FLOAT, "1.0"},
UNIFORM_SCALERATIOY7 = {"UNIFORM_SCALERATIOY7", FLOAT, "1.0"},
UNIFORM_SCALERATIOY8 = {"UNIFORM_SCALERATIOY8", FLOAT, "1.0"},
UNIFORM_SCALERATIOY9 = {"UNIFORM_SCALERATIOY9", FLOAT, "1.0"},
UNIFORM_SCALERATIOY10 = {"UNIFORM_SCALERATIOY10", FLOAT, "1.0"},
UNIFORM_SCALERATIOY11 = {"UNIFORM_SCALERATIOY11", FLOAT, "1.0"},
UNIFORM_RADIUS_RATIO0 = {"UNIFORM_RADIUS_RATIO0", VEC2, "1.0,1.0"},
UNIFORM_RADIUS_RATIO1 = {"UNIFORM_RADIUS_RATIO1", VEC2, "1.0,1.0"},
UNIFORM_RADIUS_RATIO2 = {"UNIFORM_RADIUS_RATIO2", VEC2, "1.0,1.0"},
UNIFORM_RADIUS_RATIO3 = {"UNIFORM_RADIUS_RATIO3", VEC2, "1.0,1.0"},
UNIFORM_RADIUS_RATIO4 = {"UNIFORM_RADIUS_RATIO4", VEC2, "1.0,1.0"},
UNIFORM_RADIUS_RATIO5 = {"UNIFORM_RADIUS_RATIO5", VEC2, "1.0,1.0"},
UNIFORM_RADIUS_RATIO6 = {"UNIFORM_RADIUS_RATIO6", VEC2, "1.0,1.0"},
UNIFORM_RADIUS_RATIO7 = {"UNIFORM_RADIUS_RATIO7", VEC2, "1.0,1.0"},
UNIFORM_RADIUS_RATIO8 = {"UNIFORM_RADIUS_RATIO8", VEC2, "1.0,1.0"},
UNIFORM_RADIUS_RATIO9 = {"UNIFORM_RADIUS_RATIO9", VEC2, "1.0,1.0"},
UNIFORM_RADIUS_RATIO10 = {"UNIFORM_RADIUS_RATIO10", VEC2, "1.0,1.0"},
UNIFORM_RADIUS_RATIO11 = {"UNIFORM_RADIUS_RATIO11", VEC2, "1.0,1.0"},
UNIFORM_FACEDIR_X0 = {"UNIFORM_FACEDIR_X0", VEC2, "1.0,0.0"},
UNIFORM_FACEDIR_X1 = {"UNIFORM_FACEDIR_X1", VEC2, "1.0,0.0"},
UNIFORM_FACEDIR_X2 = {"UNIFORM_FACEDIR_X2", VEC2, "1.0,0.0"},
UNIFORM_FACEDIR_X3 = {"UNIFORM_FACEDIR_X3", VEC2, "1.0,0.0"},
UNIFORM_FACEDIR_X4 = {"UNIFORM_FACEDIR_X4", VEC2, "1.0,0.0"},
UNIFORM_FACEDIR_X5 = {"UNIFORM_FACEDIR_X5", VEC2, "1.0,0.0"},
UNIFORM_FACEDIR_X6 = {"UNIFORM_FACEDIR_X6", VEC2, "1.0,0.0"},
UNIFORM_FACEDIR_X7 = {"UNIFORM_FACEDIR_X7", VEC2, "1.0,0.0"},
UNIFORM_FACEDIR_X8 = {"UNIFORM_FACEDIR_X8", VEC2, "1.0,0.0"},
UNIFORM_FACEDIR_X9 = {"UNIFORM_FACEDIR_X9", VEC2, "1.0,0.0"},
UNIFORM_FACEDIR_X10 = {"UNIFORM_FACEDIR_X10", VEC2, "1.0,0.0"},
UNIFORM_FACEDIR_X11 = {"UNIFORM_FACEDIR_X11", VEC2, "1.0,0.0"},
#END

#DEFTAG
ShaderName = "faceliquify"
RenderQueue = "Transparent+1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

// lens center coordinate with x&y normalized to -1 and 1
float2 UNIFORM_POINT0;
float2 UNIFORM_POINT1;
float2 UNIFORM_POINT2;
float2 UNIFORM_POINT3;
float2 UNIFORM_POINT4;
float2 UNIFORM_POINT5;
float2 UNIFORM_POINT6;
float2 UNIFORM_POINT7;
float2 UNIFORM_POINT8;
float2 UNIFORM_POINT9;
float2 UNIFORM_POINT10;
float2 UNIFORM_POINT11;
// circle radius
float2 UNIFORM_RADIUS0;
float2 UNIFORM_RADIUS1;
float2 UNIFORM_RADIUS2;
float2 UNIFORM_RADIUS3;
float2 UNIFORM_RADIUS4;
float2 UNIFORM_RADIUS5;
float2 UNIFORM_RADIUS6;
float2 UNIFORM_RADIUS7;
float2 UNIFORM_RADIUS8;
float2 UNIFORM_RADIUS9;
float2 UNIFORM_RADIUS10;
float2 UNIFORM_RADIUS11;
// lens intensityX
float UNIFORM_SCALERATIOX0;
float UNIFORM_SCALERATIOX1;
float UNIFORM_SCALERATIOX2;
float UNIFORM_SCALERATIOX3;
float UNIFORM_SCALERATIOX4;
float UNIFORM_SCALERATIOX5;
float UNIFORM_SCALERATIOX6;
float UNIFORM_SCALERATIOX7;
float UNIFORM_SCALERATIOX8;
float UNIFORM_SCALERATIOX9;
float UNIFORM_SCALERATIOX10;
float UNIFORM_SCALERATIOX11;
// lens intensityY
float UNIFORM_SCALERATIOY0;
float UNIFORM_SCALERATIOY1;
float UNIFORM_SCALERATIOY2;
float UNIFORM_SCALERATIOY3;
float UNIFORM_SCALERATIOY4;
float UNIFORM_SCALERATIOY5;
float UNIFORM_SCALERATIOY6;
float UNIFORM_SCALERATIOY7;
float UNIFORM_SCALERATIOY8;
float UNIFORM_SCALERATIOY9;
float UNIFORM_SCALERATIOY10;
float UNIFORM_SCALERATIOY11;
// ratio of faceX and faceY, normalized with half_width of camera resolution
float2 UNIFORM_RADIUS_RATIO0;
float2 UNIFORM_RADIUS_RATIO1;
float2 UNIFORM_RADIUS_RATIO2;
float2 UNIFORM_RADIUS_RATIO3;
float2 UNIFORM_RADIUS_RATIO4;
float2 UNIFORM_RADIUS_RATIO5;
float2 UNIFORM_RADIUS_RATIO6;
float2 UNIFORM_RADIUS_RATIO7;
float2 UNIFORM_RADIUS_RATIO8;
float2 UNIFORM_RADIUS_RATIO9;
float2 UNIFORM_RADIUS_RATIO10;
float2 UNIFORM_RADIUS_RATIO11;
// unit vector describing face X axis direction (from left eye to right eye)
float2 UNIFORM_FACEDIR_X0;
float2 UNIFORM_FACEDIR_X1;
float2 UNIFORM_FACEDIR_X2;
float2 UNIFORM_FACEDIR_X3;
float2 UNIFORM_FACEDIR_X4;
float2 UNIFORM_FACEDIR_X5;
float2 UNIFORM_FACEDIR_X6;
float2 UNIFORM_FACEDIR_X7;
float2 UNIFORM_FACEDIR_X8;
float2 UNIFORM_FACEDIR_X9;
float2 UNIFORM_FACEDIR_X10;
float2 UNIFORM_FACEDIR_X11;
// height/width of camera resolution
float UNIFORM_ASPECTRATIO;

float4 IMAGE_REMAP_PARAMS;

float3x3 UNIFORM_ZOOMSCALE;

float2 scaleWarpPositionToUse(float2 centerPostion, float2 currentPosition, float radius, float scaleRatio, float aspectRatio)
{

    float2 currentPositionToUse = float2(currentPosition.x, currentPosition.y * aspectRatio);
    float2 centerPostionToUse = float2(centerPostion.x, centerPostion.y * aspectRatio);

    float2  rvec = currentPositionToUse - centerPostionToUse;
    float rdot = dot(rvec, rvec);

    float radius_square = radius * radius;
    if(rdot > radius_square)
    {
        return currentPosition;
    }

    float r = sqrt(rdot);
    float factor = r / radius - 1.0;
    float alpha = 1.0 - scaleRatio * factor * factor;
    float2 positionToUse = centerPostion + alpha * (currentPosition - centerPostion);

    return positionToUse;
}

float2 scaleWarpEllipsePositionToUse(float2 centerPostion, float2 currentPosition, float2 face_dir_x, float r, float2 radiusRatio,float scaleRatioX, float scaleRatioY, float aspectRatio)
{
    float2 face_dir_y = float2(face_dir_x.y, -face_dir_x.x);

    float2 currentPositionToUse = float2(currentPosition.x, currentPosition.y * aspectRatio);
    float2 centerPostionToUse = float2(centerPostion.x, centerPostion.y * aspectRatio);

    float radiusGradient = radiusRatio.y/radiusRatio.x;
 
    float2  rvec = currentPositionToUse - centerPostionToUse;
    rvec = float2(dot(rvec, face_dir_x), dot(rvec, face_dir_y));
    rvec.y = rvec.y/radiusGradient;
    float rdot = dot(rvec, rvec);

    float radius = r * radiusRatio.x;
    float radius_square = radius * radius;
    if(rdot > radius_square)
    {
        return currentPosition;
    }

    float r_ = sqrt(rdot);
    float factor = 1 - r_/radius;
    // float alphaX = 1.0 - scaleRatioX * factor * factor * factor;
    // float alphaY = 1.0 - scaleRatioY * factor * factor * factor; 
    // float alphaX = pow(r_/radius,scaleRatioX-1);
    // float alphaY = pow(r_/radius,scaleRatioY-1);
    // float alphaX = (1 - pow(1 - r_/radius, 1 / scaleRatioX)) / (r_/radius);
    // float alphaY = (1 - pow(1 - r_/radius, 1 / scaleRatioY)) / (r_/radius);
    // float alphaX = (1 / scaleRatioX - 1) * factor * factor + 1;
    // float alphaY = (1 / scaleRatioY - 1) * factor * factor + 1;
    float x = r_/radius;
    float alphaX = (1-pow(1-x,1/scaleRatioX))*(1-x)+pow(x,scaleRatioX+1);
    float alphaY = (1-pow(1-x,1/scaleRatioY))*(1-x)+pow(x,scaleRatioY+1);

    float2 positionToUse = centerPostionToUse + alphaX * rvec.x * face_dir_x /x + alphaY * rvec.y * radiusGradient * face_dir_y /x;
    positionToUse.y = positionToUse.y/aspectRatio;

    return positionToUse;
}

// R the max radius, r the reference inner radius, ellipse_alpha is a/b for ellipse, face_dir_x is the direction vector for x of face

float2 warpObliqueEllipseScalePositionToUse(float2 center, float2 p, float2 face_dir_x, float r, float R, float inten, float ratio, float ellipse_alpha)
{
    // cos(agnle) = face_dir.x; sin(angle) = - face_dir.y;
    float2 face_dir_y = float2(-face_dir_x.y, face_dir_x.x);
    float2 m_point = p;
    float2 p_u = float2(p.x, p.y * ratio + 0.5 - 0.5 * ratio * ellipse_alpha);
    float2 c_u = float2(center.x, center.y * ratio + 0.5 - 0.5 * ratio * ellipse_alpha);
    float2 vec_pc = p_u - c_u;
    float2  p_r = float2(dot(vec_pc, face_dir_x), dot(vec_pc, face_dir_y));

    float d = sqrt(p_r.x * p_r.x + p_r.y * p_r.y * ellipse_alpha * ellipse_alpha);
    float scale = (R - r) / r * inten;
    float r_m = r * (1.0 + scale);
    if (d < r_m)
    {
        float alpha = 1.0 / (1.0 + scale);
        m_point = center + (p - center) * alpha;
    }
    else if (d < R)
    {
        float percent = (R - d) / (R - r_m);
        m_point = center + (p - center) * (R - percent * (R - r)) / d;
    }
	return m_point;
}

v2f vert(appdata v)
{
  #define pts0 UNIFORM_POINT0
  #define pts1 UNIFORM_POINT1
  #define pts2 UNIFORM_POINT2
  #define pts3 UNIFORM_POINT3
  #define pts4 UNIFORM_POINT4
  #define pts5 UNIFORM_POINT5
  #define pts6 UNIFORM_POINT6
  #define pts7 UNIFORM_POINT7
  #define pts8 UNIFORM_POINT8
  #define pts9 UNIFORM_POINT9
  #define pts10 UNIFORM_POINT10
  #define pts11 UNIFORM_POINT11

  #define radius0 UNIFORM_RADIUS0
  #define radius1 UNIFORM_RADIUS1
  #define radius2 UNIFORM_RADIUS2
  #define radius3 UNIFORM_RADIUS3
  #define radius4 UNIFORM_RADIUS4
  #define radius5 UNIFORM_RADIUS5
  #define radius6 UNIFORM_RADIUS6
  #define radius7 UNIFORM_RADIUS7
  #define radius8 UNIFORM_RADIUS8
  #define radius9 UNIFORM_RADIUS9
  #define radius10 UNIFORM_RADIUS10
  #define radius11 UNIFORM_RADIUS11

  #define scaleRatioX0 UNIFORM_SCALERATIOX0
  #define scaleRatioX1 UNIFORM_SCALERATIOX1
  #define scaleRatioX2 UNIFORM_SCALERATIOX2
  #define scaleRatioX3 UNIFORM_SCALERATIOX3
  #define scaleRatioX4 UNIFORM_SCALERATIOX4
  #define scaleRatioX5 UNIFORM_SCALERATIOX5
  #define scaleRatioX6 UNIFORM_SCALERATIOX6
  #define scaleRatioX7 UNIFORM_SCALERATIOX7
  #define scaleRatioX8 UNIFORM_SCALERATIOX8
  #define scaleRatioX9 UNIFORM_SCALERATIOX9
  #define scaleRatioX10 UNIFORM_SCALERATIOX10
  #define scaleRatioX11 UNIFORM_SCALERATIOX11

  #define scaleRatioY0 UNIFORM_SCALERATIOY0
  #define scaleRatioY1 UNIFORM_SCALERATIOY1
  #define scaleRatioY2 UNIFORM_SCALERATIOY2
  #define scaleRatioY3 UNIFORM_SCALERATIOY3
  #define scaleRatioY4 UNIFORM_SCALERATIOY4
  #define scaleRatioY5 UNIFORM_SCALERATIOY5
  #define scaleRatioY6 UNIFORM_SCALERATIOY6
  #define scaleRatioY7 UNIFORM_SCALERATIOY7
  #define scaleRatioY8 UNIFORM_SCALERATIOY8
  #define scaleRatioY9 UNIFORM_SCALERATIOY9
  #define scaleRatioY10 UNIFORM_SCALERATIOY10
  #define scaleRatioY11 UNIFORM_SCALERATIOY11

  #define radiusRatio0 UNIFORM_RADIUS_RATIO0
  #define radiusRatio1 UNIFORM_RADIUS_RATIO1
  #define radiusRatio2 UNIFORM_RADIUS_RATIO2
  #define radiusRatio3 UNIFORM_RADIUS_RATIO3
  #define radiusRatio4 UNIFORM_RADIUS_RATIO4
  #define radiusRatio5 UNIFORM_RADIUS_RATIO5
  #define radiusRatio6 UNIFORM_RADIUS_RATIO6
  #define radiusRatio7 UNIFORM_RADIUS_RATIO7
  #define radiusRatio8 UNIFORM_RADIUS_RATIO8 
  #define radiusRatio9 UNIFORM_RADIUS_RATIO9
  #define radiusRatio10 UNIFORM_RADIUS_RATIO10
  #define radiusRatio11 UNIFORM_RADIUS_RATIO11

  #define face_dir_x0 UNIFORM_FACEDIR_X0
  #define face_dir_x1 UNIFORM_FACEDIR_X1
  #define face_dir_x2 UNIFORM_FACEDIR_X2
  #define face_dir_x3 UNIFORM_FACEDIR_X3
  #define face_dir_x4 UNIFORM_FACEDIR_X4
  #define face_dir_x5 UNIFORM_FACEDIR_X5
  #define face_dir_x6 UNIFORM_FACEDIR_X6
  #define face_dir_x7 UNIFORM_FACEDIR_X7
  #define face_dir_x8 UNIFORM_FACEDIR_X8
  #define face_dir_x9 UNIFORM_FACEDIR_X9
  #define face_dir_x10 UNIFORM_FACEDIR_X10
  #define face_dir_x11 UNIFORM_FACEDIR_X11
  
  float aspectRatio = UNIFORM_ASPECTRATIO;
  float4 image_params = IMAGE_REMAP_PARAMS;
  
  float3x3 zoomscale = transpose(UNIFORM_ZOOMSCALE);

  float4 in_Position = v.in_Position;
  float2 in_TexCooridate = v.in_Coordinate;

  float2 newpos = (mul(float3(in_Position.xy,1.0), zoomscale)).xy;
  float4 outPos = float4(newpos,in_Position.z,in_Position.a);

//   float2 newTexCooridate = float2((newpos.x+1.0)*0.5,(newpos.y+1.0)*0.5);
//   float2 positionToUse  = newTexCooridate * 2.0 - 1.0;
  float2 positionToUse = newpos;


//   for (int i = 0; i<8; i++)
//   {
//       positionToUse = scaleWarpEllipsePositionToUse(pts[i], positionToUse, face_dir_x, radiuses[i][0], radiusRatio, scaleRatios[i][0], aspectRatio);
//     //   positionToUse = scaleWarpPositionToUse(pts[i], positionToUse, radiuses[i][0], scaleRatios[i][0], aspectRatio);

//   }

  positionToUse = scaleWarpEllipsePositionToUse(pts0, positionToUse, face_dir_x0, radius0[0], radiusRatio0, scaleRatioX0, scaleRatioY0, aspectRatio);
  positionToUse = scaleWarpEllipsePositionToUse(pts1, positionToUse, face_dir_x1, radius1[0], radiusRatio1, scaleRatioX1, scaleRatioY1, aspectRatio);
  positionToUse = scaleWarpEllipsePositionToUse(pts2, positionToUse, face_dir_x2, radius2[0], radiusRatio2, scaleRatioX2, scaleRatioY2, aspectRatio);
  positionToUse = scaleWarpEllipsePositionToUse(pts3, positionToUse, face_dir_x3, radius3[0], radiusRatio3, scaleRatioX3, scaleRatioY3, aspectRatio);
  positionToUse = scaleWarpEllipsePositionToUse(pts4, positionToUse, face_dir_x4, radius4[0], radiusRatio4, scaleRatioX4, scaleRatioY4, aspectRatio);
  positionToUse = scaleWarpEllipsePositionToUse(pts5, positionToUse, face_dir_x5, radius5[0], radiusRatio5, scaleRatioX5, scaleRatioY5, aspectRatio);
  positionToUse = scaleWarpEllipsePositionToUse(pts6, positionToUse, face_dir_x6, radius6[0], radiusRatio6, scaleRatioX6, scaleRatioY6, aspectRatio);
  positionToUse = scaleWarpEllipsePositionToUse(pts7, positionToUse, face_dir_x7, radius7[0], radiusRatio7, scaleRatioX7, scaleRatioY7, aspectRatio);
  positionToUse = scaleWarpEllipsePositionToUse(pts8, positionToUse, face_dir_x8, radius8[0], radiusRatio8, scaleRatioX8, scaleRatioY8, aspectRatio);
  positionToUse = scaleWarpEllipsePositionToUse(pts9, positionToUse, face_dir_x9, radius9[0], radiusRatio9, scaleRatioX9, scaleRatioY9, aspectRatio);
  positionToUse = scaleWarpEllipsePositionToUse(pts10, positionToUse, face_dir_x10, radius10[0], radiusRatio10, scaleRatioX10, scaleRatioY10, aspectRatio);
  positionToUse = scaleWarpEllipsePositionToUse(pts11, positionToUse, face_dir_x11, radius11[0], radiusRatio11, scaleRatioX11, scaleRatioY11, aspectRatio);

//   float2 out_TexCooridate =  0.5 * positionToUse + 0.5;
  float2 out_TexCooridate = float2(positionToUse.x * image_params.x + image_params.z, positionToUse.y * image_params.y + image_params.w);

  v2f o;
  float4 pos = ObjectToClipPos(outPos);
  o.vertex = UniformNDC(pos);
  o.out_Coordinate = float2(out_TexCooridate.x, 1.0 - out_TexCooridate.y);
  return o;
}

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	float2 textureCoordinate = i.out_Coordinate.xy;

	mainColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler,float2(clamp(textureCoordinate.x,0.001,0.999),clamp(textureCoordinate.y,0.001,0.999)));
}

ENDCG
#END
