local asynctexture = require "apolloutility.asynctexture.asynctexture"
local emptyimage = require "apolloutility.emptyimage"
local SequenceAnimation = require "apolloutility.sequenceanimation"
local apolloengine = require "apolloengine"
local PupilRneder = require "pupil.pupilrender"
local am = require "mathfunction"
local Object = require "classic"
local vc = require "venuscore"
require "math"



local PupilSequenceAnimation = SequenceAnimation:extend();

function PupilSequenceAnimation:new()
  self.render = PupilRneder(120); --瞳孔渲染对象
end

function PupilSequenceAnimation:Update(def,pointarray)
  PupilSequenceAnimation.super.Update(self,def);
  self.render:Update(pointarray);
end

function PupilSequenceAnimation:SetShow(isShow)
  self.render:SetShow(isShow);
end

function PupilSequenceAnimation:SetupMaterial(alphamode)
  local alpha_mode = nil;
  if alphamode == "add" then
    alpha_mode = "{ALPAH_BLEND, ONE, ONE, SRC_ALPHA, ONE}";
  elseif alphamode == "normal" then
    alpha_mode = "{ ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA , SRC_ALPHA, ONE }";
  else
    alpha_mode = "{ ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA , SRC_ALPHA, ONE }";
  end
  
  self.render:SetupMaterial(alpha_mode);
end


return PupilSequenceAnimation;