
local _DEBUG = true;
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
require "venusdebug"
require "utility"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
local TransNode = require "apolloutility.apollonode.trasnnode"

local main = {}

function main:Timespan()
	local now = venuscore.ITimerSystem:GetTimevalue();
	local def = now - self.begintime;
	self.begintime = now;
	self.cumtime = self.cumtime + def;
	self.fps = self.fps + 1;
	if self.cumtime > 5 then
		local fps = self.fps / self.cumtime;
		self.fps = 0;
		self.cumtime = 0;
		LOG("FPS "..fps);
	end
    return def;
end

function main:CreateLowpoly(path)
	local lowpoly = self.model:GetMeshNode(path);
	self.model:DetachNode(lowpoly);
	lowpoly:SetShow(false);
	table.insert(self.lowpolys, lowpoly);
	return lowpoly;
end

function main:CreateHairSoftBody(lowpoly,config)
	local soft = lowpoly:CreateComponent(apolloengine.Node.CT_SOFT_BODY)
	local meshshape = apolloengine.MeshShape(lowpoly:GetVertexStream(), lowpoly:GetIndexStream());
	table.insert(self.shapes, meshshape);
	soft:Initialize(meshshape ,5.0);
  -- soft:SetLinearStiffness(1);
 	 soft:SetMatch(false,true);
	--soft:SetSoftkDF(0.5);
	soft:SetPoseMatch(0.001);
	--soft:SetMaxVolume(0.1);
	--soft:SetBindConstraintDistance(2);
	soft:SetSoftPiterations(10);
	--soft:SetDamping(0.01);
  
  
  config["mass"] = 5.0;
	config["Stiffness"] = 1;
	config["PoseMatch"] = 0.1;
	config["Piterations"] = 10;
	config["kDF"] = 1;
	config["Magin"] = 0.01;
  
  
	table.insert(self.softs, soft);
	return soft;
end

function main:CreateClothSoftBody(lowpoly, config)
	local soft = lowpoly:CreateComponent(apolloengine.Node.CT_SOFT_BODY)
	local meshshape = apolloengine.MeshShape(lowpoly:GetVertexStream(), lowpoly:GetIndexStream());
	table.insert(self.shapes, meshshape);
	soft:Initialize(meshshape ,50.0);
	config["mass"] = 50.0;
  soft:SetLinearStiffness(0.15);
	config["Stiffness"] = 0.15;
  soft:SetMatch(false,true);
	--soft:SetVolumeConversation(1);
  soft:SetPoseMatch(0.3);
	config["PoseMatch"] = 0.1;
	soft:SetKineticContactHardness(0.8);
	config["KCH"] = 0.8;
	--soft:SetSoftContactHardness(0.1);
	--soft:SetRigidContactHardness(0.1);
	--soft:SetVelocities(20);
  soft:GenerateClusters(0);
	soft:SetSoftPiterations(10);
	config["Piterations"] = 10;
	soft:SetSoftkDF(1);
	config["kDF"] = 1;
	soft:SetMagin(0.01)
	config["Magin"] = 0.01;
 -- soft:AddForce(mathfunction.vector3(0,-300,0));

	table.insert(self.softs, soft);
	return soft;
end

function main:CreatebraSoftBody(lowpoly)
	local soft = apolloengine.SoftBodyComponent();
	local meshshape = apolloengine.MeshShape(lowpoly:GetVertexStream(), lowpoly:GetIndexStream());
	table.insert(self.shapes, meshshape);
	soft:Initialize(meshshape ,10.0);
    soft:SetLinearStiffness(0.1);
    soft:SetMatch(false,true);
    soft:SetPoseMatch(0.1);
	--soft:SetSoftkDF(0.2);
	--soft:SetVolumeConversation(200);
	--soft:RandomizeConstraints();
  soft:EnableDebug();
    lowpoly:AttachComponent(soft);
	table.insert(self.softs, soft);
	return soft;
end

function main:CreateCameras(near, far, pos, lookat, up)  
	self.maincamera = apollonode.CameraNode();
	self.maincamera:CreatePerspectiveProjection(near, far);
	self.maincamera:LookAt(pos, lookat, up);
    self.maincamera:Activate();
end

function main:fixSoftBody(joint, vertex, soft, rigid, mass, setmass, level,anchorconfig)
    local nodeMass = 0;
	rigid:Initialize(apolloengine.BoxShape(mathfunction.vector3(0.5, 0.5, 0.5)), 0);
	rigid:SetKinematic();
	rigid:DisableCollision();
	rigid:CleanMotion();
	local colors = vertex:GetColorData();
	local count = table.getn(colors);
    local fixdcount =0;
	for i = 1,count do
		local green = colors[i][2]/128.0;
		local red = colors[i][1]/128.0;
		
		if red>0.95 then
			if green < 0.8 then
				green = 0.05
			end
			if green < 0.4 then
				green = 0.001
			end
     -- elseif green< 0.7 then
     --   green = 0.01
     -- else
     --   green = 1.0;
     -- end
     -- if red>0.9 then
     --   red = 0.9
     -- end
      
			soft:AppendAnchor(i-1,rigid,true,green);	
			fixdcount = fixdcount+1;
			LOG("APPEND ANCHOR "..green);
			anchorconfig[tostring(i-1)] = green;
		end
	end
  LOG("total fixed count is "..fixdcount);
end

function main:fixclothSoftBody(joint, vertex, soft, rigid, down, up,strength, anchorconfig)
	rigid:Initialize(apolloengine.BoxShape(mathfunction.vector3(0.5, 0.5, 0.5)), 0);
	rigid:SetKinematic();
	rigid:DisableCollision();
	joint:AttachComponent(rigid);
	rigid:CleanMotion();
	local colors = vertex:GetColorData();
	local count = table.getn(colors);
  local binded = 0;
	for i = 1,count do
		local green = colors[i][2]/128.0;
		local red = colors[i][1]/128.0;	
    --LOG("GREEN ".. red)
		if red~=0 and red>down and red < up then
      if green>0.9 then
        green = 0.9;
      elseif green>0.45 then
        green = 0.07;
      elseif green>0.15 then
        green = 0.016;
      else
        green = 0.0013;
      end
     -- green = 0.01;
      binded = binded+1;
      --LOG("green is  ".. green)
     -- self:AttachDebugRender(joint);
			soft:AppendAnchor(i-1,rigid,true,green);
			anchorconfig[tostring(i-1)] = green;
		end
	end
  --LOG("COUNT IS ".. binded);
end

function main:fixclothSoftBody2(joint, vertex, soft, down, up,strength)
	rigid = joint:GetComponent(apolloengine.Node.CT_RIGID_BODY);
	local colors = vertex:GetColorData();
	local count = table.getn(colors);
  local binded = 0;
	for i = 1,count do
		local green = colors[i][2]/128.0;
		local red = colors[i][1]/128.0;	
    --LOG("GREEN ".. red)
		if red~=0 and red>down and red < up then
      if green>0.9 then
        green = 0.9;
      elseif green>0.45 then
        green = 0.000;
      elseif green>0.15 then
        green = 0.000;
      else
        green = 0.000;
      end
      binded = binded+1;
      --LOG("green is  ".. green)
     -- self:AttachDebugRender(joint);
			soft:AppendAnchor(i-1,rigid,true,green);	
		end
	end
 -- LOG("COUNT IS ".. binded);
end

function main:initPhysics()
	self:initSoftBody();
	--self:initRigidBody();
end

function main:test()
	self.node = apolloengine.Node();
    self.trans = apolloengine.TransformComponent();
	self.node:AttachComponent(self.trans);
	self.trans:SetLocalScale(mathfunction.vector3(1,1,1));
    self.trans:SetLocalPosition(mathfunction.vector3(0,-3,0));
	size = mathfunction.vector3(1.5,0.5,1.5);
    shape = apolloengine.BoxShape(size);
	local rigid = apolloengine.RigidBodyComponent();
	rigid:Initialize(shape, 0); 
    rigid:SetKinematic();
	rigid:EnableDebug();
	self.node:AttachComponent(rigid);
	table.insert(self.rigids, rigid);
    return rigid;
end

function main:initRigidBody()
	--self.rigida = self:createRigidBody2(self.skecom:GetJoint("Bone_Gua_L"),0.8, 2.2,mathfunction.vector3(0,-0.5,0.1));
	--self.rigidb = self:createRigidBody2(self.skecom:GetJoint("Bone_Gua_R"),0.8, 2.2,mathfunction.vector3(0,-0.5,0.1));
  
  --self.rigidc = self:createRigidBody2(self.skecom:GetJoint("Bip001 Neck"),0.8, 2.2,mathfunction.vector3(-0.5,0,0),apolloengine.CapsuleShape.Axis_Z);
  
	--self.rigid = self:test();
	--self.testbox = self:TestBox();
	
end

function main:createRigidBody2(joint,r,h,size,rot)
	local rigid = apolloengine.RigidBodyComponent();
	local shape = apolloengine.CapsuleShape(r, h);
  self.transnode = TransNode();
  table.insert(self.transnodes,self.transnode);
	table.insert(self.shapes, shape);
  if rot~=nil then
    shape:SetAxis(rot);
  end
	rigid:Initialize(shape, 0);
	rigid:SetKinematic();
	rigid:CleanMotion();
	--rigid:EnableDebug();
	self.transnode:AttachComponent(rigid);
  joint:AttachNode(self.transnode.node);
  self.transnode:SetLocalPosition(size);
	table.insert(self.rigids, rigid);
end

function main:createRigidBody(joint)
	local rigid = apolloengine.RigidBodyComponent();
	local shape = apolloengine.CapsuleShape(0.8, 2.2);
	table.insert(self.shapes, shape);
	shape:SetAxis(apolloengine.CapsuleShape.Axis_Y);
	rigid:Initialize(shape, 0);
	rigid:SetKinematic();
	rigid:CleanMotion();
	rigid:EnableDebug();
	joint:AttachComponent(rigid);
	table.insert(self.rigids, rigid);
end

function main:TestBox()
	self.nodes = {};
	self.trans = {};

	local node = apolloengine.Node();
	local trans = apolloengine.TransformComponent();
	local rigid = apolloengine.RigidBodyComponent();
	trans:SetLocalPosition(mathfunction.vector3(0.3, 0.1, 0));
	node:AttachComponent(trans);
    shape = apolloengine.BoxShape(mathfunction.vector3(0.05,0.05,0.05));
	rigid:Initialize(shape, 1); 
	rigid:EnableDebug();
	node:AttachComponent(rigid);
	table.insert(self.nodes, node);
	table.insert(self.trans, trans);
  table.insert(self.rigids, rigid);
	return rigid;
end



function main:initSoftBody()

	local jsonsource = {};

	local hairparam = {};
	self.hairlowpoly = self:CreateLowpoly("./data/form5.mesh");
	self.hairsoftbody = self:CreateHairSoftBody(self.hairlowpoly,hairparam);
  

	jsonsource["param"] = hairparam;
	--self.hairsoftbody:EnableDebug();

	self.hairvertex = self.hairlowpoly:GetVertexStream();
	
	self.hairinverskin = self.hairlowpoly:CreateComponent(apolloengine.Node.CT_WAHBASINVSKIN)
	local bindconfig = {};
	local znormalsconfig = {};
	local adjinfosconfig = {};
	local inversconfig = {};
	self:InitBoneAndVertexBind(self.hairinverskin, self.hairvertex, self.hairsoftbody, self.hairlowpoly, "past",bindconfig, znormalsconfig, adjinfosconfig);
	inversconfig["bind"] = bindconfig;
	inversconfig["znormal"] = znormalsconfig;
	inversconfig["adjinfo"] = adjinfosconfig;
	jsonsource["inverse"] = inversconfig;
  
    

	self.hairjoint = self.skecom:GetJoint("m_avg_Head");
	self.hairrigid = self.hairjoint:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
  	--self.hairrigid:EnableDebug();
  
	self.anchorconfig = {};
	self.anchorconfigp = {};
	self:fixSoftBody(self.hairjoint, self.hairvertex, self.hairsoftbody, self.hairrigid, 100.0, true, 0.7,self.anchorconfig);
 
	self.anchorconfigp["m_avg_Head"] =self.anchorconfig;
	jsonsource["anchor"] =self.anchorconfigp;
	venusjson.SaveJsonObject(jsonsource, "E:\\jsonsource.json");

  

	local skirtparam = {};
	self.skirtlowpoly = self:CreateLowpoly("./data/lowpoly_tie_001.mesh");
	self.skirtsoftbody = self:CreateClothSoftBody(self.skirtlowpoly,skirtparam);
  
	self.skirtsoftbody:EnableDebug();
  
	self.skirtvertex = self.skirtlowpoly:GetVertexStream();
	jsonsource["param"] = hairparam;
  
	self.skirtinverskin =self.skirtlowpoly:CreateComponent(apolloengine.Node.CT_WAHBASINVSKIN)
	local bindconfig = {};
	local znormalsconfig = {};
	local adjinfosconfig = {};
	local inversconfig = {};
	self:InitBoneAndVertexBind(self.skirtinverskin, self.skirtvertex, self.skirtsoftbody, self.skirtlowpoly, "join",bindconfig, znormalsconfig, adjinfosconfig);
	inversconfig["bind"] = bindconfig;
	inversconfig["znormal"] = znormalsconfig;
	inversconfig["adjinfo"] = adjinfosconfig;
	jsonsource["inverse"] = inversconfig;
  
  
  
	self.skirtjoint = self.skecom:GetJoint("m_avg_Pelvis");
	self.skirtrigid = self.skirtjoint:CreateComponent(apolloengine.Node.CT_RIGID_BODY);
	--self.hairrigid:EnableDebug();
  
	self.anchorconfigskirt = {};

	self.anchorconfigp = {};
	self:fixSoftBody(self.skirtjoint, self.skirtvertex, self.skirtsoftbody, self.skirtrigid, 100.0, true, 0.7,self.anchorconfigskirt);
  
	self.anchorconfigp["m_avg_Pelvis"] =self.anchorconfigskirt;
	jsonsource["anchor"] =self.anchorconfigp;
	venusjson.SaveJsonObject(jsonsource, "E:\\jsonsourceskirt.json");
end


function main:Initialize()
	_COROUTINES_ON();
	self.begintime = venuscore.ITimerSystem:GetTimevalue();
	self.cumtime = 0;
	self.fps = 0;
  self.lightnode = apollonode.LightNode(apolloengine.LightComponent.LT_DIRECTIONAL);
  self.lightnode:SetColor(
    mathfunction.vector3(1.3,1.3,1.3));
  self.lightnode:SetLocalDirection(
    mathfunction.vector3(0.2,-0.3,-0.3));
  
	self:CreateCameras(1, 1000, mathfunction.vector3(0,1,3), mathfunction.vector3(0,1,0), mathfunction.vector3(0,1,0));
    self.renders = {};
    self.nodes = {};
    self.trans = {};
	self.softs = {};
	self.lowpolys = {};
	self.meshshapes = {};
	self.shapes = {};
	self.rigids = {};
	self.transnodes = {};
	
	self.model = apollonode.ModelNode();
	self.model:KeepSource(true);
	self.model:CreateResource("test:physicsdoc/girl-1126", nil, apolloengine.VertexBufferEntity.MU_DYNAMIC);
	self.model:SetLoop(true);
	
	self.skecom = self.model.skeletonNode.skeleton;
  --self.skecom:Play();
	self.model:GetMeshNode("./data/lowpoly_hair_0011.mesh"):SetShow(false);
  --self.model:GetMeshNode("./data/polysurface352.mesh"):SetShow(false);
  --self.model:GetMeshNode("./data/face_geo_face_geo_0.mesh"):SetShow(false);
  --self.model:GetMeshNode("./data/lowpoly_hair_0011.mesh"):SetShow(false);
	
  --self.model:GetMeshNode("./data/ff_002_pants.mesh"):SetShow(false);

	self:initPhysics();
		
	self.rotation = mathfunction.Quaternion();
	self.position = mathfunction.vector3();
	apolloengine.Framework:AddSynchronizeUpdateCallback(self._Agent, "Update");
	apolloengine.Framework:AddTouchCallback(self._Agent, "OnTouch");
	LOG("initialize done");
	_COROUTINES_OFF();
	self.a = 0;
	self.b = true;
	return true;
end

local notbindlist = {};
function main:NeedBind(jointname)
  for i=1,#notbindlist do
    if jointname == notbindlist[i] then
      return false;
    end
  end
  return true;
end
function main:InitBoneAndVertexBind(inverskin, vertexstream, softbody, lowpoly, boneStr, bindconfig, znormalsconfig, adjinfosconfig) 
	self.jointname = "";
	self.index = 0;
	local distance = 1000;
	apolloengine.IPhysicSystem:SetGravity(mathfunction.vector3(0,0,0));
	apolloengine.IPhysicSystem:Update(0.01,10,1.0/60.0);
	softbody:SetVertexDataToVertexStream(vertexstream);

	local jointCount = self.skecom:GetJointCount();
	local postions = vertexstream:GetVertexData();
	local xnormals = vertexstream:GetNormalData();
	local colors = vertexstream:GetColorData();
	local znormals = {};
	local adjinfos = {};
	local bindRAngle = {};
	local indices = lowpoly:GetIndexStream():GetIndicesData();
	for i = 1,table.getn(indices),3 do
		for j = 0,2 do  
			local idx = i+j;
			local adjIndex = -1;
			if (j<2) then
				adjIndex = indices[idx + 1];
			else
				adjIndex = indices[idx - 1];
			end
			local curentidxlua = indices[idx]+1;
			local edge = mathfunction.vector3(postions[adjIndex+1][1],postions[adjIndex+1][2],postions[adjIndex+1][3]) -
                  mathfunction.vector3(postions[curentidxlua][1],postions[curentidxlua][2],postions[curentidxlua][3]);
			local xnormal = mathfunction.vector3(xnormals[curentidxlua][1],xnormals[curentidxlua][2],xnormals[curentidxlua][3]);
			local zNor = xnormal:Cross(edge);
			local theta = 3.1415926 / 2;
			local sintheta = zNor:Length() / (edge:Length()*xnormal:Length());
			sintheta = math.clamp(sintheta, -1, 1);
			theta = math.asin(sintheta) - 3.1415926 / 2;
			theta = math.abs(theta);
			if (bindRAngle[curentidxlua]== nil) or theta<bindRAngle[curentidxlua] then
				adjinfos[curentidxlua] = adjIndex;
				adjinfosconfig[curentidxlua] = adjIndex;
				local normalz = zNor:Normalize();
				znormals[curentidxlua] = {};
				local znormalsconfigtemp = {}
				znormals[curentidxlua][1] = normalz:x();
				znormals[curentidxlua][2] = normalz:y();
				znormals[curentidxlua][3] = normalz:z();
				znormalsconfigtemp[1] = normalz:x();
				znormalsconfigtemp[2] = normalz:y();
				znormalsconfigtemp[3] = normalz:z();
				znormalsconfig[curentidxlua] = znormalsconfigtemp;
				bindRAngle[curentidxlua] = theta;		
			end
		end
	end
  local vertcount =  table.getn(postions)
  LOG("VTX COUNT IS "..vertcount);
	inverskin:SetVertexData(postions,xnormals,znormals,adjinfos);
	for j = 1 , jointCount do
    distance = 1000; 
		local joint = self.skecom:GetJointByIndex(j-1);
		if string.sub(joint:GetName(),1,4) == boneStr then			
			for i = 1,table.getn(postions) do
				local transformcom = joint:GetComponent(apolloengine.Node.CT_TRANSFORM);
				local pointpos =   mathfunction.vector3(postions[i][1],postions[i][2],postions[i][3]);
				local x = pointpos - transformcom:GetWorldPosition();
				if x:Length() < distance then
					distance = x:Length();
					self.jointname = joint:GetName();
					self.index = i-1;
				end
			end
      if self:NeedBind(self.jointname) then
        LOG("BIND A VERTEX "..distance);
        inverskin:AddIndexSkeletonPair(self.index,  self.skecom:GetJointByIndex(j-1));
        local id = self.skecom:GetJointIDByIndex(j-1)
        bindconfig[tostring(id)] = self.index;
        self:AttachDebugRender(joint);
      end
      --[[
			if self.jointname~= "cloth_bone00" and self.jointname~= "cloth_bone01" and self.jointname~= "cloth_bone05" and self.jointname~= "cloth_bone06" and self.jointname~= "cloth_bone10" and self.jointname~= "cloth_bone11" and self.jointname~= "cloth_bone15" and self.jointname~= "cloth_bone16" and self.jointname~= "cloth_bone23" and self.jointname~= "cloth_bone24" and self.jointname~= "cloth_bone28" and self.jointname~= "cloth_bone29" then
				LOG("aaaaaaaaaa  " .. self.jointname);
				inverskin:AddIndexSkeletonPair(self.index, self.skecom:GetJoint(self.jointname));
			--self:AttachDebugRender(joint);
			end		]]
		end 
		
	end
  --self:AttachDebugRender(self.skecom:GetJoint("cloth_bone60"));
  
	apolloengine.IPhysicSystem:SetGravity(mathfunction.vector3(0,-10,0));
end

function main:AttachDebugRender(joint)
    local node = apolloengine.Node();
    local cube = node:CreateComponent(apolloengine.Node.CT_RENDER);
    local trans = node:CreateComponent(apolloengine.Node.CT_TRANSFORM);
    cube:PushMetadata(
      apolloengine.RenderObjectMaterialMetadata(
        apolloengine.PathMetadata("comm:documents/material/lightingonly.material")));  
    cube:PushMetadata(
          apolloengine.RenderObjectMeshFileMetadate("comm:documents/model/cube.mesh"));  
    cube:CreateResource();
   
    joint:AttachNode(node);
    trans:SetLocalScale(mathfunction.vector3(5,5,5));
    trans:SetLocalPosition(mathfunction.vector3(0,0,0));
    if self.debugrenders == nil then 
      self.debugrenders = {};
      self.debugnodes = {};
      self.debugtrans  = {};
    end
    table.insert(self.debugrenders, cube);
    table.insert(self.debugnodes, node);
    table.insert(self.debugtrans, trans);
end
local changed = false;
function main:Update()
  _COROUTINES_ON();
	local def = self:Timespan();
	self.a = self.a + def;
	
	if self.stopani~=nil then
   		self.stopani = self.stopani+def;
  	end
	--self.clothsoftbody:AddForce(mathfunction.vector3(0,-10,0));

	if self.a > 4 and self.stopani==nil then
		self.rotation = self.rotation * mathfunction.Mathutility:RotateAxis(mathfunction.vector3(0,1,0), math.pi / 4 * def * 12* math.cos(self.a * 3));
  
		self.model:SetLocalRotation(self.rotation);
 
	end
  
	apolloengine.IPhysicSystem:Update(def,10,1.0/60.0);
	self.hairsoftbody:SetVertexDataToVertexStream(self.hairvertex);
	self.hairinverskin:InverseSkin(self.hairvertex);

	--self.brasoftbody:SetVertexDataToVertexStream(self.bravertex);
	--self.brainverskin:InverseSkin(self.bravertex);

	self.skirtsoftbody:SetVertexDataToVertexStream(self.skirtvertex);
	self.skirtinverskin:InverseSkin(self.skirtvertex);
  _COROUTINES_OFF();
end

--[[function main:OnTouch(touchinfo)
	_COROUTINES_ON();
	local vec2 = touchinfo:GetTouchPoint(1);
	self.gestureanimation:SetSimulateActionPoint(vec2);
	_COROUTINES_OFF();  
end]]

function main:OnTouch(touchinfo)
	_COROUTINES_ON();
	
	local vec2 = touchinfo:GetTouchPoint(1);
	local tt = touchinfo:GetTouchType(1);
	if apolloengine.TouchInfo.TT_PRESS == tt  then
		
		self.point = vec2;
     if self.stopani~=nil and self.stopani<0.5 then
      self.stopani = nil;
    else 
       self.stopani = 0;
    end
    
   
 -- for bonename,weight in pairs(skirtBoneColorPair) do
  --  local clothjoint = self.skecom:GetJoint(bonename);
    
 --   self:fixclothSoftBody2(clothjoint, self.clothvertex, self.clothsoftbody, weight - 0.05, weight,1);
 -- end
    
	elseif apolloengine.TouchInfo.TT_MOVE == tt then
		local rd = vec2 - self.point;
		self.point = vec2;
		local x = rd:x();
		local pos = self.maincamera:GetPosition();
		local dir = self.maincamera:GetForward();
		local rot = mathfunction.Mathutility:RotateAxis(
		mathfunction.vector3(0,1,0),
		-x);
		pos = pos * rot;
		dir = dir * rot;
		self.maincamera:SetPosition(pos);
		self.maincamera:SetForward(dir);
	end
	_COROUTINES_OFF();
  
end

return main;