local manipulatebase = require "lightgame.manipulatepartical.manipulatebase"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local detectdefined = require "videodecet.defined"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local videodecet = require "videodecet"
local define = require "lightgame.manipulatepartical.defined"



--操纵一个粒子，当信号出现的时候粒子减速直到停止
local slowdown = manipulatebase:extend();

function slowdown:new(path, trigger, acc, soundA, soundB,queue)--acc时间减缓速度，单位百分比/每秒  
  slowdown.super.new(self, trigger,soundA,soundB);
  self.timemul = 1;
  self.timespeed = acc;
  self.particleemitter = apollonode.ParticleNode();
  self.particleemitter:CreateResource(path);
  --renderqueue:Before(self.particleemitter);
  if queue == nil then
    renderqueue:Queue("Sticker",self.particleemitter);
  else
    renderqueue:Queue(queue,self.particleemitter);
  end
  self.isPlayDetectedSound = true;
end

 function slowdown:_ResetParameter()
   self.particleemitter:ResetParamMultipiler();
 end
 
function slowdown:SetLocalPosition(pos)
  self.particleemitter:SetLocalPosition(pos);
end

function slowdown:_SetTriggerdParam(paramName, value)
  self.particleemitter:SetParamMultipiler(paramName,value);
end

function slowdown:_SetUnTriggerdParam(paramName, value)
  self.particleemitter:SetParamMultipiler(paramName,value);
end

function slowdown:_OnDetected(def, globaloffset,globalscale)
  self.timemul = self.timemul - self.timespeed * def;
  self.timemul = self.timemul > 0 and self.timemul or 0;
  self.particleemitter:SetGlobalOffset(globaloffset);
  self.particleemitter:SetGlobalScale(globalscale);
  --if self.timemul > 0.01 then
    self.particleemitter:AsyncUpdate(self.timemul * def)
  --end
  
  self:PlaySound(1);
  
  
end

function slowdown:_OnSilence(def)
  self.timemul = self.timemul + self.timespeed * def;
  self.timemul = self.timemul < 1 and self.timemul or 1;
  self.particleemitter:AsyncUpdate(self.timemul * def)


  self:PlaySound(2);

  
end

function slowdown:Exit()
  slowdown.super:Exit();
  self.particleemitter:Destroy();
end

return slowdown;