local Bodykeypoint = require"gesturemagic.bodysticker.bodykeypoint"
local Rendernode = require"gesturemagic.bodysticker.rendernode"
local Object = require "classic"
local vc = require "venuscore"
local cjutil = require "cjson.util"
local cjson = require "cjson"
require "utility"


local BodySticker = Object:extend()
local controllerpath = "controllers/main";
local configfilename = "config.json";


local function _GetRenderClosure(chosenKeyPoints, flip, effectrootpath, effectsfile)
  local render = Rendernode(flip, effectrootpath, effectsfile);--创建一个可以渲染的对象的upvalue
  return function(keypoints)
    render:UpdateRender(--更新render
      keypoints[chosenKeyPoints[1]],
      keypoints[chosenKeyPoints[2]],
      keypoints[chosenKeyPoints[3]],
      keypoints[chosenKeyPoints[4]]);
  end  
end

function BodySticker:new()
  self.keypointgenerator = Bodykeypoint();
end

function BodySticker:Load(rootpath)
  self.closures = {};
  local mainconfig = rootpath.."/"..controllerpath.."/"..configfilename;
  if not vc.IFileSystem:isFileExist(mainconfig) then
    ERROR("BodySticker: main config "..mainconfig.." is not exist");
    return false;
  end  
  local fullpath = vc.IFileSystem:PathAssembly(mainconfig);
  local config = cjson.decode(cjutil.file_load(fullpath));
  self.name = config.name;
  for _, effobj in ipairs(config.resources) do
    local effectrootpath = rootpath.."/"..effobj.effects.."/";
    local effectfilepath = effectrootpath..configfilename;
    if not vc.IFileSystem:isFileExist(effectfilepath) then
      self.closures = nil;
      ERROR("BodySticker: effect config "..effectfilepath.." is not exist");
      return false;
    else
      local fulleffectpath = vc.IFileSystem:PathAssembly(effectfilepath);      
      --创建每一个render的closure，方便更新
      local flip = effobj.flip and -1 or 1;
      local closure = _GetRenderClosure(effobj.chosenKeyPoints, flip, effectrootpath, fulleffectpath);
      table.insert(self.closures, closure);
    end
  end
  return true;
end

function BodySticker:Update()
  local keypoints = self.keypointgenerator:GetKeypoint();--获取关键点
  for _, closure in pairs(self.closures) do--更新关键点信息
    closure(keypoints);
  end  
end

--使用
--self.bodysticker = BodySticker();
--self.bodysticker:Load("docs:bodyeffect/skeleton");  
--self.bodysticker:UpdateRender();  

return BodySticker;