local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local defined = require "facecute.defined"
local videodecet = require "videodecet"
local facedefined = require "facecute.facechange.facedefined"
local trianglenode = require "facecute.facechange.trianglenode"
local renderqueue = require "apolloutility.renderqueue"
local b3 = require "behavior3"
local vc = require "venuscore"
local cjutil = require "cjson.util"
local cjson = require "cjson"
local cutebehavior = require "facecute.behavior.cutebehavior"
local asynctexture = require "apolloutility.asynctexture.asynctexture"
local behdefined = require "facecute.behavior.behdefined"
local rendernode = require "apolloutility.apollonode.rendernode"
--facecoverpri类型
local facecoverpri = rendernode:extend();
function facecoverpri:new(maincamera)
  self.maincamera = maincamera;
  facecoverpri.super.new(self);  
  facecoverpri.super.SetShow(self, false);
  self.mOriginalFaceCoords = {}
  self.ptAddZ = {};
  self.ptAddOrgZ = {};
  self.facePtAddPrj = {};
  self.facePtAddPrjOrg = {};
  self.ptZ = {};
  
  
  self.vertexstream = apolloengine.VertexStream();--创建顶点流
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  --apolloengine.ShaderEntity.ATTRIBUTE_FACECOORDNATESTD =
  --  apolloengine.IMaterialSystem:NewParameterSlot(
  --   apolloengine.ShaderEntity.ATTRIBUTE,
  --   "ATTRIBUTE_FACECOORDNATESTD");
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE2,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  self.vertexstream:ReserveBuffer(facedefined.facePointCountExtend);--预先分配triIndexCount个索引
  self.indicesstream = apolloengine.IndicesStream();--创建索引流 
  self.indicesstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  local  triIndexCount = facedefined.faceTriIndexCount;
  local  addIndexCount = table.getn(facedefined.faceIndexAdd)+table.getn(facedefined.faceEyesTriangles);
  self.indicesstream:ReserveBuffer(triIndexCount+addIndexCount);--预先分配triIndexCount个索引
  
  
  self:InitIndexStream();
  self:InitVertexStream();

end


local function ModelLengthToWorldLength(le)
  --local val = 58*le/206.5/1000.0;
  --local val = 0.00028087167070217917*le;
  local val =facedefined.ModelToWorldVal*le;
  return val;
end

function facecoverpri:InitIndexStream()
  
 self.indexCount = 0;
 local  triIndexCount = facedefined.faceTriIndexCount;
 if(true ) 
 then
   local indiceAdd = facedefined.faceIndexAdd;
   local len = table.getn(indiceAdd);
    for j=1,len/3 do
       if(true)
        then
          self.indicesstream:PushIndicesData(indiceAdd[3*j-2]);
          self.indicesstream:PushIndicesData(indiceAdd[3*j-1]);
          self.indicesstream:PushIndicesData(indiceAdd[3*j]);
          self.indexCount =  self.indexCount +3;
        end
    end
  end
  
  
  local faceTris = facedefined.faceTriangles;
  local tri={};
  for j=1,triIndexCount/3 do
      tri[0]=faceTris[3*j-2]-1;
      tri[1]=faceTris[3*j-1]-1;
      tri[2]=faceTris[3*j]-1;
      if(true)
      then 
        if( (true ) and((tri[0]>105 and tri[0]<116) or(tri[1]>105 and tri[1]<116) or (tri[2]>105 and tri[2]<116)))
        then
        else
           self.indicesstream:PushIndicesData(tri[0]);
           self.indicesstream:PushIndicesData(tri[1]);
           self.indicesstream:PushIndicesData(tri[2]);
           self.indexCount =   self.indexCount +3;
        end
      end
  end
  
  if(true) 
  then
    local indiceAux ={33,64,34,41,71,42};
    local adLen = table.getn(indiceAux)/3;
    for i=1,adLen do
        if(true)
        then
          self.indicesstream:PushIndicesData(indiceAux[3*i-2]);
          self.indicesstream:PushIndicesData(indiceAux[3*i-1]);
          self.indicesstream:PushIndicesData(indiceAux[3*i]);
          self.indexCount =   self.indexCount +3;
        end
    end
  end
  
  
  faceTris = facedefined.faceEyesTriangles;
  local eyesTrisLen = #faceTris/3;
  for j=1, eyesTrisLen do
     self.indicesstream:PushIndicesData(faceTris[3*j-2]-1);
     self.indicesstream:PushIndicesData(faceTris[3*j-1]-1);
     self.indicesstream:PushIndicesData(faceTris[3*j]-1);
     self.indexCount =   self.indexCount +3;
  end
end


function facecoverpri:InitVertexStream()
  
  local facePtTotal = facedefined.facePointCount+facedefined.facePointInterCount;
  local faceCenter = facedefined.faceCenter;
  local ptAdd = facedefined.facePtAddXY;
  local ptAddZ=facedefined.facePtAddZ;
  self.facePtAdd ={};
  self.facePtAddZ={};
  self.facePt={};
  local faceTexPtAdd={};
  local le = table.getn(ptAdd);
  for i=1,le/2 do
      self.facePtAdd[2*i-1]=ModelLengthToWorldLength(ptAdd[2*i-1]);
      self.facePtAdd[2*i]=ModelLengthToWorldLength(ptAdd[2*i]);
      self.facePtAddZ[i]=ptAddZ[i];
  end
  
  local facePt={};
  le = facedefined.facePointCount;
  for i =0,le-1 do
      facePt[2*i] = facedefined.faceTexPoints[2*(i+1)-1]+facedefined.faceTexPointsOffset[1];
      facePt[2*i+1] = facedefined.faceTexPoints[2*(i+1)]+facedefined.faceTexPointsOffset[2];
  end
  local offset = 0;
  local faceDtCount=106;
  facePt[(faceDtCount + 0+offset) * 2 + 0] = facePt[(33+offset) * 2 + 0] + (facePt[(33+offset) * 2 + 0] - facePt[(52+offset) * 2 + 0]) * 0.35;
  facePt[(faceDtCount + 0+offset) * 2 + 1] = facePt[(33+offset) * 2 + 1] + (facePt[(33+offset) * 2 + 1] - facePt[(52+offset) * 2 + 1]) * 0.35;
  facePt[(faceDtCount + 1+offset) * 2 + 0] = facePt[(42+offset) * 2 + 0] + (facePt[(42+offset) * 2 + 0] - facePt[(61+offset) * 2 + 0]) * 0.35;
  facePt[(faceDtCount + 1+offset) * 2 + 1] = facePt[(42+offset) * 2 + 1] + (facePt[(42+offset) * 2 + 1] - facePt[(61+offset) * 2 + 1]) * 0.35;
  facePt[(faceDtCount + 2+offset) * 2 + 0] = facePt[(34+offset) * 2 + 0] + (facePt[(34+offset) * 2 + 0] - facePt[(64+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 2+offset) * 2 + 1] = facePt[(34+offset) * 2 + 1] + (facePt[(34+offset) * 2 + 1] - facePt[(64+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 3+offset) * 2 + 0] = facePt[(35+offset) * 2 + 0] + (facePt[(35+offset) * 2 + 0] - facePt[(65+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 3+offset) * 2 + 1] = facePt[(35+offset) * 2 + 1] + (facePt[(35+offset) * 2 + 1] - facePt[(65+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 4+offset) * 2 + 0] = facePt[(36+offset) * 2 + 0] + (facePt[(36+offset) * 2 + 0] - facePt[(66+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 4+offset) * 2 + 1] = facePt[(36+offset) * 2 + 1] + (facePt[(36+offset) * 2 + 1] - facePt[(66+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 5+offset) * 2 + 0] = facePt[(37+offset) * 2 + 0] + (facePt[(37+offset) * 2 + 0] - facePt[(67+offset) * 2 + 0]) * 2.0;
  facePt[(faceDtCount + 5+offset) * 2 + 1] = facePt[(37+offset) * 2 + 1] + (facePt[(37+offset) * 2 + 1] - facePt[(67+offset) * 2 + 1]) * 2.0;
  facePt[(faceDtCount + 6+offset) * 2 + 0] = facePt[(38+offset) * 2 + 0] + (facePt[(38+offset) * 2 + 0] - facePt[(68+offset) * 2 + 0]) * 2.0;
  facePt[(faceDtCount + 6+offset) * 2 + 1] = facePt[(38+offset) * 2 + 1] + (facePt[(38+offset) * 2 + 1] - facePt[(68+offset) * 2 + 1]) * 2.0;
  facePt[(faceDtCount + 7+offset) * 2 + 0] = facePt[(39+offset) * 2 + 0] + (facePt[(39+offset) * 2 + 0] - facePt[(69+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 7+offset) * 2 + 1] = facePt[(39+offset) * 2 + 1] + (facePt[(39+offset) * 2 + 1] - facePt[(69+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 8+offset) * 2 + 0] = facePt[(40+offset) * 2 + 0] + (facePt[(40+offset) * 2 + 0] - facePt[(70+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 8+offset) * 2 + 1] = facePt[(40+offset) * 2 + 1] + (facePt[(40+offset) * 2 + 1] - facePt[(70+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 9+offset) * 2 + 0] = facePt[(41+offset) * 2 + 0] + (facePt[(41+offset) * 2 + 0] - facePt[(71+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 9+offset) * 2 + 1] = facePt[(41+offset) * 2 + 1] + (facePt[(41+offset) * 2 + 1] - facePt[(71+offset) * 2 + 1]) * 1.0;
  
  local totalPtCount =  (#facePt+1)/2+(#ptAdd)/2;
  
  
  self.faceTexPri={};
  local faceTexPri = self.faceTexPri;
  local faceptlen = (#facePt+1)/2 ;
  for i=1,faceptlen do
    faceTexPri[2*i-1] = facePt[2*(i-1)]/facedefined.cavasSize[1];
    faceTexPri[2*i] =  facePt[2*(i-1)+1]/facedefined.cavasSize[2];
  end
  
  local len= #ptAdd/2;
  for i=1+faceptlen, len+faceptlen do
      faceTexPri[2*i-1] = (ptAdd[2*(i-faceptlen)-1]+faceCenter[1])/facedefined.cavasSize[1];
      faceTexPri[2*i]= (-ptAdd[2*(i-faceptlen)]+faceCenter[2])/facedefined.cavasSize[2];
  end
  
  
 local facetexstd = faceTexPri;
  local texstdlen = #facetexstd/2;
   for i =1,texstdlen do
        self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE2,
      mathfunction.vector2(facetexstd[2*i-1],facetexstd[2*i]));
    
          self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      mathfunction.vector4(0,0,0,1)
      );
  end
  
  
  
  
 --[[ le = (#facePt+1)/2;
  for i=1,le do
    self.facePt[2*i-1] = ModelLengthToWorldLength(facePt[2*(i-1)]);
    self.facePt[2*i] = ModelLengthToWorldLength(facePt[2*(i-1)+1]);
  end]]
end


function facecoverpri:ParseConfig(config,pripara)
  
  --[[local facePtTotal = facedefined.facePointCount+facedefined.facePointInterCount;
  local faceCenter = facedefined.faceCenter;
  local ptAdd = facedefined.facePtAddXY;
  local ptAddZ=facedefined.facePtAddZ;
  self.facePtAdd ={};
  self.facePtAddZ={};
  self.facePt={};
  local faceTexPtAdd={};
  local le = table.getn(ptAdd);
  for i=1,le/2 do
      self.facePtAdd[2*i-1]=ModelLengthToWorldLength(ptAdd[2*i-1]);
      self.facePtAdd[2*i]=ModelLengthToWorldLength(ptAdd[2*i]);
      self.facePtAddZ[i]=ptAddZ[i];
  end
  
  local facePt={};
  le = facedefined.facePointCount;
  for i =0,le-1 do
      facePt[2*i] = facedefined.faceTexPoints[2*(i+1)-1]+facedefined.faceTexPointsOffset[1];
      facePt[2*i+1] = facedefined.faceTexPoints[2*(i+1)]+facedefined.faceTexPointsOffset[2];
  end
  local offset = 0;
  local faceDtCount=106;
  facePt[(faceDtCount + 0+offset) * 2 + 0] = facePt[(33+offset) * 2 + 0] + (facePt[(33+offset) * 2 + 0] - facePt[(52+offset) * 2 + 0]) * 0.35;
  facePt[(faceDtCount + 0+offset) * 2 + 1] = facePt[(33+offset) * 2 + 1] + (facePt[(33+offset) * 2 + 1] - facePt[(52+offset) * 2 + 1]) * 0.35;
  facePt[(faceDtCount + 1+offset) * 2 + 0] = facePt[(42+offset) * 2 + 0] + (facePt[(42+offset) * 2 + 0] - facePt[(61+offset) * 2 + 0]) * 0.35;
  facePt[(faceDtCount + 1+offset) * 2 + 1] = facePt[(42+offset) * 2 + 1] + (facePt[(42+offset) * 2 + 1] - facePt[(61+offset) * 2 + 1]) * 0.35;
  facePt[(faceDtCount + 2+offset) * 2 + 0] = facePt[(34+offset) * 2 + 0] + (facePt[(34+offset) * 2 + 0] - facePt[(64+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 2+offset) * 2 + 1] = facePt[(34+offset) * 2 + 1] + (facePt[(34+offset) * 2 + 1] - facePt[(64+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 3+offset) * 2 + 0] = facePt[(35+offset) * 2 + 0] + (facePt[(35+offset) * 2 + 0] - facePt[(65+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 3+offset) * 2 + 1] = facePt[(35+offset) * 2 + 1] + (facePt[(35+offset) * 2 + 1] - facePt[(65+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 4+offset) * 2 + 0] = facePt[(36+offset) * 2 + 0] + (facePt[(36+offset) * 2 + 0] - facePt[(66+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 4+offset) * 2 + 1] = facePt[(36+offset) * 2 + 1] + (facePt[(36+offset) * 2 + 1] - facePt[(66+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 5+offset) * 2 + 0] = facePt[(37+offset) * 2 + 0] + (facePt[(37+offset) * 2 + 0] - facePt[(67+offset) * 2 + 0]) * 2.0;
  facePt[(faceDtCount + 5+offset) * 2 + 1] = facePt[(37+offset) * 2 + 1] + (facePt[(37+offset) * 2 + 1] - facePt[(67+offset) * 2 + 1]) * 2.0;
  facePt[(faceDtCount + 6+offset) * 2 + 0] = facePt[(38+offset) * 2 + 0] + (facePt[(38+offset) * 2 + 0] - facePt[(68+offset) * 2 + 0]) * 2.0;
  facePt[(faceDtCount + 6+offset) * 2 + 1] = facePt[(38+offset) * 2 + 1] + (facePt[(38+offset) * 2 + 1] - facePt[(68+offset) * 2 + 1]) * 2.0;
  facePt[(faceDtCount + 7+offset) * 2 + 0] = facePt[(39+offset) * 2 + 0] + (facePt[(39+offset) * 2 + 0] - facePt[(69+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 7+offset) * 2 + 1] = facePt[(39+offset) * 2 + 1] + (facePt[(39+offset) * 2 + 1] - facePt[(69+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 8+offset) * 2 + 0] = facePt[(40+offset) * 2 + 0] + (facePt[(40+offset) * 2 + 0] - facePt[(70+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 8+offset) * 2 + 1] = facePt[(40+offset) * 2 + 1] + (facePt[(40+offset) * 2 + 1] - facePt[(70+offset) * 2 + 1]) * 1.0;
  facePt[(faceDtCount + 9+offset) * 2 + 0] = facePt[(41+offset) * 2 + 0] + (facePt[(41+offset) * 2 + 0] - facePt[(71+offset) * 2 + 0]) * 1.0;
  facePt[(faceDtCount + 9+offset) * 2 + 1] = facePt[(41+offset) * 2 + 1] + (facePt[(41+offset) * 2 + 1] - facePt[(71+offset) * 2 + 1]) * 1.0;
  
  local totalPtCount =  (#facePt+1)/2+(#ptAdd)/2;
  
  
  self.faceTexPri={};
  local faceTexPri = self.faceTexPri;
  local faceptlen = (#facePt+1)/2 ;
  for i=1,faceptlen do
    faceTexPri[2*i-1] = facePt[2*(i-1)]/facedefined.cavasSize[1];
    faceTexPri[2*i] =  facePt[2*(i-1)+1]/facedefined.cavasSize[2];
  end
  
  local len= #ptAdd/2;
  for i=1+faceptlen, len+faceptlen do
      faceTexPri[2*i-1] = (ptAdd[2*(i-faceptlen)-1]+faceCenter[1])/facedefined.cavasSize[1];
      faceTexPri[2*i]= (-ptAdd[2*(i-faceptlen)]+faceCenter[2])/facedefined.cavasSize[2];
  end
  
  
 local facetexstd = faceTexPri;
  local texstdlen = #facetexstd/2;
   for i =1,texstdlen do
        self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_FACECOORDNATESTD,
      mathfunction.vector2(facetexstd[2*i-1],facetexstd[2*i]));
    
          self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      mathfunction.vector4(0,0,0,1)
      );
  end
  
  
  
  
  le = (#facePt+1)/2;
  for i=1,le do
    self.facePt[2*i-1] = ModelLengthToWorldLength(facePt[2*(i-1)]);
    self.facePt[2*i] = ModelLengthToWorldLength(facePt[2*(i-1)+1]);
  end]]
  
  --self:InitIndexStream();
 -- self:InitVertexStream();
  self:SetLocalPosition(mathfunction.vector3(0,0,0.00));
 -- self.isFullFace = pripara[1];
 -- self.isNotFullFace = pripara[2];
 -- self.isNeedZDepth = pripara[3];
 -- self.isNotNeedZDepth = pripara[4];
  return true;
end



function facecoverpri:GetFaceCoods()
  return  self.mOriginalFaceCoords,self.ptZ;
end

function facecoverpri:GetAddedFaceCoods(isFullFace)
  if(isFullFace)
  then
      return   self.facePtAddPrj,self.ptAddZ;
  else
      return   self.facePtAddPrjOrg,self.ptAddOrgZ;
  end
end

function facecoverpri:_CaculatePrj()
  local xS = 1.1;
  local yS = 1.1;
  local vp = self.maincamera:GetViewProj();
  local m = self:GetWorldTransform();
  local facePtAddPrj = self.facePtAddPrj;
  local facePtAddPrjOrg = self.facePtAddPrjOrg;
  local facePtAdd = self.facePtAdd;
  local facePtAddZ =self.facePtAddZ;
  local vec4 = mathfunction.vector4();
  local mvp = m*vp;
  local le=table.getn(self.facePtAdd)/2;
  local ptAddZ= self.ptAddZ;
  local ptAddOrgZ=self.ptAddOrgZ;
  
  local vec4Set = vec4.Set;
  local fx = mathfunction.vector4.x;
  local fy = mathfunction.vector4.y;
  local fz = mathfunction.vector4.z;
  local fw = mathfunction.vector4.w;
  
  if( self.isFullFace) then
    for i=1,le do
      --vec4:Set(facePtAdd[2*i-1]*xS,facePtAdd[2*i]*yS,facePtAddZ[i],1);
        vec4Set(vec4,facePtAdd[2*i-1]*xS,facePtAdd[2*i]*yS,facePtAddZ[i],1);
        local ptPrj = vec4 * mvp;
        local invw = 1 / fw(ptPrj);
        facePtAddPrj[2*i-1]= fx(ptPrj) * invw;
        facePtAddPrj[2*i]= fy(ptPrj) * invw;
        ptAddZ[i]= fz(ptPrj) * invw;
    end
  end
  
      --vec4:Set(facePtAdd[2*i-1],facePtAdd[2*i],facePtAddZ[i],1);
  if(self.isNotFullFace) then
    for i=1,le do
      vec4Set(vec4,facePtAdd[2*i-1],facePtAdd[2*i],facePtAddZ[i],1);
      local ptPrj = vec4 * mvp;
      local invw = 1 / fw(ptPrj);
      facePtAddPrjOrg[2*i-1]= fx(ptPrj) * invw;
      facePtAddPrjOrg[2*i]= fy(ptPrj) * invw;
      ptAddOrgZ[i]= fz(ptPrj) * invw;
    end
  end
  
  
  local ptZ= self.ptZ;
  if(self.isNeedZDepth) then
    le = #self.facePt/2;
    for i=1,le do
      --vec4:Set(self.facePt[2*i-1],self.facePt[2*i],0,1);
      vec4Set(vec4,self.facePt[2*i-1],self.facePt[2*i],0,1);
      local ptPrj = vec4 * mvp;
      ptZ[i]= fz(ptPrj) / fw(ptPrj);
    end
  end
  
end


function facecoverpri:_CaculateCoords()  
  local face = self.face;
  local facePtCount = facedefined.facePointCount;
  local Keypoints = face:GetKeypointArray();
  local mOriginalFaceCoords = self.mOriginalFaceCoords;
  for i=0,facePtCount-1 do
      local points = Keypoints[i+1];
      mOriginalFaceCoords[i * 2] =  points[1];--2 *  points[2*(i+1)-1] / vec2[1] - 1;
      mOriginalFaceCoords[i * 2 +1] = points[2];--2 * points[2*(i+1)] / vec2[2] - 1;
  end
  mOriginalFaceCoords[(facePtCount + 0) * 2 + 0] = mOriginalFaceCoords[33 * 2 + 0] + (mOriginalFaceCoords[33 * 2 + 0] - mOriginalFaceCoords[52 * 2 + 0]) * 0.35;
  mOriginalFaceCoords[(facePtCount + 0) * 2 + 1] = mOriginalFaceCoords[33 * 2 + 1] + (mOriginalFaceCoords[33 * 2 + 1] - mOriginalFaceCoords[52 * 2 + 1]) * 0.35;
  mOriginalFaceCoords[(facePtCount + 1) * 2 + 0] = mOriginalFaceCoords[42 * 2 + 0] + (mOriginalFaceCoords[42 * 2 + 0] - mOriginalFaceCoords[61 * 2 + 0]) * 0.35;
  mOriginalFaceCoords[(facePtCount + 1) * 2 + 1] = mOriginalFaceCoords[42 * 2 + 1] + (mOriginalFaceCoords[42 * 2 + 1] - mOriginalFaceCoords[61 * 2 + 1]) * 0.35;
  mOriginalFaceCoords[(facePtCount + 2) * 2 + 0] = mOriginalFaceCoords[34 * 2 + 0] + (mOriginalFaceCoords[34 * 2 + 0] - mOriginalFaceCoords[64 * 2 + 0]) * 1.0;
  mOriginalFaceCoords[(facePtCount + 2) * 2 + 1] = mOriginalFaceCoords[34 * 2 + 1] + (mOriginalFaceCoords[34 * 2 + 1] - mOriginalFaceCoords[64 * 2 + 1]) * 1.0;
  mOriginalFaceCoords[(facePtCount + 3) * 2 + 0] = mOriginalFaceCoords[35 * 2 + 0] + (mOriginalFaceCoords[35 * 2 + 0] - mOriginalFaceCoords[65 * 2 + 0]) * 1.0;
  mOriginalFaceCoords[(facePtCount + 3) * 2 + 1] = mOriginalFaceCoords[35 * 2 + 1] + (mOriginalFaceCoords[35 * 2 + 1] - mOriginalFaceCoords[65 * 2 + 1]) * 1.0;
  mOriginalFaceCoords[(facePtCount + 4) * 2 + 0] = mOriginalFaceCoords[36 * 2 + 0] + (mOriginalFaceCoords[36 * 2 + 0] - mOriginalFaceCoords[66 * 2 + 0]) * 1.0;
  mOriginalFaceCoords[(facePtCount + 4) * 2 + 1] = mOriginalFaceCoords[36 * 2 + 1] + (mOriginalFaceCoords[36 * 2 + 1] - mOriginalFaceCoords[66 * 2 + 1]) * 1.0;
  mOriginalFaceCoords[(facePtCount + 5) * 2 + 0] = mOriginalFaceCoords[37 * 2 + 0] + (mOriginalFaceCoords[37 * 2 + 0] - mOriginalFaceCoords[67 * 2 + 0]) * 2.0;
  mOriginalFaceCoords[(facePtCount + 5) * 2 + 1] = mOriginalFaceCoords[37 * 2 + 1] + (mOriginalFaceCoords[37 * 2 + 1] - mOriginalFaceCoords[67 * 2 + 1]) * 2.0;
  mOriginalFaceCoords[(facePtCount + 6) * 2 + 0] = mOriginalFaceCoords[38 * 2 + 0] + (mOriginalFaceCoords[38 * 2 + 0] - mOriginalFaceCoords[68 * 2 + 0]) * 2.0;
  mOriginalFaceCoords[(facePtCount + 6) * 2 + 1] = mOriginalFaceCoords[38 * 2 + 1] + (mOriginalFaceCoords[38 * 2 + 1] - mOriginalFaceCoords[68 * 2 + 1]) * 2.0;
  mOriginalFaceCoords[(facePtCount + 7) * 2 + 0] = mOriginalFaceCoords[39 * 2 + 0] + (mOriginalFaceCoords[39 * 2 + 0] - mOriginalFaceCoords[69 * 2 + 0]) * 1.0;
  mOriginalFaceCoords[(facePtCount + 7) * 2 + 1] = mOriginalFaceCoords[39 * 2 + 1] + (mOriginalFaceCoords[39 * 2 + 1] - mOriginalFaceCoords[69 * 2 + 1]) * 1.0;
  mOriginalFaceCoords[(facePtCount + 8) * 2 + 0] = mOriginalFaceCoords[40 * 2 + 0] + (mOriginalFaceCoords[40 * 2 + 0] - mOriginalFaceCoords[70 * 2 + 0]) * 1.0;
  mOriginalFaceCoords[(facePtCount + 8) * 2 + 1] = mOriginalFaceCoords[40 * 2 + 1] + (mOriginalFaceCoords[40 * 2 + 1] - mOriginalFaceCoords[70 * 2 + 1]) * 1.0;
  mOriginalFaceCoords[(facePtCount + 9) * 2 + 0] = mOriginalFaceCoords[41 * 2 + 0] + (mOriginalFaceCoords[41 * 2 + 0] - mOriginalFaceCoords[71 * 2 + 0]) * 1.0;
  mOriginalFaceCoords[(facePtCount + 9) * 2 + 1] = mOriginalFaceCoords[41 * 2 + 1] + (mOriginalFaceCoords[41 * 2 + 1] - mOriginalFaceCoords[71 * 2 + 1]) * 1.0;
end


function facecoverpri:_ChangeVertex()
  local OriginalFaceCoords, _ =  self:GetFaceCoods();  
  self.vertexstream:ChangeVertexDataArray(
    apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    1,
    2,
    OriginalFaceCoords);  
  
  local addFaceCoords, _ =self:GetAddedFaceCoods(self.isFullFace);  
  self.vertexstream:ChangeVertexDataArray(
    apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    117,
    2,
    addFaceCoords);
end

function facecoverpri:_ChangeVertexBuffer()
  --self.render:ChangeVertexBuffer(self.vertexstream);
  --self.vertexstream:SetReflushInterval(1,124);
  --local val = self.facecoverpri.vertexstream:GetReflushInterval();
  --self.render:ChangeVertexBuffer(self.vertexstream);
end

function facecoverpri:Process()
  local face = self.face;
  local timespan = self.timespan;
  local faceCenter = facedefined.faceCenter;
  self:_CaculatePrj();
  self:_CaculateCoords();
  self:_ChangeVertex();
  --self:_ChangeVertexBuffer();
end


function facecoverpri:Update(timespan, face, position, rotation, action)
  self.timespan = timespan;
  self.face = face;
  self.action = action;
  self:Process();
end
return facecoverpri;