local BundleSystem = require "venuscore.bundle.bundlesystem"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local apolloengine = require "apollocore"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local editorscene = require "editorscene"
local GenericNode = require "apolloengine.nodes.genericnode"
local apolloDefine = require "apolloutility.defiend"
local faceDefined = require "facecute.facechange.facedefined"

local editormakeupmanager = {}

function editormakeupmanager:Initialize(layer,resourceType)
  self.scene = {};
  self.baseobjects = {};
  self.layer = layer;
  self.resourceType = resourceType;
  self.counter = 0
  renderqueue:Activate(self.layer);
end

function editormakeupmanager:LoadConfig(path,makeuptype,rootconfig)
  if rootconfig.scene then

    if self.scene[makeuptype] ~= nil then --加载同类型素材
      --self.scene[makeuptype]["scene"]:ReleaseResource();
      --self.scene[makeuptype] = nil;
      --self.baseobjects[makeuptype] = nil;
      self:ReleaseResource(makeuptype);
    end
    if self.counter == 0 and makeuptype ~= faceDefined.makeupTypeNew.shared then
      pathSharedCamera = "docs:makeup/camera/scene.json"
      self:LoadConfig(
        pathSharedCamera,
        faceDefined.makeupTypeNew.shared,
        venusjson.LaodJsonFile(pathSharedCamera)
      )
    end
    local pathDir= string.match(path, "(.+)/[^/]*%.%w+$");
    local rootdir = pathDir.."/"; 
    venuscore.IFileSystem:SetResourcePath(rootdir);
    local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
    
    --收集美妆Node
    --scene:Begin(makeuptype);
    local baseobject = self:CreateInstanceFromBundle(
      venuscore.IFileSystem:PathAssembly(rootconfig.scene),
      scene,
      BundleSystem.DeserializeMode.Prefab
    );
    if makeuptype ~= faceDefined.makeupTypeNew.shared then
      self:RemoveCameraFromScene(baseobject)
    end
    --local layer = renderqueue.CAMERA_LAYER_FIRST;
    local layer = self.layer;
    --local newscene = editorscene(layer,self.mainrt);
    local newscene = editorscene(layer,self.resourceType);
    newscene:LoadConfig(baseobject);
    self.scene[makeuptype] = {["index"] = newscene.index,["scene"] = newscene};
    self.baseobjects[makeuptype] = {["index"] = newscene.index,["baseobject"] = baseobject};
    --scene:End(makeuptype);
    if makeuptype ~= faceDefined.makeupTypeNew.shared then
      self.counter = self.counter + 1
    end
  end
  return true;
end

function editormakeupmanager:RemoveCameraFromScene(baseOjbects)
  for i = 1, #baseOjbects do
    local obj = baseOjbects[i]
    if obj.HaveComponent ~= nil and obj:HaveComponent(apolloengine.Node.CT_CAMERA) then
      obj:DeleteComponent(apolloengine.Node.CT_CAMERA)
    end
  end
end

function editormakeupmanager:CreateInstanceFromBundle(path)
  local bundlepath = venuscore.IFileSystem:PathAssembly(path);
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  local _,deSerializeRes = BundleSystem:DeserializeFromPath(bundlepath,BundleSystem.DeserializeMode.Prefab,scene);
  return deSerializeRes
end

function editormakeupmanager:OnRecordStart()
end

function editormakeupmanager:IsExistMakeup()
  --self.scene是makeuptype的hash表
  -- if next(self.scene) ~= nil then 
  --   return true;
  -- end
  -- return false;
  return self.counter > 0
end


function editormakeupmanager:ReleaseResource(makeuptype)
  if self.scene[makeuptype] ~= nil then
    self.baseobjects[makeuptype] = nil;
    self.scene[makeuptype]["scene"]:ReleaseResource();
    self.scene[makeuptype] = nil;
    if makeuptype ~= faceDefined.makeupTypeNew.shared then
      self.counter = self.counter - 1
      if self.counter == 0 then
        self:ReleaseResource(faceDefined.makeupTypeNew.shared)
      end
    end
    --collectgarbage();
    return true;
  end
  
  return false;
end


function editormakeupmanager:SetMakeupStrength(strength, maketype)
  if self.scene[maketype] ~= nil then
    self.scene[maketype]["scene"]:SetMakeupStrength(strength, maketype);
    return true;
  end
  
  return false;
end

function editormakeupmanager:GetMakeupStrengthByType(type)
  if self.scene[type] ~= nil then
    return self.scene[type].scene:GetMakeupStrength(type)
  end
  return nil
end


function editormakeupmanager:Update(def)
  
  for k,v in pairs(self.scene) do 
    v["scene"]:UpdateWithOutPhysic(def)
  end
  
end

return editormakeupmanager;
