local venuscore     = require "venuscore"
local venusjson     = require "venusjson"
local resloader     = require "cartoon.resloader"
local cartoonnode  = require "emoji.cartoon"
local libmasque    = require "libmasque"
local likeapp       = require "likeapp"
local defined  = require "cartoon.defined"

local web           = nil

local loader = {}

function loader:Load(path)
  if path == nil then
    path = defined.cartoon_config_path
  end
  
  local res = true
  
  local rootconfig = venusjson.LaodJsonFile(path)
  if rootconfig ~= nil and
     rootconfig.default ~= nil
  then
    
    if self:_LoadResourceConfig(rootconfig.labels, rootconfig.default) == false
    then
      return nil;
    end

  end

  local detailPathDir, detail
  if self.image == nil then
    self.image = rootconfig.image
  end
  
  if self.image ~= nil and self.image ~= "" then
    if web == nil then
      web = require "cartoon.web"
    end
    res = web:Initialize(rootconfig.host, rootconfig.port)
    if res == true then
      res, detail = self:OnImageChanged(self.image)
    end
  else 
    local latest_detail_file = self:_GetDetailFile(rootconfig)
    detailPathDir, detail = self:_LoadJsonFile(latest_detail_file) 
  end
  
  if detail ~= nil then
    local res = {}
    res.dir, res.config = self:_ReplaceAssets(detail)    
    venusjson.SaveJsonObject(detail, "detail.json")
    
    local hair_color_bgr = detail.appearance.hair_color
    res.hair_color = {hair_color_bgr[3] / 255.0, hair_color_bgr[2] / 255.0, hair_color_bgr[1] / 255.0, 1.0}
    
    local skin_color_bgr = detail.face_reconstruction.albedo_color
    res.skin_color = {skin_color_bgr[3] / 255.0, skin_color_bgr[2] / 255.0, skin_color_bgr[1] / 255.0, 1.0}
    
    venusjson.SaveJsonObject(res, "res.json")
    return res
  end
  
  return nil
end

function loader:SetImage(image)
  self.image = image
end

function loader:OnImageChanged(image)
  if web == nil then
    return false;
  end
  
  local res, detail = web:SendImage(image)
  if res ~= true
  then
     LOG("[CARTOON]: Connect server error.")
    return false, nil;
  end  
  return res, detail;
end

function loader:_LoadResourceConfig(labels_path, resource_path)
  if labels_path == nil or resource_path == nil
  then
    return false
  end
  resloader:LoadLabels(labels_path)
  resloader:LoadResources(resource_path)
  return true
end

function loader:_LoadJsonFile(file)
  if file == nil then
    return nil, nil
  end
  local full_path = venuscore.IFileSystem:PathAssembly(file)
  local pathDir= string.match(file, "(.+)/[^/]*%.%w+$");
  local configStr = venusjson.LaodJsonFile(full_path)
  if (configStr == nil )then
    LOG("[CARTOON]: Can not find file"..full_path)
  end
  return pathDir, configStr
end

local function _DeepCopy(v)
  local t = type(v)
  if t == "table" then
    local c = {}
    for k, d in pairs(v) do
      c[k] = _DeepCopy(d)
    end
    return c
  else
    return v
  end
end

function loader:_ReplaceAssets(res)
  local id = res.appearance
  local weights = res.id_weights
  
  if id ~= nil
  then
    local gender = "female"
    if id.male == 1
    then
      gender = "male"
    end
    
    local template_file = resloader:GetTemplate(gender)
    local dir, template = self:_LoadJsonFile(template_file)
    local template_cloned = _DeepCopy(template)
    
    local models = template_cloned.cartoon.models
    for k, v in pairs(id)
    do
      local model, res = resloader:GetResource(k, v, gender)
      if model == "face"
      then
        template_cloned.cartoon.face = res
      else
        models[k] = res
      end
    end
    if weights ~= nil
    then
      --id_weights = weights
      template_cloned.cartoon.id_weights = weights
    end
    
    return nil, template_cloned.cartoon
  end

  return nil, nil
end

function loader:_GetDetailFile(rootconfig)
  local detail_win = venuscore.IFileSystem:PathAssembly(rootconfig.detail_win)
  local detail_android = venuscore.IFileSystem:PathAssembly(rootconfig.detail_android)

  local latest_file = detail_win
  
  if _PLATFORM_ANDROID then
    local path_dir = string.match(detail_android, "(.+)/[^/]*%.%w+$");
    local file_name = string.match(detail_android, "[^/]+$");
    local ext = ".json"
    file_name = file_name:sub(0, #file_name - #ext)
     
    local latest_file = nil
    
    local i, t, popen = 0, {}, io.popen
    local p = nil
    p = popen('find "'..path_dir..'" -type f -name "'..file_name..'*.json"')
    
    latest_file = file
    local latest_time = 0   
    for f in p:lines() do
       local fp = io.popen('stat -c %Y "'..f..'"')
       local last_modified = tonumber(fp:read())
       if last_modified > latest_time then
          latest_time = last_modified
          latest_file = f
       end
       fp:close()
    end
    p:close()
  end
  
  LOG("use detail file: "..latest_file)
  return latest_file
end

return loader
