local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"


local Util = {}

function Util:ConstractRotationFromVector(VectorN,VectorT)
  local resultmat = nil;

  if VectorN:Dot(VectorT) ==0 then
    VectorBN = VectorN:Cross(VectorT);
    VectorBN:NormalizeSelf();
    resultmat = mathfunction.Matrix33(
          VectorN:x(),VectorN:y(),VectorN:z(),
          VectorT:x(),VectorT:y(),VectorT:z(),
          VectorBN:x(),VectorBN:y(),VectorBN:z()
      );
  else
    local costheta = VectorN:Dot(VectorT);
    VectorBN = VectorN:Cross(VectorT);
    VectorBN:NormalizeSelf();
    --[[
    local VectorTTemp = VectorN:Cross(VectorBN);
    lengthontemp = VectorTTemp:Dot(VectorT);
    VectorTTemp =  VectorTTemp*lengthontemp;
    VectorTTemp:NormalizeSelf();]]
    
    local VectorNTemp = VectorT:Cross(VectorBN);
    VectorNTemp:NormalizeSelf();
    
    resultmat = mathfunction.Matrix33(
          VectorNTemp:x(),VectorNTemp:y(),VectorNTemp:z(),
          VectorT:x(),VectorT:y(),VectorT:z(),
          VectorBN:x(),VectorBN:y(),VectorBN:z()
      );
  end

  return resultmat;
end


return Util