local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venusjson = require "venusjson"

local likeapp
if not _PLATFORM_WINDOWS then
  likeapp = require "likeapp"
end

local CustomGiftControllerBehavior = venuscore.VenusBehavior:extend("CustomGiftControllerBehavior"); 
local maxConfigGroup = 50; 
local configSavePath = "proj:"
function CustomGiftControllerBehavior:new()
  self.playRoot = nil;  --播放礼物控制根节点
  self.playAniName = ""; --播放部分动画
  self.previewRoot = nil; --预览礼物控制根节点
  self.previewAniName = "" --预览部分动画
  self.captureCamera = nil;  --用于生产礼物定制图的相机
  self._captureCameraUpdateCnt = 0;
  
  --礼物模型根节点
  --在预览模式下，礼物可以旋转缩放
  self.previewGiftModel = nil; 
  self._previewGiftModelTrans = nil;
  self._cachedLocalPosition = mathfunction.vector3(0,0,0);
  self._cachedLocalRotation = mathfunction.Quaternion(0,0,0,1);
  self._cachedLodalScale = mathfunction.vector3(1,1,1);
  
  --礼物的骨骼动画Component
  --上边会挂多个动画(play/preview模式下有不同的动画)
  self.skeletonAnimationComponent = nil; --礼物的骨骼动画组件
end

function CustomGiftControllerBehavior:_Initialize()
  if self.previewGiftModel then
    local transComp = self.previewGiftModel:GetComponent(apolloengine.Node.CT_TRANSFORM);
    if transComp then
      self._previewGiftModelTrans = transComp;
      self._cachedLocalPosition = transComp:GetLocalPosition();
      self._cachedLocalRotation = transComp:GetLocalRotation();
      self._cachedLodalScale = transComp:GetLocalScale();
    end
  end
  if self.captureCamera then
    self.captureCamera.Active = false;
    local captureCamComp = self.captureCamera:GetComponent(apolloengine.Node.CT_CAMERA);
  end
  
end


function CustomGiftControllerBehavior:_OnAwake()
  self:_Initialize();
end


function CustomGiftControllerBehavior:_OnStart()
  
end


function CustomGiftControllerBehavior:_OnUpdate(def)
  self:_CaptureProcess();
end


function CustomGiftControllerBehavior:_CaptureProcess()
  --处理截帧的相机
  if self.captureCamera then
    if self.captureCamera.Active == true then
      if self._captureCameraUpdateCnt > 1 then
        local captureCamComp = self.captureCamera:GetComponent(apolloengine.Node.CT_CAMERA);
        if captureCamComp then
          self.captureCamera.Active = false;
          self._captureCameraUpdateCnt = 0;
          local captureRT = captureCamComp:GetAttachedRenderTarget();
          if captureRT then
            local stream = captureRT:GetAttachmentStream(apolloengine.RenderTargetEntity.TA_COLOR_0);
            if stream then
              if likeapp then
                likeapp.GiftInvokerProxy:onCaptureCallback(stream);
              else  --PC上模拟端内保存成一张图片
                apolloengine.IGraphicSystem:SaveToPng("E:\\work\\prelease\\test_capture.png",stream);
              end
            end
          end
        else
          ERROR("Capture camera is not a valid camera node");
        end
      else
        self._captureCameraUpdateCnt = self._captureCameraUpdateCnt + 1;
      end
    end
  end
end


function CustomGiftControllerBehavior:_OnPackage()
end

function CustomGiftControllerBehavior:PlayGift()
  self.previewRoot.Active = false;
  self.playRoot.Active = true;
  
  if self._previewGiftModelTrans then
    self._previewGiftModelTrans:SetLocalPosition(self._cachedLocalPosition);
    self._previewGiftModelTrans:SetLocalRotation(self._cachedLocalRotation);
    self._previewGiftModelTrans:SetLocalScale(self._cachedLodalScale);
  end
  
  if self.previewAniName ~= "" then
    self.skeletonAnimationComponent:Reset(self.previewAniName);
    self.skeletonAnimationComponent:Stop(self.previewAniName);
  end
  if self.playAniName ~= "" then
    self.skeletonAnimationComponent:Reset(self.playAniName);
    self.skeletonAnimationComponent:Play(self.playAniName);
  end
end

function CustomGiftControllerBehavior:PreviewGift()
  self.playRoot.Active = false;
  self.previewRoot.Active = true;
  
  if self.playAniName ~= "" then
    self.skeletonAnimationComponent:Reset(self.playAniName);
    self.skeletonAnimationComponent:Stop(self.playAniName);
  end
  if self.previewAniName ~= "" then
    self.skeletonAnimationComponent:Reset(self.previewAniName);
    self.skeletonAnimationComponent:Play(self.previewAniName);
  end
end

function CustomGiftControllerBehavior:PreviewSetRotation(xAngle,yAngle,zAngle)
  if self.previewGiftModel then
    local locaQuat=  mathfunction.Mathutility:YawPitchRoll(yAngle, xAngle, zAngle)
    self._previewGiftModelTrans:SetLocalRotation(locaQuat);
  end
end

function CustomGiftControllerBehavior:PreviewSetZoom(zoom)
  if self.previewGiftModel then
    self._previewGiftModelTrans:SetLocalScale(mathfunction.vector3(zoom,zoom,zoom));
  end
end

function CustomGiftControllerBehavior:PreviewReset()
  if self._previewGiftModelTrans then
    self._previewGiftModelTrans:SetLocalPosition(self._cachedLocalPosition);
    self._previewGiftModelTrans:SetLocalRotation(self._cachedLocalRotation);
    self._previewGiftModelTrans:SetLocalScale(self._cachedLodalScale);
  end
end

function CustomGiftControllerBehavior:StartCapture()
  if self.captureCamera then
    self.captureCamera.Active = true;
    
    local captureCamComp = self.captureCamera:GetComponent(apolloengine.Node.CT_CAMERA);
    captureCamComp.isFixedResolution = true;
    captureCamComp.CameraResolution = mathfunction.vector2(512,512);
  else
    ERROR("Capture camera do not correctly setup!");
  end
end


function CustomGiftControllerBehavior:GetPlayRootNode()
  return self.playRoot;
end

function CustomGiftControllerBehavior:SetPlayRootNode(rootNode)
  self.playRoot = rootNode;
end

function CustomGiftControllerBehavior:GetPreviewRootNode()
  return self.previewRoot;
end

function CustomGiftControllerBehavior:SetPreviewRootNode(rootNode)
  self.previewRoot = rootNode;
end

function CustomGiftControllerBehavior:SetAnimationComponent(aniComp)
  self.skeletonAnimationComponent = aniComp;
end

function CustomGiftControllerBehavior:GetAnimationComponent()
  return self.skeletonAnimationComponent;
end

function CustomGiftControllerBehavior:SetGiftModel(gift)
  self.previewGiftModel = gift;
end

function CustomGiftControllerBehavior:GetGiftModel()
  return self.previewGiftModel;
end

function CustomGiftControllerBehavior:GetCaptureCamera()
  return self.captureCamera;
end

function CustomGiftControllerBehavior:SetCaptureCamera(cameraRef)
  self.captureCamera = cameraRef;
end



CustomGiftControllerBehavior:MemberRegister("playAniName");
CustomGiftControllerBehavior:MemberRegister("previewAniName");

CustomGiftControllerBehavior:MemberRegister("skeletonAnimationComponent",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.AnimationComponent:RTTI(),
    CustomGiftControllerBehavior.GetAnimationComponent,
    CustomGiftControllerBehavior.SetAnimationComponent
  ));
  
 CustomGiftControllerBehavior:MemberRegister("previewGiftModel",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI(),
    CustomGiftControllerBehavior.GetGiftModel,
    CustomGiftControllerBehavior.SetGiftModel
  )); 

 CustomGiftControllerBehavior:MemberRegister("captureCamera",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI(),
    CustomGiftControllerBehavior.GetCaptureCamera,
    CustomGiftControllerBehavior.SetCaptureCamera
  )); 

CustomGiftControllerBehavior:MemberRegister("playRoot",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI(),
    CustomGiftControllerBehavior.GetPlayRootNode,
    CustomGiftControllerBehavior.SetPlayRootNode
  )); 

CustomGiftControllerBehavior:MemberRegister("previewRoot",
  venuscore.ScriptTypes.ReferenceType(
    apolloengine.Node:RTTI(),
    CustomGiftControllerBehavior.GetPreviewRootNode,
    CustomGiftControllerBehavior.SetPreviewRootNode
  )); 


return CustomGiftControllerBehavior;