
//=============================================================pbr加阴影

//----------------------------------------------------------------------------------------------------
#SHADER_DEFINE CameraspacePosition
   FUNCTION_INPUT =
    {
        { CAMERA_VIEW,                HIGH,    MAT4,        "in_ViewMatrix"},
        { LOCALWORLD_TRANSFORM,				HIGH,    MAT4,        "in_Transfrom" },
        { ATTRIBUTE_POSITION,					HIGH,    VEC4,        "in_Position" },
    }
    FUNCTION_OUTPUT =
    {
        { CAMERASPACE_POSITION,       HIGH,    VEC3,      "out_PositionCS"},

    }
#SHADER_CODE
    vec4 position_cameraspace = in_ViewMatrix * vec4(in_Transfrom * in_Position);
    vec3 out_PositionCS = position_cameraspace.xyz / position_cameraspace.w;
#END_CODE
#END_DEFINE


//画阴影用
//-------------------------------------------------------------------------
#SHADER_DEFINE SimpleFragmentOutput

	FUNCTION_INPUT = 
	{
		{ SURFACE_COLOR,	LOW,	VEC4,	"in_SurfaceColor" }
	}
	FUNCTION_OUTPUT = { }

#SHADER_CODE
    gl_FragColor = in_SurfaceColor;
#END_CODE
#END_DEFINE


//----------------------------------------------------------------------------

//计算深度
#SHADER_DEFINE ShadowTransform

	FUNCTION_INPUT = 
	{
    { LIGHT_CAMERA_VIEW,               HIGH, MAT4,   "in_LightCameraViewMatrix"},
    { LIGHT_CAMERA_PROJECTION,         HIGH, MAT4,   "in_LightCameraPorjMatrix"},
    { LIGHT_CAMERA_LINEARPARAM, HIGH,	VEC3,		"in_LightCameraLineDepthParam"},
    { LIGHT_CAMERA_POSITION,    HIGH, VEC3,   "in_LightCameraPosition"},
    { LOCALWORLD_TRANSFORM,				HIGH,    MAT4,        "in_Transfrom" },
    { ATTRIBUTE_POSITION,					HIGH,    VEC4,        "in_Position" },
	}

	FUNCTION_OUTPUT = 
	{
    { LIGHTSPACE_COORD,    HIGH, VEC4,    "out_LightCoord"},
    { WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "out_OrigDepth"}
	}

#SHADER_CODE
  const mat4 biasMatrix = mat4(0.5,0.0,0.0,0.0,
                        0.0,0.5,0.0,0.0,
                        0.0,0.0,0.5,0.0,
                        0.5,0.5,0.5,1.0);
  vec4 in_PositionWS = (in_Transfrom * in_Position);
  vec4 out_LightCoord = in_LightCameraPorjMatrix * in_LightCameraViewMatrix * in_PositionWS;
  vec4 positionCS = in_LightCameraViewMatrix * in_PositionWS;
  out_LightCoord = out_LightCoord / out_LightCoord.w;
  out_LightCoord = biasMatrix * out_LightCoord;
	highp float out_OrigDepth = ( -positionCS.z / positionCS.w - in_LightCameraLineDepthParam.x ) * in_LightCameraLineDepthParam.y;
  
#END_CODE
#END_DEFINE


//---------------------------------------------------------------------------

//整合直接光照和环境光照的效果，输出到片元（加阴影）
#SHADER_DEFINE FragmentOutputShadow

    FUNCTION_INPUT =
    {
			{ LIGHTING_DIFFUSE,				LOW,	VEC3,		"light_Diffuse" },
			{ LIGHTING_SPECULAR,			LOW,	VEC3,		"light_Specular" },
			{	IBL_DIFFUSE_COLOR,    LOW,    VEC3,        "IBL_diffuse"},
			{	IBL_SPECULAR_COLOR,    LOW,    VEC3,        "IBL_specular"},
      { WORLDSPACE_DEPTH, 			HIGH,	FLOAT,		"in_TexDepth" },
		  { WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "in_OrigDepth"},
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE
    const mediump float constant = 60.0;
    float expFactor = clamp(exp(constant * ( in_TexDepth - in_OrigDepth) ),0.0,1.0);
		//环境贴图对当前片元颜色的贡献
		vec3 ambient =  IBL_diffuse + IBL_specular ;
		//光源对当前片元颜色的贡献
		vec3 color =  (light_Specular+light_Diffuse)*expFactor+ambient;

		// HDR tonemapping
		//color = color / (color + vec3(1.0));

		// gamma correct
		color = pow(color, vec3(1.0/2.2));
        gl_FragColor = vec4(color,1.0);

#END_CODE
#END_DEFINE

//---------------------------------------------------------------------------

//整合直接光照和环境光照的效果，输出到片元（画半透明阴影贴图）
#SHADER_DEFINE FragmentOutputShadowTransparent

    FUNCTION_INPUT =
    {
			{ LIGHTING_DIFFUSE,				LOW,	VEC3,		"light_Diffuse" },
			{ LIGHTING_SPECULAR,			LOW,	VEC3,		"light_Specular" },
			{	IBL_DIFFUSE_COLOR,    LOW,    VEC3,        "IBL_diffuse"},
			{	IBL_SPECULAR_COLOR,    LOW,    VEC3,        "IBL_specular"},
      { WORLDSPACE_DEPTH, 			HIGH,	FLOAT,		"in_TexDepth" },
      { LIGHT_COLOR, 					MEDIUM,			VEC3,			"in_LightColor"},
		  { WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "in_OrigDepth"},
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE
    const mediump float constant = 60.0;
    float expFactor = clamp(exp(constant * ( in_TexDepth - in_OrigDepth )),0.0, 1.0 );

		//环境贴图对当前片元颜色的贡献
		vec3 ambient =  IBL_diffuse + IBL_specular ;
		//光源对当前片元颜色的贡献
		vec3 color =  (light_Specular+light_Diffuse)*expFactor+ambient;

		// HDR tonemapping
		//color = color / (color + vec3(1.0));

		// gamma correct
		color = pow(color, vec3(1.0/2.2));
		gl_FragColor =  mix(vec4(vec3(1.0),0.0),vec4(color,0.5),expFactor);

#END_CODE
#END_DEFINE

//--------------------------------------------------------------------------

//画不透明材质的半透明阴影贴图
#SHADER_DEFINE OpaqueShadowFragmentOutput

	FUNCTION_INPUT =  { }
	FUNCTION_OUTPUT = { }

#SHADER_CODE
	gl_FragColor = vec4(1.0,1.0,1.0,0.0);
#END_CODE
#END_DEFINE