#include "functions/util.function"
#SHADER_DEFINE DisgaussVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCoordinate"},
       
	}
	FUNCTION_OUTPUT =
	{
        { ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;  
    vec2 out_TexCooridate;
    out_TexCooridate= in_TexCoordinate.xy;     // upper left corner
 
#END_CODE

#END_DEFINE


#SHADER_DEFINE DisgaussFragment

	FUNCTION_INPUT = 
	{
        { TEXTURE_uBwm,		    	NONE,	TEXTURE2D,	  "uBwm" },
		{ TEXTURE_uHam,		    	NONE,	TEXTURE2D,	  "uHam" },
        { ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"vUV"},
		{ UNIFORM_uOs,				HIGH,	VEC2,		"uOs"},
		{ UNIFORM_uEfa,            	MEDIUM, FLOAT,   	"uEfa"},
		{ UNIFORM_uWad,             MEDIUM, FLOAT,   	"uWad"},
        { UNIFORM_uEds,            	MEDIUM, FLOAT,   	"uEds"},
        { UNIFORM_uVer,            MEDIUM, FLOAT,   	"uVer"}
	}
  
#SHADER_CODE

	vec2 bad;
    //if (abs(uVer - 2.0) < 0.0001) {
        bad = normalize(decode(texture2D(uBwm, vUV)));
    //}
    //else bad = normalize(texture2D(uBwm, vUV).xy);

    vec2 dir = ( abs(uEds) < 0.0001 ) ? vec2(bad.y, -bad.x) : bad;
    vec2 offset = dir * uOs;
    
    vec3 center = texture2D(uHam, vUV).rgb;
    vec3 result = center;
    float sum = 1.0;
    
    for (int i = 0; i < 6; ++i) {
        vec3 c0 = texture2D(uHam, vUV + float(i) * offset).rgb;
        vec3 c1 = texture2D(uHam, vUV - float(i) * offset).rgb;
        float lc0 = distance(c0, center);
        float lc1 = distance(c1, center);
        float k0 = gauss(float(i), uEfa) * gauss(lc0, uWad);
        float k1 = gauss(float(i), uEfa) * gauss(lc1, uWad);
        sum += k0 + k1;
        result += c0 * k0 + c1 * k1;
    }

    result /= sum;
    gl_FragColor = vec4(result, 1.0);
    
 
#END_CODE

#END_DEFINE

