

#DEFPARAMS
#END

#DEFTAG
ShaderName = "Outline1"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "utils.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_uBwm;
Texture2D TEXTURE_uHam;
SamplerState uBwm_Sampler;
SamplerState uHam_Sampler;
float UNIFORM_uTau;
float2 UNIFORM_uOs;
float UNIFORM_uHiu;
float UNIFORM_uVer;
float UNIFORM_uSmooth;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float2 bad;
    //if (abs(uVer - 2.0) < 0.0001) {
        float4 dircolor = TEXTURE_uBwm.Sample(uBwm_Sampler, i.uv);
        bad = decode(dircolor);
    //}
    //else bad = texture2D(uBwm, textureCoordinate).xy;

    float2 dir = normalize(float2(bad.y, -bad.x));
    float2 offset = dir * UNIFORM_uOs * UNIFORM_uSmooth;
    float voi0 = UNIFORM_uHiu;
    float voi1 = UNIFORM_uHiu * 1.6;

    float k0 = gauss(0.0, voi0);
    float sum0 = k0;
    float3 result0 = TEXTURE_uHam.Sample(uHam_Sampler, i.uv).rgb * k0;

    float k1 = gauss(0.0, voi1);
    float sum1 = k1;
    float3 result1 = TEXTURE_uHam.Sample(uHam_Sampler, i.uv).rgb * k1;

    for (int j = 1; j < 3; ++j) {
        float3 c0 = TEXTURE_uHam.Sample(uHam_Sampler, i.uv + float(j) * offset).rgb;
        float3 c1 = TEXTURE_uHam.Sample(uHam_Sampler, i.uv - float(j) * offset).rgb;

        k0 = gauss(float(j), voi0);
        sum0 += k0 + k0;
        result0 += c0 * k0;
        result0 += c1 * k0;

        k1 = gauss(float(j), voi1);
        sum1 += k1 + k1;
        result1 += c0 * k1;
        result1 += c1 * k1;
    }

    result0 /= sum0;
    result1 /= sum1;
    float d = (result0.x - 0.9985 * result1.x) * 100.;
    float d2 = (result0.x - (0.99 + UNIFORM_uTau) * result1.x) * 100.;

    mainColor = float4(d, d2, 0.0, 0.0);
}
ENDCG
#END
