local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local Ripple = {}


Ripple.Rip = 0;
Ripple.Mat = 0;
Ripple.Queue = 320;

function Ripple:Initialize(host, size)
  
  self.UNIFORM_TIME = apolloengine.IMaterialSystem:NewParameterSlot(
       apolloengine.ShaderEntity.UNIFORM,
       "UNIFORM_TIME");
  self.UNIFORM_XYRATIO = apolloengine.IMaterialSystem:NewParameterSlot(
       apolloengine.ShaderEntity.UNIFORM,
       "UNIFORM_XYRATIO");
  self.UNIFORM_POINT = apolloengine.IMaterialSystem:NewParameterSlot(
       apolloengine.ShaderEntity.UNIFORM,
       "UNIFORM_POINT");
  self.UNIFORM_RADIUS = apolloengine.IMaterialSystem:NewParameterSlot(
       apolloengine.ShaderEntity.UNIFORM,
       "UNIFORM_RADIUS");
  self.UNIFORM_WAVEWIDTH = apolloengine.IMaterialSystem:NewParameterSlot(
       apolloengine.ShaderEntity.UNIFORM,
       "UNIFORM_WAVEWIDTH");
  self.UNIFORM_DISFACTOR =apolloengine.IMaterialSystem:NewParameterSlot(
       apolloengine.ShaderEntity.UNIFORM,
       "UNIFORM_DISFACTOR");
  self.UNIFORM_AMPFACTOR =apolloengine.IMaterialSystem:NewParameterSlot(
       apolloengine.ShaderEntity.UNIFORM,
       "UNIFORM_AMPFACTOR");
     
  local pathout = venuscore.IFileSystem:PathAssembly("docs:filter/ripple/filter/resource/material/ripple.material");
  self.Mat = host:CreateMaterial(pathout);  
  self.Rip = host:CreateRenderObject();
  self.Mat:SetParameter(self.UNIFORM_XYRATIO, mathfunction.vector1(size:y()/size:x()));
  
  return self.Queue;
  
end

function Ripple:Resizeview(size)
  self.Mat:SetParameter(self.UNIFORM_XYRATIO, mathfunction.vector1(size:y()/size:x()));
end

function Ripple:Process(context, Original, Scene, Output)
  --Output:PushRenderTarget();
  --Output:ClearBuffer(apolloengine.RenderTargetEntity.CF_COLOR);
  context:BeginRenderPass(Output,apolloengine.RenderTargetEntity.CF_COLOR);
  self.Mat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
	--self.Rip:Draw(pipeline);
  context:Draw(self.Rip,self.Mat);
  context:EndRenderPass();
end

return Ripple;

