local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local IsStateMachineRunningCommand = CommandBase:extend("IsStateMachineRunningCommand");

function IsStateMachineRunningCommand:new(uuid)
    IsStateMachineRunningCommand.super.new(self);
    self._uuid = uuid;
    self._isRunning = false;
  end
  
  function IsStateMachineRunningCommand:DoIt()
      self:BeginCmd();
      if self._uuid then
        local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
        if ani then
           self._isRunning = ani:IsStateMachinesRunning();
        end
      end
      self:EndCmd();
  end
  
  function IsStateMachineRunningCommand:Undo()
      self:BeginCmd();
      self:EndCmd();
  end
  
  return IsStateMachineRunningCommand;