local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local GetParamTypeCommand = CommandBase:extend("GetParamTypeCommand");

function GetParamTypeCommand:new(comuid, smsId, paramIndex)
    GetParamTypeCommand.super.new(self);
    self._comUid = comuid;
    self._smsId  = smsId;
    self._index  = paramIndex;
    self._pt   = nil;
end

function GetParamTypeCommand:DoIt()
    self:BeginCmd();
    local ani = self:GetContent(self._comUid);
    if ani then
        self._pt = ani:GetParameterType(self._smsId, self._index);
    end
    self:EndCmd();
end

function GetParamTypeCommand:Undo()
    self:BeginCmd();
    self:EndCmd();
end

return GetParamTypeCommand;