local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local sharpen = {}
sharpen.material = nil;
sharpen.renderobject = nil;
sharpen.Queue = 119;

function sharpen:_SetParam(size)  -- fortest
  self.height= size:y();
  self.hOffset=1.0/self.height;
  self.width=size:x();
  self.wOffset=1.0/self.width;
  self.material:SetParameter(self.PIXEL_OFFSETS, mathfunction.vector2( self.wOffset, self.hOffset ) );
end

function sharpen:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.SHARPNESS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"SHARPNESS");  
  self.PIXEL_OFFSETS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"PIXEL_OFFSETS");  
  self.SQUARE_COORDINATE = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.INTERNAL,"SQUARE_COORDINATE");
  self.renderobject = host:CreateRenderObject();
  self.material = host:CreateMaterial("comm:documents/filter/material/sharpen.material" );
  self.material:SetParameter(self.SHARPNESS, mathfunction.vector1( 0.7 ) );
  self:_SetParam(size);
  return self.Queue;
end

function sharpen:Resizeview(size)
  --self:_SetParam(size);
end

function sharpen:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.renderobject, self.material);
  context:EndRenderPass();
end

return sharpen;