local MF = require "mathfunction"
local BN = require "bluecore.bluenode"
local BlueDefined = require "bluecore.bluedefined"

local Direction2Rotate = BN:extend();


function Direction2Rotate:new(...)
  Direction2Rotate.super.new(self,...)
end

function Direction2Rotate:_OnUpdate(args)
  local rot = args[1];
  return MF.Mathutility:Direction2Euler(rot);
end


Direction2Rotate:RegisterInput(1, MF.vector3:RTTI(), "direction", "方向向量", MF.vector3(0.0, 1.0, 0.0));

Direction2Rotate:RegisterOutput(1, MF.vector3:RTTI(), "rotate(rad)", "旋转角(弧度)");

Direction2Rotate:SetFunctionName("Direction2Rotate");

Direction2Rotate:SetFunctionType(BlueDefined.STATIC_FUNCTION_NODE);



return Direction2Rotate;
