local mf = require "mathfunction"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local Vec3MultiFloat = BlueNode:extend();

---- 游戏运行模式
function Vec3MultiFloat:new(...)
  Vec3MultiFloat.super.new(self, ...)
end

function Vec3MultiFloat:_OnUpdate(args)
  local one = args[1] ;
  local two = args[2] ;
  return one * two ;
end

---- 编辑器模式

Vec3MultiFloat:RegisterInput(1, mf.vector3:RTTI(), "vector3", "向量(x,y,z)", mf.vector3(1.0,1.0,1.0));
Vec3MultiFloat:RegisterInput(2, Types.FloatType, "scale", "scale", 1.0);
Vec3MultiFloat:RegisterOutput(1, mf.vector3:RTTI(), "multi", "向量数乘 scale * vec(x,y,z)");
Vec3MultiFloat:SetFunctionName("vector3 * float");
Vec3MultiFloat:SetFunctionType(BD.STATIC_FUNCTION_NODE);


return Vec3MultiFloat;