


local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"


local BlueSelf = require "bluecore.blueself"

local Types = require "venuscore.rtti.types"
local SetParameterNode = require "bluecore.setparameternode"

local SetScalarValueInRange = SetParameterNode:extend();
--Unreal Engine: Set Scalar Parameter Value

---- 游戏运行模式
function SetScalarValueInRange:new(...)
  SetScalarValueInRange.super.new(self, ...)
end

function SetScalarValueInRange:_OnUpdate(args)
  local paraType = self:GetParameterType(args);
  if not paraType then 
    return;
  end
  if paraType == apolloengine.MaterialEntity.VT_FLOATRANGE then
  	local _Slot = apolloengine.IMaterialSystem:GetParameterSlot(args[2]);
  	local _DefProperty = args[1]:GetDefProperty(_Slot);
  	local result = args[3];
  	local floatRange = _DefProperty:GetFloatRange();
    if result > floatRange.ceil then
      result = floatRange.ceil;
    elseif result < floatRange.floor then
      result = floatRange.floor;
    end
    args[1]:SetParameter(args[2], result);
  else
    self.errorWarning = "parameter type not matched!";
  end
end



---- 编辑器模式



SetScalarValueInRange:RegisterInput(1, apolloengine.MaterialEntity:RTTI(), "Material", "材质实体", BlueSelf());
SetScalarValueInRange:RegisterInput(2, Types.StringType, "ParaName", "参数名字", "None");
SetScalarValueInRange:RegisterInput(3, mathfunction.vector1:RTTI(), "ParaValue", "参数值", mathfunction.vector1(1.0));



SetScalarValueInRange:RegisterExecInput(1, "exec", "执行");

SetScalarValueInRange:RegisterExecOutput(1, "exec", "执行");

SetScalarValueInRange:SetFunctionName("SetScalarValueInRange");


return SetScalarValueInRange ;

