local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local Delay = BlueNode:extend();
--Unreal    Delay节点(UE没有Suspend Replay Reset引脚)
--目前做法是寄存到一个manager里头update统一调用  
--  并重写Update OnUpdate函数  延迟结束会递归调用连接的节点

---- 游戏运行模式
function Delay:new(...)
  Delay.super.new(self, ...)
  self.duratime = nil;
  self.isrunning = false;
  self.needDelay = true;
end


function Delay:Update(exec_idx)

  self:_GetInput();

  if _KRATOSEDITOR and self.debugStatus and self.graph.isrunning then
    local BuEd = require "bluecore.editor.blueutility_ed"
    BuEd:BlueDebugYield(self);
  end

  if exec_idx == 1 then  --Start
    if not self.isrunning then --开始延迟以后不走Update逻辑而走OnUpdate逻辑
      self.isrunning = true;
      --step 2 执行本方法
      self:_OnUpdate(self.inputArgs);
    end
  elseif exec_idx == 2 then --SusPend
    self.isrunning = false;
  elseif exec_idx == 3 then --Replay
    self.isrunning = true;
    self.duratime = nil;
    self:_OnUpdate(self.inputArgs);
  else  --Reset
    self.isrunning = false;
    self.duratime = nil;
  end
end

--bluedelaymanager调用onupdate函数且不会传入参数
function Delay:_OnUpdate(args)

  if self.isrunning then
    --delay的时候延迟时间只在初始化受输入影响
    --延迟时间初始化的时候只负责赋值 
    if not self.duratime then
      self.duratime = args[1];
      return;
    end

    if self.duratime <= 0 then
      self.duratime = nil;
      self.isrunning = false;
      if _KRATOSEDITOR then
        local BuEd = require "bluecore.editor.blueutility_ed"
        BuEd:BlueDebugYield(self);
      end
      local lastNode = self;
      local execIdx  = 1;
      local nextIdx  = self.nextExecIndex[1];
      local nextNode = self.nextExecNodes[1]
      while nextNode ~= nil
      do
        if _KRATOSEDITOR then
          local link_uid = lastNode.execOutputs[execIdx].links[1].linkUid;
          self.graph:AddExecLinkList(link_uid);
        end
        lastNode = nextNode;
        execIdx  = nextNode:Update(nextIdx);
        nextIdx  = nextNode.nextExecIndex[execIdx];
        nextNode = nextNode.nextExecNodes[execIdx];
      end
    else
      self.duratime = self.duratime - self.graph.deltaTime;
      return;
    end

  end

end

function Delay:_OnStop()
  self.duratime = nil;
  self.isrunning = false;
end

function Delay:_OnReset()
  self:_OnStop();
end

---- 编辑器模式


Delay:RegisterInput(1, Types.FloatType, "Duration", "延迟时间", 0.2);

Delay:RegisterExecInput(1, "Start", "开始/恢复倒数");
Delay:RegisterExecInput(2, "Suspend", "暂停倒数");
Delay:RegisterExecInput(3, "Replay", "倒数重置");
Delay:RegisterExecInput(4, "Reset", "倒数重置并暂停");

Delay:RegisterExecOutput(1, "Completed", "执行");

Delay:SetFunctionName("Delay");

return Delay ;