local AE = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local BD = require "bluecore.bluedefined"

local IsActiveHierarchy = BlueNode:extend();

function IsActiveHierarchy:new(...)
	IsActiveHierarchy.super.new(self,...);
end

function IsActiveHierarchy:_OnUpdate(args)
	if args[1] ~= nil  then
		return args[1]:isActiveHierarchy();
	else
		return false
	end
end

IsActiveHierarchy:RegisterInput(1, AE.Node:RTTI(), "target", "node", BlueSelf());
IsActiveHierarchy:RegisterOutput(1, Types.BoolType, "active", "node and parent node is active?");

IsActiveHierarchy:SetFunctionType(BD.STATIC_FUNCTION_NODE);
IsActiveHierarchy:SetFunctionName("Hierarchy Active?");

return IsActiveHierarchy;