local apolloengine = require "apolloengine"
local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local ActiveReplayAni = BlueNode:extend();

---- 游戏运行模式
function ActiveReplayAni:new(...)
	ActiveReplayAni.super.new(self,...);
end

function ActiveReplayAni:_RecursiveResetNode(rootNode, type)
	local childNode = rootNode:GetChildrens();
	for i=1,#childNode do
		local node = childNode[i];
		node.Active = true ; -- 递归的话 把子node也激活
		self:_Play(node, type, true);
	end
end

function ActiveReplayAni:_Play(rootNode, type, recursive)

	local comp = rootNode:GetComponent(type);
	if comp then
		comp:Reset();
		comp:Play();
	end

	if recursive then
		self:_RecursiveResetNode(rootNode, type);
	end

end

function ActiveReplayAni:_OnUpdate(args)
	local rootNode = args[1]
	local recursive = args[2]
	local ani = args[3]
	local frame = args[4]
	rootNode.Active = true ;
	if ani then
		self:_Play(rootNode, apolloengine.Node.CT_ANIMATION, recursive);
	end
	if frame then
		self:_Play(rootNode, apolloengine.Node.CT_FRAME_PLAYER, recursive);
	end
end

---- 编辑器模式
--在根节点设置子节点active状态实现场景切换
ActiveReplayAni:RegisterInput(1, apolloengine.Node:RTTI(), "target", "当前节点", BlueSelf());
ActiveReplayAni:RegisterInput(2, Types.BoolType, "recursive", 	"递归子节点", false); -- false减少递归使用
ActiveReplayAni:RegisterInput(3, Types.BoolType, "animation", "动画",   false);
ActiveReplayAni:RegisterInput(4, Types.BoolType, "frame", 		"序列帧", false);

ActiveReplayAni:RegisterExecInput(1, "exec", "Execute");
ActiveReplayAni:RegisterExecOutput(1, "exec", "Execute");

ActiveReplayAni:SetFunctionName("Active Then Replay");

return ActiveReplayAni;