local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local SetScriptValue = require "bluecore.base.set_script_value"
local SetScriptColor = SetScriptValue:extend();


---- 游戏运行模式
function SetScriptColor:new(...)
  SetScriptColor.super.new(self, ...)

end

function SetScriptColor:_OnUpdate(args)

  local scriptIns = args[1];
  local para = args[2];
  --scriptIns[para] = args[3];
  scriptIns:SetScriptValue(para, args[3]);
end



function SetScriptColor:_IsRightType(key, value, scriptIns)
  return type(value) == "userdata" and value:RTTI() == mathfunction.Color:RTTI();
end



SetScriptColor:RegisterInput(1, Types.ScriptInsRefType, "Script_Instance", "behaviour", Types.NotNullType());
SetScriptColor:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING);
SetScriptColor:RegisterInput(3, mathfunction.Color:RTTI(), "ParaValue", "参数值", mathfunction.Color(1.0,0.0,0.0,0.0));


SetScriptColor:RegisterExecInput(1, "exec", "执行");

SetScriptColor:RegisterExecOutput(1, "exec", "执行");

SetScriptColor:SetFunctionName("SetScriptColor");


return SetScriptColor ;

