local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local BlueUtility = require "bluecore.blueutility"
local GetPostEffectValue = require "bluecore.base.get_posteffect_value"
local GetPostEffectTexture2D = GetPostEffectValue:extend();


---- 游戏运行模式
function GetPostEffectTexture2D:new(...)
  GetPostEffectTexture2D.super.new(self, ...)
end



function GetPostEffectTexture2D:_IsRightType(value)
  return type(value) == "userdata" and value:RTTI() == apolloengine.TextureEntity:RTTI();
end



GetPostEffectTexture2D:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
GetPostEffectTexture2D:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); 

GetPostEffectTexture2D:RegisterOutput(1, apolloengine.TextureEntity:RTTI(), "ParaValue", "输出纹理");

GetPostEffectTexture2D:SetFunctionName("GetPostEffectTexture2D");


return GetPostEffectTexture2D ;


