local libvenuscore = require "libvenuscore"
local Types = require "venuscore.rtti.types"
local BlueRtti = require "bluecore.core.blue_rtti"
local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"
--local ArrayItemWrap = require "bluecore.core.array_item_wrap"

--作用  反射到反射面板可以选函数模板input/output的类型等信息
--作为数组存到bluefunction.lua这个behavior里头序列化出去

local BlueFunctionPinInfo = libvenuscore.Object:extend("BlueFunctionPinInfo");


function BlueFunctionPinInfo:_GetCombo()
  return self.base_rtti_name;
end

function BlueFunctionPinInfo:_SetCombo(value)
  LOG("[BlueFunctionPinInfo] SetCombo "..tostring(self.base_rtti_name).."->"..tostring(value))
  local old = self.base_rtti_name;
  if old ~= value then --一样的就不要回调了
    self.base_rtti_name = value
    self:_RedefineDefault();
    if self._CreatedDone then
      self._Owner:ChangeInfo(self, BD.FuncInfoProp.BaseType, self:GetRtti(), self.isInput);
    end
  end
end

function BlueFunctionPinInfo:GetIsArray()  -- ArgInfo:GetIsArray
  return self.is_array
end

function BlueFunctionPinInfo:_GetIsArray()
  return self.is_array
end

function BlueFunctionPinInfo:_SetIsArray(value)
  local old = self.is_array
  if old ~= value then
    self.is_array = value ;
    self:_RedefineDefault();
    if self._CreatedDone then
      self._Owner:ChangeInfo(self, BD.FuncInfoProp.BaseType, self:GetRtti(), self.isInput);
    end
  end
end

function BlueFunctionPinInfo:_GetName()
  return self.name
end

function BlueFunctionPinInfo:_SetName(name)
  local old = self.name
  self.name = name ;
  if self._CreatedDone then
    self._Owner:ChangeInfo(self, BD.FuncInfoProp.Name, name, self.isInput);
  end
end

function BlueFunctionPinInfo:_GetDefault()
  return self.default_value
end

function BlueFunctionPinInfo:_SetDefault(new_default)
  self.default_value = new_default ;
  if self._CreatedDone then
    self._Owner:ChangeInfo(self, BD.FuncInfoProp.Value, new_default, self.isInput);
  end
end


--function BlueFunctionPinInfo:_CreateDefaultItem()
--  local item = ArrayItemWrap()
--  -- 改变每个实例的TypeInfo但是不改变类的TypInfo
--  -- 这需要反序列化的时候先创建好实例并根据元信息设置好typeinfo
--  local tinfo = self:_GetTypeInfo(self.base_rtti,false, true);
--  if tinfo then -- 非Lua Object需要typeinfo支持
--    tinfo:SetKeyname("value"); -- 用来保证basetype没有设置set和get的时候 内部生成一个set和get函数
--    item.__typeinfos["value"] = tinfo
--  else
--    WARNING("array elemenet self.base_rtti  is lua object "..tostring(self.base_rtti))
--  end
--  item.value = BU:GetDefaultByRtti(self.base_rtti);
--  return item
--end

function BlueFunctionPinInfo:_GetDefaultArray()
  return { unpack(self.default_value) }
end

function BlueFunctionPinInfo:_SetDefaultArray(value)
  self.default_value = { unpack(value) }
end

function BlueFunctionPinInfo:_RedefineDefault()

  local rtti, rttiOfArray = BlueRtti.GetRtti(self.base_rtti_name, self.is_array);

  -- For BlueprintClass base_rtti_name is ClassID
  self.base_rtti = rtti

  if self.base_rtti == nil then
    error("[_RedefineDefault] rtti not found "..tostring(self.base_rtti_name))
  end

  -- 修改类型 需要重新分配default值
  if not self.is_array then
    if self._CreatedDone or self.default_value == nil then -- 避免反序列化过程中 先设置default_value 再设置rtti(SetCombo) 导致默认值被覆盖
      self.default_value = BU:GetDefaultByRtti(self.base_rtti)
    end
    self.rtti = self.base_rtti
  else
    self.default_value = {} -- 如果是数组 默认值是个空数组
    self.rtti = rttiOfArray
  end


  local typeinfo = self:_GetTypeInfo(self.base_rtti, self.is_array, false,
          self.is_array and BlueFunctionPinInfo._GetDefaultArray or BlueFunctionPinInfo._GetDefault,
          self.is_array and BlueFunctionPinInfo._SetDefaultArray or BlueFunctionPinInfo._SetDefault)

  if typeinfo ~= nil then
    typeinfo:SetKeyname("default_value"); -- basetype 会生成get和set
    self.__typeinfos["default_value"] = typeinfo;
  else
    self.__typeinfos["default_value"] = nil;
    WARNING("base_rtti "..tostring(self.base_rtti:GetTypeName()).." is lua object")
  end

end



function BlueFunctionPinInfo:_GetTypeInfo(baseRtti, isArray, isArrayItem, getFtn , setFtn)

  if isArray then
    assert(getFtn and setFtn , "function must be given if array");
    assert(not isArrayItem, "not support 2d-array")
    -- return Types.ArrayType(BlueFunctionPinInfo._CreateDefaultItem, getFtn, setFtn);
    -- typeInfo is BaseType & default_value is {}  =>  base_type_reflector.lua  => nothing display
    return Types.BaseType(getFtn, setFtn) -- 目前函数参数 如果是数组 不支持带默认参数 (基础类型没有问题 引用类型对'调用函数节点'生成字面值是个Node就会有问题)
  else
    local typeInfo = BlueRtti.GetTypeInfo(baseRtti)

    -- Node,Component引用类型,BlueprintType作为函数参数都是nil,不能在反射面板显示
    -- 默认值是nil typeinfo是BaseType autoreflection
    if typeInfo == Types.ReferenceType then
      return Types.BaseType(getFtn, setFtn)
    elseif baseRtti.GetClassId then
      return Types.BaseType(getFtn, setFtn)
    end

    if typeInfo ~= nil then
      return typeInfo(getFtn, setFtn);
    else -- 目前不支持脚本对象
      error("[BlueVariableInfo] Not support "..tostring(baseRtti:GetTypeName()));
    end
  end
end

-- reference BlueVariableInfo
function BlueFunctionPinInfo:new(baseRttiName, isArray)
  self._Owner = nil

  self.base_rtti_name = baseRttiName
  self.is_array = isArray

  self.__typeinfos = {}
  local clazz = getmetatable(self)
  for k, v in pairs(clazz.__typeinfos) do
    self.__typeinfos[k] = v;
  end

  self:_RedefineDefault();

end

function BlueFunctionPinInfo:EditorCreate(isInput, name, tips, argUid)

  assert(argUid ~= nil, "argUid is nil" )

  self.argUid = argUid ; -- 参数的唯一ID

  --self.is_array = is_array or false
  --self.rtti = nil ;
  --self.base_rtti = nil;
  self.isInput = isInput;
  self.name = name or "NotValid";
  --self.is_private = is_private or true
  --self.is_const = is_const or false
  --self.is_final = is_final or false;
  self.tips = tips or "N/A";
  self.is_ref = false;


  self._CreatedDone = true  -- EditorCreated or onDeserialize is Done

end

function BlueFunctionPinInfo:_OnDeserialize()
  --self:_RedefineDefault(); -- 反序列过程中setCombo会re-define
  self._CreatedDone = true -- 到这里 MemberRegister和依赖Member的其他Member都完成重建
end

-- IChangeInfo
function BlueFunctionPinInfo:SetOwner(iChangeInfo)
  if not iChangeInfo.ChangeInfo then error("Owner should implement interface ChangeInfo") end
  self._Owner = iChangeInfo -- owner should
end

function BlueFunctionPinInfo:GetRtti()
  return self.rtti
end

function BlueFunctionPinInfo:GetBaseRttiName()
  return self.base_rtti_name
end

--[[function BlueFunctionPinInfo:IsArray()
  return self.is_array
end]]--

function BlueFunctionPinInfo.OutputFilterFtn(obj, member, value)
  if member == "default_value" or member == "isInput" then 
    return false;
  else
    return true;
  end  
end 

function BlueFunctionPinInfo.InputFilterFtn(obj, member, value)
  if member == "isInput" then 
    return false;
  else
    return true;
  end  
end

function BlueFunctionPinInfo:GetName()
  return self.name
end

function BlueFunctionPinInfo:GetTips()
  return self.tips
end

function BlueFunctionPinInfo:GetDefault()
  return self.default_value
end

--[[function BlueFunctionPinInfo:GetSpecData()
  local cls_spec_data = {} ;
  cls_spec_data[BD.RefVarName] = self.name ;
  return cls_spec_data
end]]--


BlueFunctionPinInfo:MemberRegister("name",
        Types.StringType(BlueFunctionPinInfo._GetName, BlueFunctionPinInfo._SetName));

BlueFunctionPinInfo:MemberRegister("base_rtti_name",
        Types.ComboType(BlueRtti.GetComboData,  BlueFunctionPinInfo._GetCombo, BlueFunctionPinInfo._SetCombo) );


BlueFunctionPinInfo:MemberRegister("is_array", Types.BoolType(BlueFunctionPinInfo._GetIsArray, BlueFunctionPinInfo._SetIsArray) )
BlueFunctionPinInfo:MemberRegister("default_value");
BlueFunctionPinInfo:MemberRegister("is_ref", Types.BaseType(), "none");
BlueFunctionPinInfo:MemberRegister("argUid", Types.BaseType(), "none"  );
BlueFunctionPinInfo:MemberRegister("tips");
BlueFunctionPinInfo:MemberRegister("isInput");

return BlueFunctionPinInfo ;