local BD = require "bluecore.bluedefined"
local TC = require "bluecore.base.transaction_center"
local BU = require "bluecore.blueutility"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local TransactionNode = BlueNode:extend();
local venusjson = require "venusjson"

local READY_PIN = 1
local TIMEOUT_PIN = 2
local REJECT_PIN = 3

TransactionNode.BlueNodeExtend = BlueNode.extend

function TransactionNode:extend(...)
  local clazz = TransactionNode.BlueNodeExtend(self, ...)
  for pinType, infos in pairs(TransactionNode.infoTable) do
    for _, info in pairs(infos) do
      local newInfo = {}
      for key, value in pairs(info) do
        newInfo[key] = value -- if value is object, ignore deepcopy it maybe ok
      end
      table.insert(clazz.infoTable[pinType], newInfo)
    end
  end
  return clazz
end

function TransactionNode:new(...)
  TransactionNode.super.new(self, ...)
  self.timeout = -1 ;
  self.accTime = 0 ;
  self.transitionId = nil
end


function TransactionNode:_OnUpdate(args)

  if self.transitionId ~= nil then
    -- 当前请求没有应答 不会重新发送请求
    return
  end

  local timeout = args[1] or -1

  local transactionId
  for i = 0 , 10 do -- try 10 times
    math.randomseed(os.time() + i* 314159)
    transactionId = math.ceil(math.random() * 1000000) -- ??
    LOG("transitionId "..tostring(transactionId))
    if not TC:HasTransaction(transactionId, self) then
      LOG("transitionId good "..tostring(i))
      break
    end
    transactionId = nil
  end

  if transactionId == nil then -- 获取不了有效的id
    ERROR("fail to generate transitionId")
    return
  end

  self.timeout = timeout
  self.transitionId = transactionId
  self.accTime = 0

  TC:Request(self, transactionId, self:_OnRequestType(), self.timeout , self:_OnRequestJson() );

end

-- 不会立刻执行后续引脚
function TransactionNode:_OnNextBranch()
  return 0
end

-- 录制重置
function TransactionNode:_OnReset()

end

-- 释放素材
function TransactionNode:_OnStop()
  TC:Clear(self.transitionId)
  self.transitionId = nil
end


-- Call by TC
function TransactionNode:_IsTimeOut(deltaMs)
  --LOG("timeout "..tostring(self.timeout)..", accTime "..tostring(self.accTime))
  if self.timeout > 0 then
    self.accTime = self.accTime + deltaMs ;
    if self.accTime > self.timeout then
      WARNING("timeout now");
      return true
    end
  end
  return false
end

-- Call by TC
function TransactionNode:_TimeOut()
  self.outputResults = {} -- no result, maybe next node get null as input
  self:_RunNext(TIMEOUT_PIN);
end

-- Call by TC
function TransactionNode:_Ready(jsonResult)
  -- BlueNode  self.outputResults = {_OnUpdate()}
  local jsonTbl = venusjson.LoadJsonString(jsonResult); -- LoadJsonString("") will crash
  self.outputResults = {self:_OnJsonToResult(jsonTbl)}
  if self:_OnCheckReady(self.outputResults) then
    self:_RunNext(READY_PIN);
  else
    self:_RunNext(REJECT_PIN);
  end

end

function TransactionNode:_RunNext(next)

  self.transitionId = nil ;

  -- 事件图表 事件节点后继的执行节点

  local nextIdx = self.nextExecIndex[next];
  local nextNode = self.nextExecNodes[next];
  local lastNode = self;
  local execIdx = next;
  while nextNode ~= nil
  do
    if _KRATOSEDITOR then
      local link_uid = lastNode.execOutputs[execIdx].links[1].linkUid;
      self.graph:AddExecLinkList(link_uid);
    end
    lastNode = nextNode;
    execIdx = nextNode:Update(nextIdx);
    nextIdx  = nextNode.nextExecIndex[execIdx];
    nextNode = nextNode.nextExecNodes[execIdx];
  end

end

-- override by derived
function TransactionNode:_OnJsonToResult(jsonTbl)
  --[[
  return jsonTbl["path"],jsonTbl["x"],jsonTbl["y"]
  ]]--
end

-- override by derived
function TransactionNode:_OnCheckReady(outputResults)
  -- 输出是否合法 不合法的的话会导致 Reject引脚执行(请求拒绝)
  return true
end

-- override by derived
function TransactionNode:_OnRequestJson()
    --[[
    local requestJson = '{\
      "path" : "%s",\
      "uid" : %d,\
      "loop" : %d,\
      "initialFading" : %f,\
      "deltaFading" : %f\
    }';
    return string.format(requestJson,"/sdcard/",123, 0, 0.2, 0.2)
  ]]--
  return ""
end

-- override by derived
function TransactionNode:_OnRequestType()

end

-- -1 no timeout
-- 0  sync
-- >0 async
TransactionNode:RegisterInput(1, Types.FloatType, "timeout", "超时(毫秒)", -1)
-- create by derived
--TransactionNode:RegisterOutput(1, Types.Tex2DPathType, "x", "x")

TransactionNode:RegisterExecInput(1, "exec", "request");
TransactionNode:RegisterExecOutput(READY_PIN, "ready", "resource ready");
TransactionNode:RegisterExecOutput(TIMEOUT_PIN, "timeout", "超时(output 1 is invalid)");
TransactionNode:RegisterExecOutput(REJECT_PIN, "reject", "request reject")
TransactionNode:SetFunctionType(BD.USER_INTERFACE_NODE);

-- override by derived
TransactionNode:SetFunctionName("N?A");

return TransactionNode;

