local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local Toon = {}
Toon.Do = 0;
Toon.Queue = 310;

function Toon:Initialize(host, size)

  self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TARGETSIZE");

  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/toon.material");
  self.DoMat = host:CreateMaterial(pathout);
  self.DoRO = host:CreateRenderObject();

  self.DoMat:SetParameter(self.TARGETSIZE,size);

  return self.Queue;
end



function Toon:Resizeview(size)
  self.DoMat:SetParameter(self.TARGETSIZE,size);
end

function Toon:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.DoMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.DoRO, self.DoMat);
  context:EndRenderPass();
end

return Toon;