local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local OutlineExpand = {}
OutlineExpand.DoMaterial = 0;
OutlineExpand.DoRenderObj = 0;
OutlineExpand.Queue = 310;

function OutlineExpand:Initialize(host, size)
  self.sigma = mathfunction.vector1(0.0);

  self.SIGMA = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "SIGMA");
  self.TARGETSIZE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "TARGETSIZE");

  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/outline_expand.material");
  self.DoMaterial = host:CreateMaterial(pathout);
  self.DoRenderObj = host:CreateRenderObject();

  self.DoMaterial:SetParameter(self.TARGETSIZE,size);
  self.DoMaterial:SetParameter(self.SIGMA, self.sigma);

  host:RegisterScriptParameter(self, "sigma");
  return self.Queue;
end



function OutlineExpand:Resizeview(size)
  self.DoMaterial:SetParameter(self.TARGETSIZE,size);
end

function OutlineExpand:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.DoMaterial:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );

  self.DoMaterial:SetParameter(self.SIGMA, self.sigma);
	context:Draw(self.DoRenderObj, self.DoMaterial);
  context:EndRenderPass();
end

return OutlineExpand;