


local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local alphachange = {}
alphachange.Do = 0;
alphachange.Queue = 310;

alphachange.alphachangeRenderObj = 0;
alphachange.alphachangeMaterial = 0;


function alphachange:Initialize(host, size)
  
  self.Zoomscale = 50.0;
  self.AlphaValue = 0.5;
  self.AlphaXYoffsest = mathfunction.vector2(0.0,0.0);
  
  self.ALPHA_ZOOMSCALE = apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,
    "ALPHA_ZOOMSCALE");  
    
  self.ALPHA_ALPHAVALUE = apolloengine.IMaterialSystem:NewParameterSlot(
     apolloengine.ShaderEntity.UNIFORM,
      "ALPHA_ALPHAVALUE");  
    
    
  self.ALPHA_XYOFFSET = apolloengine.IMaterialSystem:NewParameterSlot(
     apolloengine.ShaderEntity.UNIFORM,
      "ALPHA_XYOFFSET");    
    
    
  self:CreateInitVal(host,size);

  return self.Queue;
  
end









function alphachange:CreateInitVal(host,size)
  
  local alphachangePath = venuscore.IFileSystem:PathAssembly("comm:documents/material/alphachange.material"); 

  self.alphachangeMaterial = host:CreateMaterial(alphachangePath);
  self.alphachangeRenderObj = host:CreateRenderObject();
  self.alphachangeMaterial:SetParameter(self.ALPHA_ZOOMSCALE, mathfunction.vector1(self.Zoomscale));
  self.alphachangeMaterial:SetParameter(self.ALPHA_ALPHAVALUE, mathfunction.vector1(self.AlphaValue));
  self.alphachangeMaterial:SetParameter(self.ALPHA_XYOFFSET, self.AlphaXYoffsest);




  local targetsize = size;
  
  host:RegisterScriptParameter(self, "Zoomscale");
  host:RegisterScriptParameter(self, "AlphaValue");
  host:RegisterScriptParameter(self, "AlphaXYoffsest");

end

function alphachange:Resizeview(size)

end


function alphachange:Process(context, Original, Scene, Output)
  
  self:_UpdateParameters();
  
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR_DEPTH_STENCIL);
  self.alphachangeMaterial:SetParameter(
    apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
    Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0));
  context:Draw(self.alphachangeRenderObj, self.alphachangeMaterial);
  context:EndRenderPass();
    
end

function alphachange:_UpdateParameters()
  self.alphachangeMaterial:SetParameter(self.ALPHA_ZOOMSCALE,   mathfunction.vector1(self.Zoomscale));
  self.alphachangeMaterial:SetParameter(self.ALPHA_ALPHAVALUE, mathfunction.vector1(self.AlphaValue));
  self.alphachangeMaterial:SetParameter(self.ALPHA_XYOFFSET,  mathfunction.vector2(self.AlphaXYoffsest:x(),self.AlphaXYoffsest:y()));
end

return alphachange;
