

#DEFPARAMS
TEXELSIZE = { "TexelSize", VEC2, "0.0,0.0" },
BLOOM_THRESHOLD = { "BloomThreshold", FLOAT, "0.0" },
#END

#DEFTAG
ShaderName = "SuperMeBlurT"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float2 TEXELSIZE;
float BLOOM_THRESHOLD;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float2 aroundCoord[4];
    float4 d = {-TEXELSIZE.x, -TEXELSIZE.y, TEXELSIZE.x, TEXELSIZE.y};

    aroundCoord[0] = i.uv + d.xy;
    aroundCoord[1] = i.uv + d.zy;
    aroundCoord[2] = i.uv + d.xw;
    aroundCoord[3] = i.uv + d.zw;

    mainColor  = TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, aroundCoord[0] );
    mainColor += TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, aroundCoord[1] );
    mainColor += TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, aroundCoord[2] );
    mainColor += TEXTURE_DIFFUSE.Sample( TEXTURE_DIFFUSE_Sampler, aroundCoord[3] );

    mainColor = mainColor * 0.25;

    float alpha = dot(mainColor.xyz, float3(0.29899999, 0.58700001, 0.114));
    // mainColor.w = max(alpha - bloomThreshold, 0.0);
    mainColor.xyz *= max(alpha - BLOOM_THRESHOLD, 0.0);
    mainColor.xyz /= (1.0 - BLOOM_THRESHOLD);
    //  mainColor.xyz *= 8.0;
}
ENDCG
#END
