#DEFPARAMS

#END

#DEFTAG
ShaderName = "ColorChange"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
float2 TARGETSIZE;
float THRESHOLD;
float REPLACE_MODE;
float HUV;
float SATURATION;
float LIGHTNESS;
float3 SOURCE_COLOR;
float3 TARGET_COLOR;
float SHOW_MASK;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

float3 RGBtoHCV(float3 rgb)
{
	float4 p = (rgb.g < rgb.b) ? float4(rgb.bg, -1.0, 2.0/3.0) : float4(rgb.gb, 0.0, -1.0/3.0);
	float4 q = (rgb.r < p.x) ? float4(p.xyw, rgb.r) : float4(rgb.r, p.yzx);
	
   	float c = q.x - min(q.w, q.y);
	float h = abs((q.w - q.y) / (6.0*c + 1e-7) + q.z);
	float v = q.x;
	
	return float3(h, c, v);
}

float3 RGBToHSL(float3 rgb)
{
	float3 hcv = RGBtoHCV(rgb);
	float lum = hcv.z - hcv.y * 0.5;
	float sat = hcv.y / (1.0 - abs(2.0*lum - 1.0) + 1e-7);
	
	return float3(hcv.x, sat, lum);
}

float3 RGBToHSV(float3 rgb)
{
	float3 hcv = RGBtoHCV(rgb);
	float value = max(max(rgb.r, rgb.g), rgb.b);
    float sat = 0;
    if(value > 0)
    {
    	sat = 1 - min(min(rgb.r, rgb.g), rgb.b) / value;
    }
	
	return float3(hcv.x, sat, value);
}

float3 HUEtoRGB(float hue)
{
	float r = abs(6.0*hue - 3.0) - 1.0;
	float g = 2.0 - abs(6.0*hue - 2.0);
	float b = 2.0 - abs(6.0*hue - 4.0);
	float3 blackColor = float3(0.0, 0.0, 0.0);
	float3 whiteColor = float3(1.0, 1.0, 1.0);
	return clamp(float3(r, g, b), blackColor, whiteColor);
}

float3 HSLToRGB(float3 hsl)
{
	float3 rgb = HUEtoRGB(hsl.x);
	float c = (1.0 - abs(2.0 * hsl.z - 1.0)) * hsl.y;
	rgb = (rgb - 0.5) * c + hsl.z;
	return rgb;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float4 orgColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
    float3 orgColorHSL = RGBToHSL(orgColor.rgb);
    float3 sourceColorHSL = RGBToHSL(SOURCE_COLOR.rgb);
    float3 targetColorHSL = RGBToHSL(TARGET_COLOR.rgb);

    float3 orgColorHSV = RGBToHSV(orgColor.rgb);
    float3 sourceColorHSV = RGBToHSV(SOURCE_COLOR.rgb);
    float3 targetColorHSV = RGBToHSV(TARGET_COLOR.rgb);

    float4 finalColor;

    // float h_dist = min(abs(sourceColorHSL.x - targetColorHSL.x), 1 - max(sourceColorHSL.x, targetColorHSL.x) + min(sourceColorHSL.x, targetColorHSL.x));
    // float s_dist = abs(sourceColorHSV.y - targetColorHSV.y);
    // float b_dist = abs(sourceColorHSV.z - targetColorHSV.z);
    float h_dist = min(abs(sourceColorHSL.x - orgColorHSL.x), 1 - max(sourceColorHSL.x, orgColorHSL.x) + min(sourceColorHSL.x, orgColorHSL.x));
    float s_dist = abs(sourceColorHSV.y - orgColorHSV.y);
    float b_dist = abs(sourceColorHSV.z - orgColorHSV.z);

    if (h_dist < HUV * 0.5 && s_dist < SATURATION && b_dist < LIGHTNESS)
    {
       if (REPLACE_MODE == 1)
       {
           // Huv
           float3 resHSLColor = HSLToRGB(float3(targetColorHSL.r, orgColorHSL.g, orgColorHSL.b));
           finalColor.rgb = resHSLColor;
       }
       else if(REPLACE_MODE == 2)
       {
           // Huv_Lightness
           float3 resHSLColor = HSLToRGB(float3(targetColorHSL.r, orgColorHSL.g, targetColorHSL.b));
           finalColor.rgb = resHSLColor;
       }
       else if(REPLACE_MODE == 3)
       {
           // Huv_Saturation
           float3 resHSLColor = HSLToRGB(float3(targetColorHSL.r, targetColorHSL.g, orgColorHSL.b));
           finalColor.rgb = resHSLColor;
       }
       else if(REPLACE_MODE == 4)
       {
           // Huv_Lightness_Saturation
           finalColor.rgb = TARGET_COLOR.rgb;
       }
       float pos = sqrt(h_dist * h_dist + s_dist * s_dist * 2 + b_dist * b_dist * 0.5) / sqrt(HUV * HUV * 0.25 + SATURATION * SATURATION * 2 + LIGHTNESS * LIGHTNESS * 0.5);
       float factor = 1.0;
       if (THRESHOLD > 1 - pos)
       {
           factor = exp(3 * (1 - pos - THRESHOLD));
       }
       finalColor.rgb = lerp(orgColor.rgb, finalColor.rgb, factor);
       if(REPLACE_MODE == 5)
       {
           // show alpha
           finalColor.rgb = factor;
       }
       if (SHOW_MASK)
       {
           finalColor.rgb = factor;    
       }
    }
    else
    {
        if (SHOW_MASK)
        {
            finalColor.rgb = 0;    
        }
        else
        {
            finalColor = orgColor;
        }
    }

    finalColor.a = 1.0;
    mainColor = finalColor;
}
ENDCG
#END
