CGPROGRAM

#define NUM_THREADS 8
#include "fluid_simulation.inc"

float _Radius, _Amount, _DeltaTime;
float3 _Pos;
RWStructuredBuffer<float> _Write;

#pragma compute GaussImpulse

[numthreads(NUM_THREADS,NUM_THREADS,NUM_THREADS)]
void GaussImpulse(int3 id : SV_DispatchThreadID)
{
 	int idx = dot(id, float3(1, _Size.xw));
	
	float3 wpos = GridCord2WorldPos(float3(id));
	float d = distance(_Pos, wpos);

	float impulse = 0;

	if(d < _Radius) 
	{
		float a = (_Radius - d) * 0.5;
		impulse = min(a, 1.0);
	} 
	
	float source = _Write[idx];
	_Write[idx] = max(0, lerp(source, _Amount, impulse));
	
}

ENDCG

