#DEFPARAMS
diffuseMap = { "diffuseMap", TEXTURE2D, "white" },
specularMap = { "specularMap", TEXTURE2D, "white" },
heightMap = { "heightMap", TEXTURE2D, "white" },

movespeed1 = { "movespeed1", FLOAT, "0.5" },
movespeed2 = { "movespeed2", FLOAT, "0.5" },  
movespeed3 = { "movespeed3", FLOAT, "0.5" },
eyeheight = { "eyeheight", FLOAT, "0.5" },

specoffset1 = { "specoffset1", VEC3, "0.0,0.0,0.0" },
specoffset2 = { "specoffset2", VEC3, "0.0,0.0,0.0" },
specoffset3 = { "specoffset3", VEC3, "0.0,0.0,0.0" },
initoffset = { "initoffset", VEC3, "0.0,0.0,0.0" },
intensity = { "intensity", VEC3, "0.0,0.0,0.0" },


in_LightDirection = { "LIGHT1DIR", VEC3, "0.0,0.0,1.0" },
LIGHT1COLOR = { "LIGHT1COLOR", COLOR, "1.0,1.0,1.0,1.0" },
Light1Intensity = { "LIGHT1INTENSITY", FLOAT, "1.0" },
 
#END

#DEFTAG
ShaderName = "DollEye"
RenderQueue = "Opaque"
#END

#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }
 
CGPROGRAM 
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdbase
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	float2 uv0 : TEXCOORD0; 
    float2 uv1 : TEXCOORD1; 
  
    ANI_ATTRIBUTE
};

struct v2f
{
	float2 uv0 : TEXCOORD0;
    float2 uv1 : TEXCOORD1;
	float4 worldnormal : TEXCOORD2;
    float3 worldPos : TEXCOORD3;
    float3 eyeright: TEXCOORD4; 
    float3 eyeup: TEXCOORD5; 
	float4 vertex : SV_POSITION;
	SHADOW_COORDS(6)
};

Texture2D diffuseMap;
Texture2D specularMap;
Texture2D heightMap;
SamplerState diffuseMap_Sampler;
SamplerState specularMap_Sampler;
SamplerState heightMap_Sampler;

float movespeed1;
float movespeed2;   
float movespeed3;
float eyeheight;
   
float3 specoffset1; 
float3 specoffset2;
float3 specoffset3;
float3 initoffset;
float3 intensity;

float3 in_LightDirection;
float4 LIGHT1COLOR; 
float Light1Intensity;

v2f vert(appdata v)
{
    COMPUTE_BONE_MATERIX(v);
	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);
	o.uv0 = v.uv0.xy;
    o.uv1 = v.uv1;
	float3 worldpos = ObjectToWorldPos(v.vertex).xyz;
	o.worldnormal.xyz = ObjectToWorldNormal(v.normal).xyz;
    o.worldPos = worldpos;

    o.eyeright = ObjectToWorldNormal(float3(1.0, 0.0, 0.0));
    o.eyeup = ObjectToWorldNormal(float3(0.0, 1.0, 0.0));
	
	TRANSFER_SHADOW(o, v.vertex);
	return o;
}   

void frag(in v2f i, out float4 out_Color : SV_Target0)
{
    float2 in_Coordinate0 = i.uv0;
    float2 in_Coordinate1 = i.uv1;

    float3 eyeright = i.eyeright;
    float3 eyeup = i.eyeup;

    float3 viewDir_S = CAMERA_WORLDPOSITION - i.worldPos.xyz;
    float3 vView = normalize(viewDir_S);
    float3 vLight = (in_LightDirection);

    float vr = dot(vView, eyeright);
    float vu = dot(vView, eyeup);

    float2 coord0 = float2(-vr*vr*vr, -vr);
    coord0 *= movespeed1;
    coord0 *= specoffset1.xy;
    coord0 = coord0 + initoffset.xy + float2(in_Coordinate1.x, 1.0 - in_Coordinate1.y);
    coord0.y = 1.0 - coord0.y;

    float specular0 = specularMap.Sample(specularMap_Sampler, coord0).x;

    float2 coord1 = float2(vr, -vu);
    coord1 *= movespeed2;
    coord1 *= specoffset2.xy;
    coord1 = coord1 + initoffset.xy + float2(in_Coordinate1.x, 1.0 - in_Coordinate1.y);
    coord1.y = 1.0 - coord1.y;
    float specular1 = specularMap.Sample(specularMap_Sampler, coord1).y;

    float2 coord2 = abs(float2(vr, vr));
    coord2 *= movespeed3;
    coord2 *= specoffset3.xy;
    coord2 = coord2 + initoffset.xy + float2(in_Coordinate1.x, 1.0 - in_Coordinate1.y);
    coord2.y = 1.0 - coord2.y;

     float specular2 = specularMap.Sample(specularMap_Sampler, coord2).z;

    float totalSpecular = dot(float3(specular0,specular1,specular2), intensity);

    float2 heightOffset = float2(vr, -vu) * eyeheight * 0.5;
    float height0 = heightMap.Sample(heightMap_Sampler, in_Coordinate0).x;

    float2 hcoord1 = float2(height0,height0) * heightOffset + float2(in_Coordinate0.x, 1.0 - in_Coordinate0.y);
    hcoord1.y = 1.0 - hcoord1.y;

    float height1 = heightMap.Sample(heightMap_Sampler, hcoord1).x;

    float2 hcoord2 = float2(height1,height1) * heightOffset + float2(in_Coordinate0.x, 1.0 - in_Coordinate0.y);
    hcoord2.y = 1.0 - hcoord2.y;
    float height2 = heightMap.Sample(heightMap_Sampler, hcoord2).x;

    float2 hcoord3 = float2(height2, height2) * heightOffset + float2(in_Coordinate0.x, 1.0 - in_Coordinate0.y);
    hcoord3.y = 1.0 - hcoord3.y;
    float3 mainColor = diffuseMap.Sample(diffuseMap_Sampler, hcoord3).xyz;
    mainColor *= mainColor;

    float ShadowMask = SHADOW_ATTEN(i); 
    float3 light = LIGHT1COLOR.xyz * Light1Intensity * ShadowMask + AMBIENT_COLOR;
    float3 finalColor = mainColor + float3(totalSpecular, totalSpecular, totalSpecular);
    finalColor *= light;

    out_Color = float4(finalColor, 1.0);     
}
ENDCG
#END

#DEFPASS Depth
	COLOR_MASK = COLOR_RGBA
	ALPAH_MODE = { ALPAH_OFF }
	DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
	STENCIL_MODE = { STENCIL_OFF }
	LIGHT_MODE = { DEPTHPASS }

	CGPROGRAM
	#pragma vertex vert
	#pragma fragment frag
    #pragma multi_compile_skin
	#include "lightpbr.inc"

	struct appdata
	{
		float4 vertex : POSITION;
		float3 normal : NORMAL;
         ANI_ATTRIBUTE
	};
  
	struct v2f
	{
		float4 vertex : SV_POSITION;
	};
 
	v2f vert(appdata v) 
	{
        COMPUTE_BONE_MATERIX(v);
		float4 clipPos = ObjectToClipPos(v.vertex);
		clipPos = ApplyShadowBias(clipPos);

		v2f o;
		o.vertex = UniformNDC(clipPos);
		return o;
	}

	void frag(in v2f i, out float4 mainColor : SV_Target0)
	{
		mainColor = float4(0.0, 0.0, 0.0, 1.0);
	}
	ENDCG
#END