local ActionInfo = require "videodecet.actioninfo";
local Faceinfo = require "videodecet.faceinfo";
local stringsplit = require "stringsplit"

--每个视频对应一个文件
--每一行代表一帧:
--人脸点106*2 
--+ 姿态角pitch/roll/yaw 3 
--+ 人脸矩形区域 2*2 
--+ 人脸动作 1 
--+ 手部矩形框 左上右下 2*2 
--+ 手掌 中心点位置 1*2 
--+ 手部动作 1 + 第二个人...

--空格分开  -1 代表无效  0 代表检测为0 
local facepointcount = 227;
local keypointcount = 106;
local angulercount = 3;
local facerectcount = 2;
local expressioncount = 1;
local handrectcount = 2;
local handcentercount = 1;
local handactioncount =1;


local paserservice = {}

function paserservice:GetKeyPointCount()
  return keypointcount;
end


function paserservice:PaserFile(agent, index, videosize, fullpath)
  for line in io.lines(fullpath) do
    local data = stringsplit(line, "%s", tonumber);
    local faces = {};
    local actions = {};
    local s = #data;
    for i=2, #data, facepointcount do
      local index = i;
      local fi = Faceinfo(videosize);
      for k=1, keypointcount do--提取关键点
        fi:PushKeypoint(data[index], data[index+1]);
        index = index + 2;          
      end
      fi:PushRotation(data[index], data[index+1], data[index+2])
      index = index + 3;
      local rect = {data[index], data[index+1], data[index+2], data[index+3]}
      fi:PushRect(data[index], data[index+1], data[index+2], data[index+3])
      index = index + 4;
      table.insert(faces, fi);
      
      --处理动作
      --脸部动作
      if 0 ~= data[index] then
        local fai = ActionInfo(videosize);
        fai:PushActionID(data[index]);
        fai:PushRect(rect[1], rect[2], rect[3], rect[4]);
        fai:PushCenter((rect[1]+rect[3])/2, (rect[2] + rect[4])/2);
        table.insert(actions, fai);
      end      
      index = index + 1;
      
      --手部动作
      if -1 == data[index] then
        index = index + 7;
      else        
        local hai = ActionInfo(videosize);
        local rl = data[index];
        local rt = data[index+1];
        local rr = data[index+2];
        local rb = data[index+3];
        hai:PushRect(rl, rt, rr, rb);
        index = index + 4;
        hai:PushCenter(data[index], data[index+1])
        index = index + 2;
        hai:PushActionID(data[index])
        index = index + 1;
        table.insert(actions, hai);
      end
    end
    agent:CallbackFunction(index, faces, actions);
  end
end

return paserservice;