local apolloengine = require "apolloengine"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local mathfunction = require "mathfunction"
local defined = require "superme3d.defined"
local beholder = require "superme3d.observer"
local utility = require "superme3d.utility"
local meshnode = require "superme3d.model.meshnode"
local skinednode = require "superme3d.model.skinedrendernode"
local Object = require "classic"



local MeshLoader = {}


--加载mesh
function MeshLoader:Initialize()
  self.rootPath = nil;
  self.modelPathList = nil;
  self.OnParseRootPathEvent = nil;
  self.OnParseModelItemEvent = nil;
  self.OnReleaseResourceEvent = nil;
  self.physicsMesh = {};
  --注册监听事件
  self:RegisterEvents();
  
  --根据设计的换装方案：加载默认部件
  self:LoadDefaultUnit();
end

function MeshLoader:RegisterEvents()
  self.OnParseResourceRootPathEvent = utility:CreateInovation(self,self.ParseRootpath);
  self.OnParseModelPathListEvent = utility:CreateInovation(self,self.ParseModelPathList);
  self.OnParseModelItemEvent = utility:CreateInovation(self,self.ParseModelItem);
  self.OnReleaseResourceEvent = utility:CreateInovation(self,self.ReleaseResource);
  
  beholder.observe(defined.Event.ON_RESOURCE_ROOTPATH,self.OnParseResourceRootPathEvent);
  beholder.observe(defined.Event.ON_RESOURCE_MODEL_LIST,self.OnParseModelPathListEvent);
  beholder.observe(defined.Event.ON_RESOURCE_MODEL_ITEM,self.OnParseModelItemEvent);
  beholder.observe(defined.Event.ON_RELEASE_RESOURCE,self.OnReleaseResourceEvent);
end

function MeshLoader:ParseRootpath(rootPath)
  self.rootPath = rootPath;
end

function MeshLoader:ParseModelPathList(modelPathList)
  self.modelPathList = modelPathList;
end

function MeshLoader:ParseModelItem(itemInfo)
  if itemInfo then
    local exclusionInfo = itemInfo.Exclusion;
    local itemType = itemInfo.ItemType;
    local meshList = itemInfo.Meshes;
    local meshInfoList = {};
    if meshList then
      local meshListCnt = #meshList;
      for i = 1, meshListCnt do
        local mesh = meshList[i];
        local meshName = mesh.Name;
        local boundBox = mesh.boundingbox;
        local boundBoxV = nil;
        if boundBox then
          local bindmin = mesh.boundingbox.min;
          local bindmax = mesh.boundingbox.max;
          boundBoxV = mathfunction.Aabbox3d(
            mathfunction.vector3(bindmin[1],bindmin[2],bindmin[3]),
            mathfunction.vector3(bindmax[1],bindmax[2],bindmax[3]));
        end
        local materialInfo = mesh.Material;   --材质信息
        local KeepSource = mesh.KeepSource;
        table.insert(meshInfoList,{['Name'] = meshName,['Mat'] = materialInfo,['KeepSource'] = KeepSource,['BBox'] = boundBoxV, ['blendshape'] = mesh.blendshape, ['morph'] = mesh.morph}); --mesh名称和材质类型组合到一起
      end
    end
    self:LoadMesh(itemType,exclusionInfo,meshInfoList);
  end
end

--根据所属部件，和材质类型获得材质文件路径
function MeshLoader:GetMaterialPath(materialtype)
  local materialPath = defined.Materials[materialtype];
  if materialPath == nil then
    materialPath = defined.Materials["Simple"];  --默认采用Smple材质
  end
  --for test
  materialPath = defined.Materials["Default"];
  return materialPath;
end


function MeshLoader:GetMeshPath(meshList,meshName)
  local meshKey = "./data/" .. string.lower(meshName) .. ".mesh";
  local meshListCnt = #meshList;
  for i = 1, meshListCnt do
    local meshInfo = meshList[i];
    local meshInfoName = meshInfo.name;
    if meshInfoName == meshKey then
      return meshKey;
    end
  end
  return nil;
end


function MeshLoader:LoadDefaultUnit()
end


--加载mesh
function MeshLoader:LoadMesh(itemType,exclusionInfo,meshInfoList)
  local meshCnt = #meshInfoList;
  local meshNodeList = {};  --保存创建好的meshnode
  for i = 1, meshCnt do
    local meshInfo = meshInfoList[i];
    local meshName = meshInfo['Name'];
    local materialInfo = meshInfo['Mat'];
    local physics = meshInfo[3];
    local boundBox = meshInfo['BBox'];
    local blendshape = meshInfo['blendshape'];
    local morph = meshInfo['morph']
    
    --得到mesh路径
    local meshFullPath = venuscore.IFileSystem:PathAssembly("ress:" .. meshName);
     
    local meshNode = meshnode();
    meshNode:SetShow(false); --先不显示
    if boundBox then
      meshNode:SetBindBox(boundBox);
    else
      ERROR("Bound box is nil");
    end
    if meshInfoList[i].KeepSource~=nil then
      meshNode:SetKeepSource(meshInfoList[i].KeepSource);
    end
    meshNode:SetKeepSource(true);
    --创建mesh
    meshNode:SetMeshPath(meshFullPath, apolloengine.VertexBufferEntity.MU_DYNAMIC);
    beholder.trigger(defined.Event.ON_CREATE_MATERIAL,{meshNode,materialInfo, itemType});  --通知MaterialManager给mesh附加材质
    meshNode:CreateResource();
    if blendshape then
      local dir = venuscore.IFileSystem:PathAssembly("ress:" .. blendshape.path);
      meshNode:AttachBlendshape(dir, blendshape.models);
    end
    if morph then
      local dir = venuscore.IFileSystem:PathAssembly("ress:")
      meshNode:AttachMorpher(dir, morph);
    end
    table.insert(meshNodeList,meshNode);
    --[[
    if physics ~= nil then
			table.insert(self.physicsMesh, meshNode);
			beholder.trigger(defined.Event.ON_CREATE_PHYSICS,physics,meshNode);
		else
			table.insert(meshNodeList,meshNode);
		end]]
    
    
  end
  local meshNodeListCnt = #meshNodeList;
  if meshNodeListCnt > 0 then
    local meshParentNode = skinednode();
    for i = 1, meshNodeListCnt do
      meshParentNode:AttachNode(meshNodeList[i]);
      if meshNodeList[i].blendshape ~= nil or meshNodeList[i].morpher ~= nil then
        beholder.trigger(defined.Event.ON_CREATE_BLENDSHAPE_NODE, {meshNodeList[i]});
      end
    end
    beholder.trigger(defined.Event.ON_CREATE_MESH_NODE,{itemType,exclusionInfo,meshParentNode}); --通知nodemanager 换装部分创建完毕
  end
  beholder.trigger(defined.Event.ON_CREATE_MESH_NODE_FINISHED);
end


function MeshLoader:ReleaseResource()
  self.rootPath = nil;
  self.modelPathList = nil;
  self.OnParseRootPathEvent = nil;
  self.OnParseModelPathListEvent = nil;
  self.OnParseModelItemEvent = nil;
  self.OnReleaseResourceEvent = nil;
end


MeshLoader:Initialize();

return MeshLoader;


