local SequenceAnimation = require "apolloutility.sequenceanimation"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local venusjson = require "venusjson"
local Object = require "classic"
local pupil = require "pupil.pupil"
local pupildefined = require "pupil.pupildefined"
local faceseg = require "videodecet.faceseg"
local videodefined = require "videodecet.defined"
require "venusdebug"



local pupilmanager = {};

function pupilmanager:Initialize(camera)
  self.maincamera = camera; --主相机
  self.pupils = {}
  self.isInitialized = false;
  faceseg:RegisterSegJudgeFunc(videodefined.detectType.IrisDetection,self,self.NeedIrisDetect);
  --self.iris = irisdetection.MachinelearningService();
end

function pupilmanager:LoadConfig(configfile)
  for i=1, pupildefined.pupil_max_people do  --一个人头两个瞳孔
    local pupil_ = pupil(self.maincamera);
    table.insert(self.pupils, pupil_);
  end
  local res = true;
  local config = venusjson.LaodJsonFile(configfile);
  local pupilconfig = config.pupil;
  if pupilconfig then
    local pathDir= string.match(configfile, "(.+)/[^/]*%.%w+$");
    for _, pupil in ipairs(self.pupils) do
      res = pupil:ParseConfig(pupilconfig, pathDir);
    end
    if res == true then
      self.isInitialized = true;
        --开启瞳孔识别
      faceseg:SetSegMark(videodefined.detectType.IrisDetection,true);
      LOG("isInitialized IS TRUE");
    end
  end

  return res;
end


function pupilmanager:Update(timespan)
  
  if self.isInitialized == false then
    return;
  else
    LOG("isInitialized IS TRUE");
  end
  
  --得到瞳孔关键点
  local irisPoints  = faceseg:GetSegKeypointArray(videodefined.detectType.IrisDetection);
  if irisPoints == nil then
    LOG("Iris detect result is null");
    return;
  end
  
  --每两个瞳孔一个pupil结构
  --local peoplecnt = irisPoints:Size() / (20 * 2);
  local irisPointsCnt = #irisPoints;
  local peoplecnt = #irisPoints / 40;
  for i = peoplecnt + 1, pupildefined.pupil_max_people do
    local pupil = self.pupils[i]
    pupil:SetShow(false);
  end
  
  
  --更新
  for index = 1, peoplecnt do
    local pupil = self.pupils[index];
    if pupil then
      pupil:SetShow(true);
      local left_pupil_points = {};
      local right_pupil_points = {};
      --左瞳孔
      --逻辑有问题
      for pointindex = (index - 1) * 40 + 1, (index - 1) * 40 + 20 do
        --local pupil_point = irisPoints:Get(pointindex);
        local pupil_point = irisPoints[pointindex];
        --table.insert(left_pupil_points,{pupil_point:x(),pupil_point:y()});
        table.insert(left_pupil_points,pupil_point);
      end
      --右瞳孔
      for pointindex = (index - 1) * 40 + 21 ,(index - 1) * 40 + 40 do
        --local pupil_point = irisPoints:Get(pointindex);
        local pupil_point = irisPoints[pointindex];
        --table.insert(right_pupil_points,{pupil_point:x(),pupil_point:y()});
        table.insert(right_pupil_points,pupil_point);
      end
      pupil:Update(timespan,left_pupil_points,right_pupil_points);
    end
  end
end

function pupilmanager:ReleaseResource()
  self.pupils = {};
  self.isInitialized = false;
  faceseg:SetSegMark(videodefined.detectType.IrisDetection,false);

end

function pupilmanager:NeedIrisDetect()
  return true;
end

return pupilmanager;