local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local ncnn = require "ncnnfunction"
require "utility"


local pose3dtest = {}


function pose3dtest:Initialize()
  local count = venuscore.IServicesSystem:GetThreadCount();
  self.inmat = ncnn.Mat();
  self.outmat = ncnn.Mat();
  self.net = ncnn.Net();
  self.net:LoadParam("docs:ncnn/ncnn.proto");
  self.net:LoadModel("docs:ncnn/ncnn.bin");
  self.extractor = self.net:CreateExtractor();  
  self.extractor:SetNumThreads(count); 
end


function pose3dtest:Estimates()
  local point2ds = videodecet:GetBodyPoints();--像素坐标
  
  self.inmat:Fill(point2ds);  
  self.extractor:Input("inputs/enc_in", self.inmat);
  self.extractor:Extract("linear_model/add_1", self.outmat);
end
