local apolloengine = require "apolloengine"
local apolloDefine = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local SquareInfo = require "photomood.squareinfo";
local Object = require "classic"
local renderqueue = require "apolloutility.renderqueue"


local LyricRender = Object:extend();


function LyricRender:new(material,initSlots,outlineColor,outlineOffset)
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  self.node = scene:CreateNode(apolloengine.Node.CT_NODE);
  --self.node = apolloengine.Node();
  apolloengine.ShaderEntity.EASING_PROGRESS_PRE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"EASING_PROGRESS_PRE");
  apolloengine.ShaderEntity.EASING_PROGRESS_POST =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"EASING_PROGRESS_POST");
  apolloengine.ShaderEntity.EASING_VALUE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"EASING_VALUE");
  apolloengine.ShaderEntity.ALPHA_EASING_VALUE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"ALPHA_EASING_VALUE");
  apolloengine.ShaderEntity.SLICE_EASING_VALUE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"SLICE_EASING_VALUE");
  apolloengine.ShaderEntity.SCALE_EASING_VALUE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"SCALE_EASING_VALUE");
  apolloengine.ShaderEntity.POSITION_EASING_VALUE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"POSITION_EASING_VALUE");
  apolloengine.ShaderEntity.CUT_VERTICAL_EASING_VALUE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"CUT_VERTICAL_EASING_VALUE");
  apolloengine.ShaderEntity.CUT_HORIZONTAL_EASING_VALUE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"CUT_HORIZONTAL_EASING_VALUE");
  apolloengine.ShaderEntity.ALPHA_VALUE_PRE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"ALPHA_VALUE_PRE");
  apolloengine.ShaderEntity.ORIGIN_SCREEN_POSITION =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"ORIGIN_SCREEN_POSITION");
  apolloengine.ShaderEntity.POSITION_PRE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"POSITION_PRE");
  apolloengine.ShaderEntity.EASING_PROGRESS =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"EASING_PROGRESS");
  apolloengine.ShaderEntity.VERTEX_COLOR =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.ATTRIBUTE,"VERTEX_COLOR");
  apolloengine.ShaderEntity.KTV_EASING_VALUE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"KTV_EASING_VALUE");
  apolloengine.ShaderEntity.ROTATE_EASING_VALUE =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"ROTATE_EASING_VALUE");
  apolloengine.ShaderEntity.INSERT_COLOR =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"INSERT_COLOR");
  self.RECT_SCALE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"RECT_SCALE");
  self.OUTLINE_OFFSET = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"OUTLINE_OFFSET");
  self.OUTLINE_COLOR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"OUTLINE_COLOR");
  self.RECT_CENTER = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"RECT_CENTER");
  self.USE_ORIGIN_COLOR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"USE_ORIGIN_COLOR");

  self.InitUniformMap = {};
  self:SetInitValue(initSlots);


  self.render = self.node:CreateComponent(apolloengine.Node.CT_RENDER);
  self:SetShow(false);


  self.vertexstream = apolloengine.VertexStream();
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,4);
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		4);
  self.vertexstream:ReserveBuffer(4);


  self.indexstream = apolloengine.IndicesStream();
  self.indexstream:SetIndicesType(apolloengine.IndicesBufferEntity.IT_UINT16);
  self.indexstream:ReserveBuffer(6);




  --vertex data

	self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector4(0,0,0,0));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector4(0,0,0,0));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector4(0,0,0,0));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector4(0,0,0,0));
	self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,mathfunction.vector2(0.0,0.0));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,mathfunction.vector2(1.0,0.0));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,mathfunction.vector2(0.0,1.0));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,mathfunction.vector2(1.0,1.0));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0, mathfunction.vector4(0,0,0,255));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0, mathfunction.vector4(0,0,0,255));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0, mathfunction.vector4(0,0,0,255));
  self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0, mathfunction.vector4(0,0,0,255));


  self.indexstream:PushIndicesData(0);  --0
  self.indexstream:PushIndicesData(2);  --2
  self.indexstream:PushIndicesData(3); --3
  self.indexstream:PushIndicesData(0); --0
  self.indexstream:PushIndicesData(3); --3
  self.indexstream:PushIndicesData(1); --1
  --渲染背面描边颜色
  if outlineColor ~= nil then
    self.outlineMaterialEntity = self.render:MakeMaterialAttachment();
    self.outlineMaterialEntity:PushMetadata(
            apolloengine.StringBufferMetadata(material));
    self.outlineMaterialEntity:SetParameter(self.RECT_SCALE,mathfunction.vector1(0.01));
    --材质元数据
    --渲染歌词原始颜色
    self.lyricMaterialEntity = self.render:MakeMaterialAttachment();
    self.lyricMaterialEntity:PushMetadata(
            apolloengine.StringBufferMetadata(material));
    self.lyricMaterialEntity:SetParameter(self.RECT_SCALE,mathfunction.vector1(0.0));
    for i=1,#outlineColor do
      if i == 4 then
        outlineColor[i] = outlineColor[i] / 100.0;
      else
        outlineColor[i] = outlineColor[i] / 255.0;
      end
    end
    self:SetOutlineColor(mathfunction.vector4(outlineColor[1],outlineColor[2],outlineColor[3],outlineColor[4]));
    if outlineOffset ~= nil then
      self:SetOutlineOffset(mathfunction.vector4(outlineOffset[1],outlineOffset[2],outlineOffset[3],outlineOffset[4]));
    else
      self:SetOutlineOffset(mathfunction.vector4(0.5,-0.5,0.0,0.0));
    end
  else
    --材质元数据
    --渲染歌词原始颜色
    self.lyricMaterialEntity = self.render:MakeMaterialAttachment();
    self.lyricMaterialEntity:PushMetadata(
            apolloengine.StringBufferMetadata(material));
    self.lyricMaterialEntity:SetParameter(self.RECT_SCALE,mathfunction.vector1(0.0));
    self:SetOutlineColor(mathfunction.vector4(0.0,0.0,0.0,0.0));
    self:SetOutlineOffset(mathfunction.vector4(0.0,0.0,0.0,0.0));
  end
  --顶点流元数据

  self.render:PushMetadata(
          apolloengine.RenderObjectMeshMetadate(
                  apolloengine.RenderComponent.RM_TRIANGLES,
                  apolloengine.ReferenceVertexMetadata(
                          apolloengine.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
                          self.vertexstream),
                  apolloengine.ReferenceIndicesMetadata(
                          apolloengine.VertexBufferEntity.MU_STATIC,--使用不可修改的显存区域
                          self.indexstream)));

  self.render:CreateResource();

end

function LyricRender:SetInitValue(initValueMap)
  local initValueCnt = #initValueMap;
  for i = 1, initValueCnt do
     local uniformSlot = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,initValueMap[i][1]);
     table.insert(self.InitUniformMap,{uniformSlot,initValueMap[i][2]});
  end
end


function LyricRender:SetShow(isshow)
  if isshow then
    self.render:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  else
    self.render:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
  end
end

function LyricRender:SetInitUniformParams()
  local initValueCnt = #self.InitUniformMap;
  for i = 1, initValueCnt do
    self.render:SetParameter(self.InitUniformMap[i][1],self.InitUniformMap[i][2]);
  end
end

function LyricRender:SetProgress(progress_pre,progress_post)
   self.render:SetParameter(apolloengine.ShaderEntity.EASING_PROGRESS_PRE,mathfunction.vector1(progress_pre));
   self.render:SetParameter(apolloengine.ShaderEntity.EASING_PROGRESS_POST,mathfunction.vector1(progress_post));
end


function LyricRender:SetSequence(s)
  self.render:SetSequence(s);
end


function LyricRender:SetRenderRect(position,size,color,useOriginColor)
  self.vertexArray = {};
  self.texcoordArray = {};
  self.colorArray = {};
  table.insert(self.vertexArray,{position[1],position[2]});
  table.insert(self.vertexArray,{position[1] + size[1], position[2]});
  table.insert(self.vertexArray,{position[1], position[2] - size[2]});
  table.insert(self.vertexArray,{position[1] + size[1], position[2] - size[2]});
  self.render:SetParameter(self.RECT_CENTER, mathfunction.vector4(position[1] + size[1]/2, position[2] - size[2]/2, 0.0, 1.0));
  
  table.insert(self.texcoordArray,{0,0});
  table.insert(self.texcoordArray,{1,0});
  table.insert(self.texcoordArray,{0,1});
  table.insert(self.texcoordArray,{1,1});

  table.insert(self.colorArray,{color[1],color[2],color[3]});
  table.insert(self.colorArray,{color[1],color[2],color[3]});
  table.insert(self.colorArray,{color[1],color[2],color[3]});
  table.insert(self.colorArray,{color[1],color[2],color[3]});

  self.render:SetParameter(self.USE_ORIGIN_COLOR,mathfunction.vector1(useOriginColor));
end

--设置描边颜色
function LyricRender:SetOutlineColor(color)
  self.render:SetParameter(self.OUTLINE_COLOR,color);
end

--设置描边偏移
function LyricRender:SetOutlineOffset(offset)
  self.render:SetParameter(self.OUTLINE_OFFSET,offset);
end



--更新顶点流
function LyricRender:Update(diffusetexture)
  local newpoint =  mathfunction.vector4(0, 0, 0, 1);
  local newtexcoord = mathfunction.vector2(0,0);
  local newColor = mathfunction.vector4(0,0,0,1);
  local index_vertex = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_POSITION);
  local index_texcoord = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0);
  local index_color = self.vertexstream:GetAttributeIndex(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0);

  for i = 1, #self.vertexArray do
    local point = self.vertexArray[i];
    newpoint:Set(point[1],point[2],0,1);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
      index_vertex,
      i,
      newpoint);
  end

  for i = 1, #self.texcoordArray do
	local texcoord = self.texcoordArray[i];
    newtexcoord:Set(texcoord[1],texcoord[2]);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
      index_texcoord,
      i,
      newtexcoord);
  end

  for i = 1, #self.colorArray do
    local color = self.colorArray[i];
    newColor:Set(color[1]/255,color[2]/255,color[3]/255,1);
    self.vertexstream:ChangeVertexDataWithAttributeFast(
      index_color,
      i,
      newColor);
  end

  self.render:SetParameter(
      apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
      diffusetexture);
  self:SetInitUniformParams();

  self.vertexstream:SetReflushInterval(1, 4);
  self.render:ChangeVertexBuffer(self.vertexstream);
end

--新的renderqueue要求传一个Node进去，但是C++的Node是没有SetSequence函数的
--这里Hack下，传递renderomponent下去
function LyricRender:After()
  renderqueue:After(self.node)
end

function LyricRender:Clear()
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  if not venuscore.isNil(self.node) then  --防止Node重复删除(因为删除父Node会递归删除子Node)
    scene:DeleteNode(self.node);
  end
end

return LyricRender;