local Object = require "classic"
local videodefined = require"videodecet.defined"
local apolloengine = require "apolloengine"
local vc = require "venuscore"
local likeapp = require "likeapp"
local apollonode = require "apolloutility.apollonode"
local mathfunction = require "mathfunction"
local videodetect = require "videodecet.videodecet"
local venusjson = require "venusjson"
local machineLearning = require "machinelearningservice"


local main = {}

function main:CreateCameras(near, far, pos, lookat, up)  
    self.maincamera = apollonode.CameraNode();--新建摄像机
    self.maincamera:CreatePerspectiveProjection(near, far);--设置摄像机
    self.maincamera:LookAt(pos, lookat, up);
    self.maincamera:Activate();--激活主摄像机
end

function main:Initialize()
    _COROUTINES_ON();

    self:CreateCameras(1, 1000,
    mathfunction.vector3(0,0,2.5),
		mathfunction.vector3(0,0,0),
		mathfunction.vector3(0,1,0));

    self.diffuseTex = apolloengine.TextureEntity();
    self.depthTex   = apolloengine.TextureEntity();

    self.diffuseTex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_LINEAR,
        apolloengine.TextureEntity.TF_LINEAR,
        "docs:parallax/car.jpg"));
    self.diffuseTex:CreateResource();

    self.depthTex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_NEAREST,
        apolloengine.TextureEntity.TF_NEAREST,
        "docs:parallax/car_d.png"));    
      
    self.depthTex:CreateResource();

    apolloengine.ShaderEntity.TEXTURE_DIFFUSE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_DIFFUSE");
    apolloengine.ShaderEntity.TEXTURE_DEPTH   = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"TEXTURE_HEIGHT");
    apolloengine.ShaderEntity.WORLDSPACE_VIEWDIRECTION = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.INTERNAL,"VIEW_DIR");
    apolloengine.ShaderEntity.UNI_VIEW_POS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"UNI_VIEW_POS");
    
    --apolloengine.ShaderEntity.MOUSE_MOVE      = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"MOUSE_MOVE");

    self.quadNode = apollonode.QuadNode();
    self.quadNode:SetShow(true);
    self.quadNode:CreateResource("comm:documents/material/parallax.material", true);
    self.quadNode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.diffuseTex); 
    self.quadNode:SetParameter(apolloengine.ShaderEntity.TEXTURE_DEPTH, self.depthTex); 
    self.distance = 10;
    self.quadNode:SetParameter(apolloengine.ShaderEntity.UNI_VIEW_POS, mathfunction.vector3(0,0,self.distance)); 
    self.quadNode:SetSequence(0);
    self.quadNode:SetLocalScale(  mathfunction.vector3(638/235,1,1)  );

    apolloengine.Framework:AddTouchCallback(self._Agent, "OnTouch");
    self.bias = 0;
    self.speed = 0.01;
    _COROUTINES_OFF();
end



function main:OnTouch(touchinfo)
    _COROUTINES_ON();
    
    local vec2 = touchinfo:GetTouchPoint(1);
    local tt = touchinfo:GetTouchType(1);
    if apolloengine.TouchInfo.TT_PRESS == tt  then
      self.point = vec2;
    elseif apolloengine.TouchInfo.TT_MOVE == tt then
      local rd = vec2 - self.point;
      --self.point = vec2;
      local scale = 1.20;
      local campos = mathfunction.vector3(rd:x()*scale,rd:y()*scale,self.distance)
      local lookat = mathfunction.vector3(rd:x()*scale,rd:y()*scale,0)
      local uppos = mathfunction.vector3(0,1,0);
      self.quadNode:SetParameter(apolloengine.ShaderEntity.UNI_VIEW_POS, campos); 
  
      --self.maincamera:LookAt(campos, lookat, uppos);
      
    end
    _COROUTINES_OFF();
end

return main;