local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local math = require "math"
local apolloengine = require "apolloengine"
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
--local filterqueue = require "apolloutility.filterqueue"
local defined = require "apolloutility.defiend"
local splicehistoricalframe = require "historicalframe.splicehistoricalframe"
local videodetect = require "videodecet"

local dustmain={};

local Stored_Frame_Size = mathfunction.vector2(180, 320);
local Stored_Frame_Num = 60;
local Frequency = 1;
local Sequence = -76543;
local Inteval = 0.2;
local Resolution = {720, 1280};
local Sample_Size = {8, 8};
local Historical_Frames = 20;

local MAX_SUPPORT_TEX_NUM = 4;

function dustmain:Initialize(cameraLayer, config)
  self.cameraLayer = cameraLayer
  local maincamera = renderqueue:GetCamera(self.cameraLayer);
  if maincamera == nil then
    return;
  end
  
  self.splice = splicehistoricalframe(
    self.cameraLayer,
    Stored_Frame_Num,Sequence, 
    Frequency, 
    defined.blit_material_path,
    Stored_Frame_Size
  );
  self.config = config;

  self.post = maincamera:CreatePostEffect();
  self.post:CreateResource("comm:script/apolloengine/posteffect/dust.lua");  

  -- create noise texture
  local texture_path = config.texture;
  if texture_path == nil then
      return;
  end
  texture_path = venuscore.IFileSystem:PathAssembly(texture_path);
  local tex = apolloengine.TextureEntity();
  tex:PushMetadata(apolloengine.TextureFileMetadata(
        apolloengine.TextureEntity.TU_STATIC,
        apolloengine.TextureEntity.PF_AUTO,
        1, false,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
        apolloengine.TextureEntity.TF_LINEAR,
        apolloengine.TextureEntity.TF_LINEAR,
        texture_path));
  tex:CreateResource();
  self.noise_texture = tex;

  local material_path = venuscore.IFileSystem:PathAssembly("docs:material/dust.material");
  if not (self:SetShaderParameters(material_path, config)) then
    self:Clear();
    return;
  end
end

function dustmain:Clear()
  local maincamera = renderqueue:GetCamera(self.cameraLayer);
  maincamera:DeletePostEffect(self.post);
  self.post = nil;
  self.splice:Clear();
  self.splice = nil;  
  self.noise_texture = nil;
end

function dustmain:CreateEmptyTexture()
  local texstream = apolloengine.TextureStream();
  texstream:SetStreamType(
    mathfunction.vector2(4,1),
    apolloengine.TextureEntity.PF_R8G8B8A8);
  
  for u=1, 4 do
    texstream:SetPixel(u, 1, mathfunction.vector4(0,0,0,0));
  end
  
  local tex = apolloengine.TextureEntity();
  tex:PushMetadata(apolloengine.TextureBufferMetadata(
      apolloengine.TextureEntity.TU_STATIC,
      1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      texstream));
  tex:CreateResource();
  return tex;
end

function dustmain:SetShaderParameters(material_path, config)
  self.post:RegisterParameter("FRAME_SIZE", material_path);
  self.post:RegisterParameter("CUR_FRAME_ID", material_path);
  self.post:RegisterParameter("RESOLUTION", material_path);
  self.post:RegisterParameter("SAMPLE_SIZE", material_path);
  self.post:RegisterParameter("HISTORICAL_FRAMES", material_path);
  self.post:RegisterParameter("ROW_FRAME_NUM_PER_TEX", material_path);
  self.post:RegisterParameter("COL_FRAME_NUM_PER_TEX", material_path);
  self.post:RegisterParameter("NOISE_TEXTURE", material_path);

  if ( self.splice.bigtexnum  > MAX_SUPPORT_TEX_NUM) then
    return false;
  end

  for i = 1, MAX_SUPPORT_TEX_NUM do
    self.post:RegisterParameter("HISTORICAL_FRAME"..i, material_path);
  end

  self.post:FRAME_SIZE(mathfunction.vector1(self.splice.framNum));
  self.post:CUR_FRAME_ID(mathfunction.vector1(0));

  local resolution = config.resolution or Resolution;
  self.post:RESOLUTION(mathfunction.vector2(resolution[1], resolution[2]));

  local sample_size = config.sample_size or Sample_Size;
  self.post:SAMPLE_SIZE(mathfunction.vector2(sample_size[1], sample_size[2]));

  local row_frames = self.splice.wcount;
  self.post:ROW_FRAME_NUM_PER_TEX(mathfunction.vector1(row_frames));
  
  local col_frames = self.splice.hcount;
  self.post:COL_FRAME_NUM_PER_TEX(mathfunction.vector1(col_frames));
  
  local historical_frames = config.historical_frames or Historical_Frames;
  self.post:HISTORICAL_FRAMES(mathfunction.vector1(historical_frames));  
  
  local tex = self:CreateEmptyTexture();
  for i = 1, MAX_SUPPORT_TEX_NUM do
    self.post["HISTORICAL_FRAME"..i](self.post, tex);
  end

  self.post:NOISE_TEXTURE(self.noise_texture);
  return true;
end

function dustmain:Update(def)
  if self.splice == nil then
    return;
  end

  local tex = renderqueue:GetLinkedTexture(self.cameraLayer)
  if tex == nil then
    return;
  end
  
  self.splice:SetVideoTexture(tex);
  self.splice:SetShow(true);
  self.tex,self.newframe,self.isGetEnoughFrame,self.isBegin= self.splice:Update();
  self:SetShow(self.isBegin);

  if self.isBegin == true then
    self.post:CUR_FRAME_ID(mathfunction.vector1(self.newframe - 1));
    for i = 1, #self.tex do
      self.post["HISTORICAL_FRAME"..i](self.post, self.tex[i]);
    end
  end 
end

function dustmain:Exit()
  self:Clear();
end

function dustmain:SetShow(show)
  if self.post then
    if show then
      self.post:Enable()
    else
      self.post:Disable()
    end
  end
end

return dustmain;